/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.joauth;

import com.twitter.joauth.Base64Util;
import com.twitter.joauth.NonceValidator;
import com.twitter.joauth.Signer;
import com.twitter.joauth.UnpackedRequest;
import com.twitter.joauth.UrlCodec;
import com.twitter.joauth.VerifierResult;
import java.util.logging.Level;
import java.util.logging.Logger;

public interface Verifier {
    public static final int NO_TIMESTAMP_CHECK = -1;

    public VerifierResult verify(UnpackedRequest.OAuth1Request var1, String var2, String var3);

    public VerifierResult verify(UnpackedRequest.OAuth1TwoLeggedRequest var1, String var2);

    public static class StandardVerifier
    implements Verifier {
        private final Signer signer;
        private final int maxClockFloatAheadMins;
        private final int maxClockFloatBehindMins;
        private final NonceValidator validateNonce;
        private final long maxClockFloatAheadSecs;
        private final long maxClockFloatBehindSecs;
        private static final Logger log = Logger.getLogger("StandardVerifier");

        public StandardVerifier(Signer signer, int maxClockFloatAheadMins, int maxClockFloatBehindMins, NonceValidator validateNonce) {
            this.signer = signer;
            this.maxClockFloatAheadMins = maxClockFloatAheadMins;
            this.maxClockFloatBehindMins = maxClockFloatAheadMins;
            this.validateNonce = validateNonce;
            this.maxClockFloatAheadSecs = (long)maxClockFloatAheadMins * 60L;
            this.maxClockFloatBehindSecs = (long)maxClockFloatBehindMins * 60L;
        }

        @Override
        public VerifierResult verify(UnpackedRequest.OAuth1TwoLeggedRequest request, String consumerSecret) {
            return this.verifyOAuth1(request, request.nonce(), request.timestampSecs(), "", consumerSecret, request.signature(), request.normalizedRequest());
        }

        @Override
        public VerifierResult verify(UnpackedRequest.OAuth1Request request, String tokenSecret, String consumerSecret) {
            return this.verifyOAuth1(request, request.nonce(), request.timestampSecs(), tokenSecret, consumerSecret, request.signature(), request.normalizedRequest());
        }

        private VerifierResult verifyOAuth1(UnpackedRequest.OAuthRequest request, String nonce, long timestampSecs, String tokenSecret, String consumerSecret, String signature, String normalizedRequest) {
            if (!this.validateTimestampSecs(timestampSecs)) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, String.format("bad timestamp -> %s", request.toString()));
                }
                return VerifierResult.BAD_TIMESTAMP;
            }
            if (!this.validateNonce.validate(nonce)) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, String.format("bad nonce -> %s", request.toString()));
                }
                return VerifierResult.BAD_NONCE;
            }
            if (!this.validateSignature(normalizedRequest, signature, tokenSecret, consumerSecret)) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, String.format("bad signature -> %s", request.toString()));
                }
                return VerifierResult.BAD_SIGNATURE;
            }
            return VerifierResult.OK;
        }

        public boolean validateTimestampSecs(long timestampSecs) {
            long nowSecs = System.currentTimeMillis() / 1000L;
            return !(this.maxClockFloatBehindMins >= 0 && timestampSecs < nowSecs - this.maxClockFloatBehindSecs || this.maxClockFloatAheadMins >= 0 && timestampSecs > nowSecs + this.maxClockFloatAheadSecs);
        }

        boolean validateSignature(String normalizedRequest, String signature, String tokenSecret, String consumerSecret) {
            try {
                return Base64Util.equals(UrlCodec.decode(signature).trim(), this.signer.getBytes(normalizedRequest, tokenSecret, consumerSecret));
            }
            catch (Exception e) {
                return false;
            }
        }
    }

    public static class VerifierFactory {
        public static Verifier newVerifier() {
            return VerifierFactory.newVerifier(Signer.getStandardSigner(), -1, -1, NonceValidator.NO_OP_NONCE_VALIDATOR);
        }

        public static Verifier newVerifier(int maxClockFloatAheadMins, int maxClockFloatBehindMins) {
            return VerifierFactory.newVerifier(Signer.getStandardSigner(), maxClockFloatAheadMins, maxClockFloatBehindMins, NonceValidator.NO_OP_NONCE_VALIDATOR);
        }

        public static Verifier newVerifier(int maxClockFloatAheadMins, int maxClockFloatBehindMins, NonceValidator validateNonce) {
            return VerifierFactory.newVerifier(Signer.getStandardSigner(), maxClockFloatAheadMins, maxClockFloatBehindMins, validateNonce);
        }

        public static Verifier newVerifier(Signer sign, int maxClockFloatAheadMins, int maxClockFloatBehindMins, NonceValidator validateNonce) {
            return new StandardVerifier(sign, maxClockFloatAheadMins, maxClockFloatBehindMins, validateNonce);
        }
    }
}

