/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services.catalog;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.dataiku.dip.DSSMetrics;
import com.dataiku.dip.server.notifications.backend.BackendEvent;
import com.dataiku.dip.server.services.catalog.LuceneIndexManager;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.org.apache.lucene.index.Term;
import com.dataiku.dss.shadelib.org.apache.lucene.search.BooleanClause;
import com.dataiku.dss.shadelib.org.apache.lucene.search.BooleanQuery;
import com.dataiku.dss.shadelib.org.apache.lucene.search.Query;
import com.dataiku.dss.shadelib.org.apache.lucene.search.TermQuery;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public abstract class AbstractIndexingQueueHandler
implements Runnable {
    final BlockingQueue<BackendEvent> queue = new LinkedBlockingQueue<BackendEvent>();
    private final String threadName;
    protected boolean initialized = false;
    protected static Gson gson = new GsonBuilder().serializeNulls().create();
    protected static final DKULogger logger = DKULogger.getLogger((String)"dku.catalog.queue");

    public abstract void handleQueueEvent(BackendEvent var1) throws Exception;

    protected AbstractIndexingQueueHandler(String indexName) {
        this.threadName = indexName + "-queue-handler";
        DSSMetrics.registry().register("dku.catalog.indexing.queue." + indexName + ".size", (Metric)((Gauge)this.queue::size));
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public void run() {
        Thread.currentThread().setName(this.threadName);
        try {
            BackendEvent event;
            while ((event = this.queue.take()) != null) {
                DKULogger.startCurrentCall();
                if (logger.isDebugEnabled()) {
                    logger.debugV("Indexer handling event type=%s", new Object[]{event.getName()});
                }
                try {
                    this.handleQueueEvent(event);
                }
                catch (Throwable e) {
                    logger.error((Object)("Background indexing failed after " + event.getName() + " event"), e);
                }
                if (logger.isDebugEnabled()) {
                    logger.debugV("Indexer done handling event type=%s", new Object[]{event.getName()});
                }
                DKULogger.endCurrentCall();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.error((Object)"Indexer thread interrupted", (Throwable)e);
        }
    }

    protected void deleteByQuery(LuceneIndexManager luceneIndexManager, Query query) throws IOException, InterruptedException {
        luceneIndexManager.deleteDocuments(query);
    }

    protected void deleteById(LuceneIndexManager luceneIndexManager, Query typeFilterQuery, String id) throws IOException, InterruptedException {
        BooleanQuery.Builder booleanQueryBuilder = new BooleanQuery.Builder();
        booleanQueryBuilder.add((Query)new TermQuery(new Term("_id", id)), BooleanClause.Occur.FILTER);
        booleanQueryBuilder.add(typeFilterQuery, BooleanClause.Occur.FILTER);
        BooleanQuery booleanQuery = booleanQueryBuilder.build();
        luceneIndexManager.deleteDocuments((Query)booleanQuery);
    }

    protected void deleteById(LuceneIndexManager luceneIndexManager, String type, String id) throws IOException, InterruptedException {
        this.deleteById(luceneIndexManager, (Query)new TermQuery(new Term("_type", type)), id);
    }
}

