/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibpoi.org.apache.poi.hssf.record;

import com.dataiku.dss.shadelibpoi.org.apache.poi.common.usermodel.GenericRecord;
import com.dataiku.dss.shadelibpoi.org.apache.poi.hssf.record.CodepageRecord;
import com.dataiku.dss.shadelibpoi.org.apache.poi.hssf.record.HSSFRecordTypes;
import com.dataiku.dss.shadelibpoi.org.apache.poi.hssf.record.OldStringRecord;
import com.dataiku.dss.shadelibpoi.org.apache.poi.hssf.record.RecordInputStream;
import com.dataiku.dss.shadelibpoi.org.apache.poi.hssf.usermodel.HSSFWorkbook;
import com.dataiku.dss.shadelibpoi.org.apache.poi.util.GenericRecordJsonWriter;
import com.dataiku.dss.shadelibpoi.org.apache.poi.util.GenericRecordUtil;
import com.dataiku.dss.shadelibpoi.org.apache.poi.util.IOUtils;
import com.dataiku.dss.shadelibpoi.org.apache.poi.util.RecordFormatException;
import java.io.IOException;
import java.util.Map;
import java.util.function.Supplier;

public final class OldSheetRecord
implements GenericRecord {
    public static final short sid = 133;
    private final int field_1_position_of_BOF;
    private final int field_2_visibility;
    private final int field_3_type;
    private final byte[] field_5_sheetname;
    private CodepageRecord codepage;

    public OldSheetRecord(RecordInputStream in) {
        this.field_1_position_of_BOF = in.readInt();
        this.field_2_visibility = in.readUByte();
        this.field_3_type = in.readUByte();
        int field_4_sheetname_length = in.readUByte();
        if (field_4_sheetname_length > 0) {
            in.mark(1);
            byte b = in.readByte();
            if (b != 0) {
                try {
                    in.reset();
                }
                catch (IOException e) {
                    throw new RecordFormatException(e);
                }
            }
        }
        this.field_5_sheetname = IOUtils.safelyAllocate(field_4_sheetname_length, HSSFWorkbook.getMaxRecordLength());
        in.read(this.field_5_sheetname, 0, field_4_sheetname_length);
    }

    public void setCodePage(CodepageRecord codepage) {
        this.codepage = codepage;
    }

    public short getSid() {
        return 133;
    }

    public int getPositionOfBof() {
        return this.field_1_position_of_BOF;
    }

    public String getSheetname() {
        return OldStringRecord.getString(this.field_5_sheetname, this.codepage);
    }

    public HSSFRecordTypes getGenericRecordType() {
        return HSSFRecordTypes.BOUND_SHEET;
    }

    @Override
    public Map<String, Supplier<?>> getGenericProperties() {
        return GenericRecordUtil.getGenericProperties("bof", this::getPositionOfBof, "visibility", () -> this.field_2_visibility, "type", () -> this.field_3_type, "sheetName", this::getSheetname);
    }

    public String toString() {
        return GenericRecordJsonWriter.marshal(this);
    }
}

