/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibpoi.org.apache.poi.ss.formula.functions;

import com.dataiku.dss.shadelibpoi.org.apache.logging.log4j.Logger;
import com.dataiku.dss.shadelibpoi.org.apache.poi.logging.PoiLogManager;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.formula.eval.ErrorEval;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.formula.eval.EvaluationException;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.formula.eval.NumberEval;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.formula.eval.OperandResolver;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.formula.eval.ValueEval;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.formula.functions.Fixed1ArgFunction;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.usermodel.DateUtil;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.util.DateParser;
import java.time.DateTimeException;

public class DateValue
extends Fixed1ArgFunction {
    private static final Logger LOG = PoiLogManager.getLogger(DateValue.class);

    @Override
    public ValueEval evaluate(int srcRowIndex, int srcColumnIndex, ValueEval dateTextArg) {
        try {
            String dateText = OperandResolver.coerceValueToString(OperandResolver.getSingleValue(dateTextArg, srcRowIndex, srcColumnIndex));
            if (dateText == null || dateText.isEmpty()) {
                return ErrorEval.VALUE_INVALID;
            }
            return new NumberEval(DateUtil.getExcelDate(DateParser.parseLocalDate(dateText)));
        }
        catch (DateTimeException dte) {
            LOG.atInfo().log("Failed to parse date", (Object)dte);
            return ErrorEval.VALUE_INVALID;
        }
        catch (EvaluationException e) {
            return e.getErrorEval();
        }
    }
}

