/*
 * Decompiled with CFR 0.152.
 */
package io.delta.storage.internal;

import java.io.IOException;

public class LogStoreErrors {
    public static boolean isNonFatal(Throwable throwable) {
        return !(throwable instanceof VirtualMachineError) && !(throwable instanceof ThreadDeath) && !(throwable instanceof InterruptedException) && !(throwable instanceof LinkageError);
    }

    public static boolean isFatal(Throwable throwable) {
        return !LogStoreErrors.isNonFatal(throwable);
    }

    public static IOException incorrectLogStoreImplementationException(Throwable throwable) {
        return new IOException(String.join((CharSequence)"\n", "The error typically occurs when the default LogStore implementation, that", "is, HDFSLogStore, is used to write into a Delta table on a non-HDFS storage system.", "In order to get the transactional ACID guarantees on table updates, you have to use the", "correct implementation of LogStore that is appropriate for your storage system.", "See https://docs.delta.io/latest/delta-storage.html for details."), throwable);
    }
}

