/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.agents.tools.custom;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.agents.tools.AgentToolsRegistry;
import com.dataiku.dip.agents.tools.custom.CustomAgentToolDesc;
import com.dataiku.dip.agents.tools.custom.CustomAgentToolMeta;
import com.dataiku.dip.agents.tools.custom.LoadedCustomAgentTool;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.custom.AbstractElementService;
import com.dataiku.dip.custom.PluginComponentDescValidator;
import com.dataiku.dip.plugins.IPluginsRegistryService;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import java.io.File;
import java.io.IOException;
import org.springframework.stereotype.Service;

@Service
public class CustomAgentToolsService
extends AbstractElementService<CustomAgentToolDesc, LoadedCustomAgentTool> {
    protected static DKULogger logger = DKULogger.getLogger((String)"dku.genai.agents.tools");

    @Override
    public String getFolderName() {
        return "python-agent-tools";
    }

    @Override
    public String getPrefix() {
        return "tool";
    }

    @Override
    protected String getCodeExtension(LoadedCustomAgentTool desc) {
        return "";
    }

    @Override
    public Class<CustomAgentToolDesc> getDescClass() {
        return CustomAgentToolDesc.class;
    }

    @Override
    public Class<LoadedCustomAgentTool> getLoadedDescClass() {
        return LoadedCustomAgentTool.class;
    }

    @Override
    protected void removeElement(LoadedCustomAgentTool desc) {
    }

    @Override
    protected String makeType(String pluginId, String elementId) {
        return "agent_tool_" + pluginId + "_" + elementId;
    }

    @Override
    protected LoadedCustomAgentTool load(String elementType, String pluginId, String elementId, File file) throws IOException {
        CustomAgentToolDesc desc = (CustomAgentToolDesc)JSON.parseFile((File)file, CustomAgentToolDesc.class);
        desc.id = elementType;
        LoadedCustomAgentTool loaded = new LoadedCustomAgentTool(elementType, pluginId, elementId, desc);
        CustomAgentToolMeta stepMeta = new CustomAgentToolMeta(loaded);
        AgentToolsRegistry.register(stepMeta);
        return loaded;
    }

    @Override
    public InfoMessage.InfoMessages validate(String componentId, String pluginId, final CustomAgentToolDesc desc) {
        return new PluginComponentDescValidator(componentId){

            @Override
            public InfoMessage.InfoMessages validate() {
                if (desc.params != null) {
                    this.genericValidateParams(desc.params, CustomAgentToolsService.this.getPrefix());
                }
                this.genericValidateMeta(desc.meta);
                return this.messages;
            }
        }.validate();
    }

    public String getPythonLibFolder(String elementType) {
        if (!this.loadedDescs.containsKey(elementType)) {
            throw new CodedRuntimeException((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_COMPONENT_NOT_INSTALLED, "Element " + elementType + " not found.");
        }
        LoadedCustomAgentTool loadedDesc = (LoadedCustomAgentTool)this.loadedDescs.get(elementType);
        File libDir = this.pluginsService.getPluginPythonlibFolder(loadedDesc.getOwnerPluginId());
        return libDir.getAbsolutePath();
    }
}

