/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.aigenerations.recipes;

import com.dataiku.dip.aigenerations.AIRecipeGenerationService;
import com.dataiku.dip.aigenerations.recipes.AIRecipe;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.dataflow.exec.sync.SyncRecipeParams;
import com.dataiku.dip.i18n.TranslationService;
import com.dataiku.dip.server.SpringUtils;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.List;

public class AISync
extends AIRecipe {
    public static final String type = "sync";
    public Params params;

    @Override
    protected List<AIRecipeGenerationService.CreationMessage> validate(List<Dataset> datasets, String contextProjectKey, String lang) {
        ArrayList<AIRecipeGenerationService.CreationMessage> creationMessages = new ArrayList<AIRecipeGenerationService.CreationMessage>();
        this.params.checkSingleInputDataset(datasets, type, contextProjectKey);
        this.params.checkSingleOutputDataset(type);
        TranslationService ts = (TranslationService)SpringUtils.getBean(TranslationService.class);
        if (this.params.output_connection.isEmpty()) {
            creationMessages.add(new AIRecipeGenerationService.CreationMessage(AIRecipeGenerationService.CreationMessage.Level.WARNING, ts.translateNoContext(lang, "RIGHT_PANEL.TABS.GENERATE_RECIPE.SYNC.EMPTY_OUTPUT_CONNECTION", "We were unable to detect what connection to sync the dataset to.", new Object[0])));
        }
        return creationMessages;
    }

    @Override
    public AIRecipeGenerationService.AIMetaCreation generateRecipeMetaPayload(AIRecipeGenerationService.RecipeGenerationContext recipeGenerationContext) throws Exception {
        AIRecipeGenerationService.AIMetaCreation metaCreation = new AIRecipeGenerationService.AIMetaCreation();
        metaCreation.messages = this.validate(recipeGenerationContext.datasets, recipeGenerationContext.contextProjectKey, recipeGenerationContext.lang);
        SyncRecipeParams recipeParams = new SyncRecipeParams();
        metaCreation.datasetInputNames = List.of(this.params.input_dataset);
        metaCreation.datasetOutputNames = List.of(this.params.output_dataset);
        metaCreation.payload = new Gson().toJson((Object)recipeParams);
        return metaCreation;
    }

    public static class Params
    extends AIRecipe.AIRecipeParams {
        public String output_connection;
    }
}

