/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.docgen.extractor;

import com.dataiku.dip.analysis.docgen.extractor.ModelExtractor;
import com.dataiku.dip.analysis.model.ModelDetailsBase;
import com.dataiku.dip.analysis.model.clustering.ClusteringModelDetails;
import com.dataiku.dip.analysis.model.prediction.ClassicalPredictionModelDetails;
import com.dataiku.dip.analysis.model.prediction.TimeseriesForecastingModelDetails;
import com.jayway.jsonpath.DocumentContext;
import java.io.IOException;

public class SampleRowCountExtractor
implements ModelExtractor<String> {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String extract(DocumentContext documentContext, ModelDetailsBase model) throws IOException {
        if (model instanceof ClusteringModelDetails && model.splitDesc != null) {
            if (model.splitDesc.fullRows != 0L) return Long.toString(model.splitDesc.fullRows);
            if (model.trainInfo == null || model.trainInfo.fullRows == null) throw new IOException("Cannot retrieve the sample row count.");
            return model.trainInfo.fullRows.toString();
        }
        if (model instanceof ClassicalPredictionModelDetails && model.trainInfo != null) {
            if (model.trainInfo.kfold) {
                if (model.trainInfo.fullRows == null) throw new IOException("Cannot retrieve the sample row count.");
                return model.trainInfo.fullRows.toString();
            }
            if (model.trainInfo.trainRows == null) throw new IOException("Cannot retrieve the sample row count.");
            return model.trainInfo.trainRows.toString();
        }
        if (!(model instanceof TimeseriesForecastingModelDetails) || model.trainInfo == null || model.trainInfo.fullRows == null) throw new IOException("Cannot retrieve the sample row count.");
        return model.trainInfo.fullRows.toString();
    }
}

