/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.ml.prediction.split;

import com.dataiku.dip.analysis.coreservices.AnalysisDataService;
import com.dataiku.dip.analysis.ml.MLTaskLoc;
import com.dataiku.dip.analysis.ml.prediction.split.SplitDesc;
import com.dataiku.dip.analysis.model.core.AnalysisCoreParams;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class SplitGenerator {
    @Autowired
    private AnalysisDataService analysisDataService;
    protected MLTaskLoc taskLoc;
    protected AnalysisCoreParams coreParams;
    protected AuthCtx authCtx;
    protected String scriptStepsStr;
    protected String scriptStepsPrettyStr;
    private static final Multimap<MLTaskLoc, String> splitsBeingComputed = HashMultimap.create();
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.analysis.splits");

    public SplitGenerator(MLTaskLoc taskLoc, AnalysisCoreParams coreParams, AuthCtx authCtx) {
        this.taskLoc = taskLoc;
        this.coreParams = coreParams;
        this.scriptStepsStr = JSON.json(coreParams.script.steps);
        this.scriptStepsPrettyStr = JSON.pretty(coreParams.script.steps);
        this.authCtx = authCtx;
    }

    public Schema getSplitSchema() throws Exception {
        return this.analysisDataService.getInferredSchemaForML_NT(this.coreParams, this.authCtx);
    }

    public static Collection<String> getSplitsBeingComputed(MLTaskLoc taskLoc) {
        return splitsBeingComputed.get((Object)taskLoc);
    }

    private static void setSplitBeingComputed(MLTaskLoc taskLoc, String splitId) {
        assert (!splitsBeingComputed.get((Object)taskLoc).contains(splitId));
        splitsBeingComputed.put((Object)taskLoc, (Object)splitId);
    }

    private static void setSplitNotBeingComputed(MLTaskLoc taskLoc, String splitId) {
        assert (splitsBeingComputed.get((Object)taskLoc).contains(splitId));
        splitsBeingComputed.remove((Object)taskLoc, (Object)splitId);
    }

    public abstract String getPolicyId() throws IOException;

    public abstract String getExpectedInstanceId_NT() throws IOException;

    protected void expandFilterParams() {
    }

    public boolean splitsAreUpToDate_NT() throws IOException {
        String policyId = this.getPolicyId();
        String expectedInstanceId = this.getExpectedInstanceId_NT();
        logger.infoV("Checking if splits are up to date. Policy: %s, instance id: %s", new Object[]{policyId, expectedInstanceId});
        return this.findSplit(policyId, expectedInstanceId) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSplitIfNeeded_NT() throws Exception {
        this.expandFilterParams();
        String expectedPolicyId = this.getPolicyId();
        String expectedInstanceId = this.getExpectedInstanceId_NT();
        SplitDesc matchingSplit = this.findSplit(expectedPolicyId, expectedInstanceId);
        if (matchingSplit != null) {
            return;
        }
        SplitDesc newDesc = this.initSplitDesc(expectedPolicyId, expectedInstanceId, this.getSplitSchema());
        SplitGenerator.setSplitBeingComputed(this.taskLoc, expectedInstanceId);
        try {
            SplitDesc updatedSplitDesc = this.updateSplitAndSplitDesc(newDesc, expectedInstanceId);
            JSON.prettyToFile((Object)updatedSplitDesc, (File)this.getSplitDescFile(expectedInstanceId));
        }
        finally {
            SplitGenerator.setSplitNotBeingComputed(this.taskLoc, expectedInstanceId);
        }
    }

    public abstract SplitDesc initSplitDesc(String var1, String var2, Schema var3);

    public abstract SplitDesc updateSplitAndSplitDesc(SplitDesc var1, String var2) throws Exception;

    public File getSplitDescFile(String expectedInstanceId) {
        return new File(this.taskLoc.getSplitsFolder(), expectedInstanceId + ".json");
    }

    public SplitDesc getUpToDateSplitDesc() throws IOException {
        assert (this.splitsAreUpToDate_NT());
        return this.findSplit(this.getPolicyId(), this.getExpectedInstanceId_NT());
    }

    private SplitDesc findSplit(String expectedPolicyId, String expectedInstanceId) {
        File splitDescFile = this.getSplitDescFile(expectedInstanceId);
        if (!splitDescFile.isFile()) {
            return null;
        }
        try {
            return (SplitDesc)JSON.parseFile((File)splitDescFile, SplitDesc.class);
        }
        catch (IOException e) {
            logger.warn((Object)String.format("Failed to read split desc file (policyId=%s, instanceId=%s)", expectedPolicyId, expectedInstanceId), (Throwable)e);
            return null;
        }
    }
}

