/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.code;

import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.CodeEnvSelection;
import com.dataiku.dip.code.ProjectCodeEnvsSelection;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.plugins.IPluginsRegistryService;
import com.dataiku.dip.plugins.model.PluginSettings;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.ProjectsDAO;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.StringUtils;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;

public class CodeEnvSelector {
    @Autowired
    private ProjectsDAO projectsDAO;
    @Autowired
    private GeneralSettingsDAO gsDAO;
    @Autowired
    private IPluginsRegistryService pluginsRegistryService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.venv.selector");

    public CodeEnvSelector() {
        SpringUtils.getInstance().autowire((Object)this);
    }

    public String getProjectDefault(CodeEnvModel.EnvLang lang, ProjectCodeEnvsSelection projectSelections) throws IOException {
        CodeEnvSelection ces = new CodeEnvSelection();
        ces.envMode = CodeEnvSelection.EnvMode.INHERIT;
        return this.selectForLanguage(lang, projectSelections, ces, false);
    }

    public String selectForRecipe(String projectKey, CodeEnvModel.EnvLang envLang, CodeEnvSelection envSelection) throws IOException {
        return this.selectForLanguage(envLang, projectKey, envSelection, true);
    }

    public String selectForCustomRecipe(CodeEnvModel.EnvLang envLang, String pluginId) throws IOException {
        return this.selectForPluginLanguage(pluginId, envLang);
    }

    public String selectForPythonRecipe(String projectKey, CodeEnvSelection envSelection) throws IOException {
        return this.selectForLanguage(CodeEnvModel.EnvLang.PYTHON, projectKey, envSelection, true);
    }

    public String selectForDoctor(String projectKey, CodeEnvSelection envSelection) throws IOException {
        return this.selectForLanguage(CodeEnvModel.EnvLang.PYTHON, projectKey, envSelection, false);
    }

    public String selectForCustomPythonRecipe(String pluginId) throws IOException {
        return this.selectForPluginLanguage(pluginId, CodeEnvModel.EnvLang.PYTHON);
    }

    public String selectForJuliaRecipe(String projectKey, CodeEnvSelection envSelection) throws IOException {
        return this.selectForLanguage(CodeEnvModel.EnvLang.JULIA, projectKey, envSelection, true);
    }

    public String selectForCustomJuliaRecipe(String pluginId) throws IOException {
        return this.selectForPluginLanguage(pluginId, CodeEnvModel.EnvLang.JULIA);
    }

    public String selectForRRecipe(String projectKey, CodeEnvSelection envSelection) throws IOException {
        return this.selectForLanguage(CodeEnvModel.EnvLang.R, projectKey, envSelection, true);
    }

    public String selectForCustomRRecipe(String pluginId) throws IOException {
        return this.selectForPluginLanguage(pluginId, CodeEnvModel.EnvLang.R);
    }

    private ProjectCodeEnvsSelection getProjectCodeEnvSelection(String projectKey) throws IOException {
        if (TransactionContext.hasAttachedTransaction()) {
            return this.projectsDAO.getMandatory((String)projectKey).settings.codeEnvs;
        }
        TransactionService transactionService = (TransactionService)SpringUtils.getBean(TransactionService.class);
        try (Transaction t = transactionService.beginRead();){
            ProjectCodeEnvsSelection projectCodeEnvsSelection = this.projectsDAO.getMandatory((String)projectKey).settings.codeEnvs;
            return projectCodeEnvsSelection;
        }
    }

    private String selectForLanguage(CodeEnvModel.EnvLang lang, String projectKey, CodeEnvSelection envSelection, boolean canPreventOverride) throws IOException {
        return this.selectForLanguage(lang, this.getProjectCodeEnvSelection(projectKey), envSelection, canPreventOverride);
    }

    private String selectForLanguage(CodeEnvModel.EnvLang lang, ProjectCodeEnvsSelection projectSelections, CodeEnvSelection envSelection, boolean canPreventOverride) throws IOException {
        ProjectCodeEnvsSelection.ProjectCodeEnvSelection projectSelection = null;
        GeneralSettingsDAO.GlobalCodeEnvsExtraSettings gces = this.gsDAO.getUnsafeAutoTXN().codeEnvs;
        String instanceDefault = switch (lang) {
            case CodeEnvModel.EnvLang.JULIA -> {
                projectSelection = projectSelections.julia;
                yield StringUtils.nullIfBlank((String)gces.defaultJuliaEnv);
            }
            case CodeEnvModel.EnvLang.PYTHON -> {
                projectSelection = projectSelections.python;
                yield StringUtils.nullIfBlank((String)gces.defaultPythonEnv);
            }
            case CodeEnvModel.EnvLang.R -> {
                projectSelection = projectSelections.r;
                yield StringUtils.nullIfBlank((String)gces.defaultREnv);
            }
            default -> throw new IllegalStateException("Unhandled language: " + String.valueOf((Object)lang));
        };
        logger.infoV("Select code env lang=%s envSelection=%s projectSelection=%s globalDefault=%s", new Object[]{lang, JSON.json((Object)envSelection), JSON.json((Object)projectSelection), instanceDefault});
        switch (envSelection.envMode) {
            case EXPLICIT_ENV: {
                if (canPreventOverride && projectSelection.preventOverride) {
                    throw new IllegalArgumentException("Explicitly selecting a code env is forbidden by the project's settings");
                }
                return envSelection.envName;
            }
            case INHERIT: {
                switch (projectSelection.mode) {
                    case EXPLICIT_ENV: {
                        return projectSelection.envName;
                    }
                    case INHERIT: {
                        return instanceDefault;
                    }
                    case USE_BUILTIN_MODE: {
                        return null;
                    }
                }
            }
            case USE_BUILTIN_MODE: {
                return null;
            }
        }
        throw new Error("unreachable");
    }

    private String selectForPluginLanguage(String pluginId, CodeEnvModel.EnvLang lang) throws IOException {
        PluginSettings pluginSettings = this.pluginsRegistryService.getSettings(pluginId);
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)pluginSettings.codeEnvName)) {
            return pluginSettings.codeEnvName;
        }
        return null;
    }
}

