/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.ConnectionWithBasicCredential;
import com.dataiku.dip.connections.ConnectionWithEncryptedFields;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.connections.SimpleSQLDSSConnectionWithBasicCredential;
import com.dataiku.dip.connections.aws.S3ConnectionAWSSessionCredentialsProvider;
import com.dataiku.dip.connections.aws.S3ConnectionAWSSessionCredentialsProviderV2;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.datasets.sql.SQLCodes;
import com.dataiku.dip.exceptions.CodedSQLException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.model.ICredentialsService;
import com.dataiku.dip.server.services.ConnectionsTestService;
import com.dataiku.dip.sql.Athena3SQLDialect;
import com.dataiku.dip.sql.AthenaSQLDialect;
import com.dataiku.dip.utils.ErrorContext;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class AthenaConnection
extends SimpleSQLDSSConnectionWithBasicCredential
implements ConnectionWithEncryptedFields {
    private static final String VERSION_2X = "2.X";
    private static final String VERSION_3X = "3.X";
    public static final String connectionType = "Athena";
    public Params params = new Params();

    @Override
    public Params getParams() {
        return this.params;
    }

    @Override
    public String getType() {
        return connectionType;
    }

    @Override
    public AthenaSQLDialect getDialect() {
        return VERSION_3X.equals(this.params.version) ? new Athena3SQLDialect() : new AthenaSQLDialect();
    }

    @Override
    String getDriver() {
        if (VERSION_2X.equals(this.params.version)) {
            return "com.simba.athena.jdbc.Driver";
        }
        if (VERSION_3X.equals(this.params.version)) {
            return "com.amazon.athena.jdbc.AthenaDriver";
        }
        return "com.simba.athena.jdbc.Driver";
    }

    @Override
    String getJdbcUrl() {
        if (this.params.useURL) {
            if (StringUtils.isBlank((String)this.params.url)) {
                throw ErrorContext.iae((String)"Athena connection JDBC URL is not set");
            }
            return this.params.url;
        }
        return String.format("jdbc:awsathena://athena.%s.amazonaws.com:443", this.params.region);
    }

    @Override
    String getDisplayableJdbcUrl() {
        return this.params.useURL && StringUtils.isNotBlank((String)this.params.displayedUrl) ? this.params.displayedUrl : this.getJdbcUrl();
    }

    @Override
    public ICredentialsService.BasicCredential getGlobalCredential() {
        return new ICredentialsService.BasicCredential(this.params.user, this.params.password);
    }

    @Override
    public void encryptFields(PasswordEncryptionService cryptoService, GeneralSettingsDAO.SecuritySettings unused) {
        this.params.password = cryptoService.encryptIfNotEncryptedOrEmpty(this.params.password);
    }

    @Override
    public void decryptFields(PasswordEncryptionService cryptoService) {
        this.params.password = cryptoService.decryptIfEncrypted(this.params.password);
    }

    @Override
    protected <T> T getFullyResolvedCredentials_internal(ConnectionWithBasicCredential.CredentialResolutionContext ctx, Class<T> clazz) throws DKUSecurityException, IOException, SQLException {
        return super.getFullyResolvedCredentials_internal(ctx, clazz);
    }

    @Override
    public boolean actuallyHasBasicCredential() {
        return this.params.credentialsMode == AthenaConnectionCredentialsMode.USER_PASSWORD;
    }

    @Override
    public SQLConnectionProvider.SQLConnectionData getConnectionData_NT(AuthCtx authCtx, String projectKey) throws DKUSecurityException, SQLException {
        SQLConnectionProvider.SQLConnectionData cd = super.getConnectionData_NT(authCtx, projectKey);
        if (VERSION_3X.equals(this.params.version)) {
            fallThroughPackages = ApplicationConfigurator.getProperty((String)"dku.athena.fallThroughPackages", (String)"org.slf4j,software.amazon.awssdk");
            String nonFallThroughPackages = ApplicationConfigurator.getProperty((String)"dku.athena.nonFallThroughPackages", (String)"software.amazon.awssdk.utils.IoUtils");
            cd.setJarsFallThroughPackages(Arrays.stream(fallThroughPackages.split(",")).filter(StringUtils::isNotBlank).map(String::trim).collect(Collectors.toList()));
            cd.setJarsNonFallThroughPackages(Arrays.stream(nonFallThroughPackages.split(",")).filter(StringUtils::isNotBlank).map(String::trim).collect(Collectors.toList()));
        } else if (VERSION_2X.equals(this.params.version)) {
            fallThroughPackages = ApplicationConfigurator.getProperty((String)"dku.athena.fallThroughPackages", (String)"com.amazonaws.auth");
            cd.setJarsFallThroughPackages(Arrays.stream(fallThroughPackages.split(",")).filter(StringUtils::isNotBlank).map(String::trim).collect(Collectors.toList()));
        }
        if (StringUtils.isNotBlank((String)this.params.queryOutputLocation)) {
            cd.withProperty("S3OutputLocation", this.params.queryOutputLocation);
        }
        if (this.params.credentialsMode == AthenaConnectionCredentialsMode.FROM_AWS_CONNECTION) {
            if (StringUtils.isBlank((String)this.params.associatedAWSConnection)) {
                throw new CodedSQLException(SQLCodes.ERR_SQL_INVALID_CONF, "No associated S3 connection set on Athena connection");
            }
            try {
                DSSConnection s3Connection = ConnectionsDAO.get().getConnectionUnsafeUnexpanded(authCtx, this.params.associatedAWSConnection);
                if (s3Connection == null) {
                    throw new CodedSQLException(SQLCodes.ERR_SQL_INVALID_CONF, "S3 connection '" + this.params.associatedAWSConnection + "' associated to Athena connection doesn't exist");
                }
                if (!s3Connection.isFreelyUsableBy(authCtx)) {
                    throw new DKUSecurityException("Usage of S3 connection '" + this.params.associatedAWSConnection + "' not allowed for user");
                }
            }
            catch (CodedSQLException | DKUSecurityException | IOException e) {
                throw new CodedSQLException(SQLCodes.ERR_SQL_INVALID_CONF, "Unable to get S3 connection '" + this.params.associatedAWSConnection + "' associated to Athena connection", e);
            }
            if (VERSION_3X.equals(this.params.version)) {
                cd.withProperty(new AbstractSQLConnection.CustomDatabaseProperty("AwsCredentialsProviderClass", S3ConnectionAWSSessionCredentialsProviderV2.class.getCanonicalName(), false));
            } else {
                cd.withProperty(new AbstractSQLConnection.CustomDatabaseProperty("AwsCredentialsProviderClass", S3ConnectionAWSSessionCredentialsProvider.class.getCanonicalName(), false));
            }
            cd.withProperty(new AbstractSQLConnection.CustomDatabaseProperty("AwsCredentialsProviderArguments", String.format("%s,%s", authCtx.getIdentifier(), this.params.associatedAWSConnection), false));
        }
        return cd;
    }

    @Override
    public ConnectionsTestService.ConnectionTestResult testConnection(AuthCtx authCtx, ConnectionsTestService connectionsTestService) throws Exception {
        return connectionsTestService.testSQL_NOTRANSACTION(null, this, authCtx);
    }

    public static class Params
    extends AbstractSQLConnection.AbstractSQLParamsWithStdFields {
        public int port = 1521;
        public String version = "2.X";
        public String region;
        public String queryOutputLocation;
        public AthenaConnectionCredentialsMode credentialsMode = AthenaConnectionCredentialsMode.USER_PASSWORD;
        public String associatedAWSConnection;
    }

    public static enum AthenaConnectionCredentialsMode {
        USER_PASSWORD,
        FROM_AWS_CONNECTION;

    }
}

