/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.ConnectionWithAWSAuthCredentials;
import com.dataiku.dip.connections.ConnectionWithBasicCredential;
import com.dataiku.dip.connections.ConnectionWithEncryptedFields;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.StreamingConnection;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exceptions.CodedIOException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.aws.AWSClientBrokerService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.connections.ConnectionCodes;
import com.dataiku.dip.server.services.ConnectionsTestService;
import com.dataiku.dip.util.ProxyUtils;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.auth.credentials.AwsCredentials;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.core.client.builder.SdkSyncClientBuilder;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sqs.SqsClient;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sqs.SqsClientBuilder;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class SQSConnection
extends DSSConnection
implements ConnectionWithEncryptedFields,
StreamingConnection,
ConnectionWithAWSAuthCredentials {
    public Params params = new Params();
    public static final String connectionType = "SQS";

    @Override
    public void expandParametersInPlaceAtDAOLevelUsingGlobalContextOnly(VariablesContext vc) {
        if (this.params.credentialsMode == ConnectionWithAWSAuthCredentials.AWSCredentialMode.KEYPAIR) {
            this.params.accessKey = vc.expand(this.params.accessKey);
            this.params.secretKey = vc.expand(this.params.secretKey);
        }
        this.params.regionOrEndpoint = vc.expand(this.params.regionOrEndpoint);
    }

    @Override
    public String getType() {
        return connectionType;
    }

    @Override
    public ConnectionWithAWSAuthCredentials.IAWSAuthParams getIAWSAuthNonResolvedParams() {
        return this.params;
    }

    @Override
    public ProxySettings getProxySettingsFromConnection() {
        return this.getProxySettings();
    }

    @Override
    public DSSConnection.CredentialsMode getCredentialsMode() {
        return this.credentialsMode;
    }

    @Override
    public boolean mustResolveOnDSSHost() {
        return this.mustResolveAWSAuthOnDSSHost();
    }

    @Override
    protected <T> T getFullyResolvedCredentials_internal(ConnectionWithBasicCredential.CredentialResolutionContext ctx, Class<T> clazz) throws DKUSecurityException, IOException, SQLException {
        assert (clazz.isAssignableFrom(ConnectionWithAWSAuthCredentials.SerializableAWSCredential.class));
        ConnectionWithAWSAuthCredentials.SerializableAWSCredential creds = this.getResolvedCredential(ctx.authCtx);
        return clazz.cast(creds);
    }

    public SqsClient getSQSClient(AuthCtx authCtx) throws IOException, DKUSecurityException {
        AWSClientBrokerService awsClientBrokerService = (AWSClientBrokerService)SpringUtils.getBean(AWSClientBrokerService.class);
        SqsClientBuilder clientBuilder = awsClientBrokerService.createSqsClientBuilder();
        if (!ApplicationConfigurator.isInSparkDriver()) {
            ProxyUtils.addHttpClientBuilderAndApplyProxySettings((ProxySettings)this.getProxySettings(), (SdkSyncClientBuilder)clientBuilder);
        }
        String region = this.params.regionOrEndpoint;
        AWSClientBrokerService.setRegionOrEndpoint((String)region, (AwsClientBuilder)clientBuilder);
        if (!this.couldRunWithEnvironmentCredentials(this.params)) {
            ConnectionWithAWSAuthCredentials.SerializableAWSCredential cred = this.getFullyResolvedCredentials_fsLike(new ConnectionWithBasicCredential.CredentialResolutionContext(authCtx, null), ConnectionWithAWSAuthCredentials.SerializableAWSCredential.class);
            if (StringUtils.isBlank((String)cred.accessKey)) {
                throw new CodedIOException((InfoMessage.MessageCode)ConnectionCodes.ERR_CONNECTION_SQS_INVALID_CONFIG, "Invalid SQS account configuration: missing accessKey parameter");
            }
            if (StringUtils.isBlank((String)cred.secretKey)) {
                throw new CodedIOException((InfoMessage.MessageCode)ConnectionCodes.ERR_CONNECTION_SQS_INVALID_CONFIG, "Invalid SQS account configuration: missing secretKey parameter");
            }
            clientBuilder.credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)cred.toAWSCredentials()));
        }
        return (SqsClient)clientBuilder.build();
    }

    @Override
    public void encryptFields(PasswordEncryptionService cryptoService, GeneralSettingsDAO.SecuritySettings securitySettings) {
        if (securitySettings.secureSecretKeys) {
            this.params.secretKey = cryptoService.encryptIfNotEncryptedOrEmpty(this.params.secretKey);
        }
        AbstractSQLConnection.CustomDatabaseProperty.encryptList(this.params.customAWSCredentialsProviderParams, cryptoService);
    }

    @Override
    public void decryptFields(PasswordEncryptionService cryptoService) {
        this.params.secretKey = cryptoService.decryptIfEncrypted(this.params.secretKey);
        AbstractSQLConnection.CustomDatabaseProperty.decryptList(this.params.customAWSCredentialsProviderParams, cryptoService);
    }

    @Override
    public List<AbstractSQLConnection.CustomDatabaseProperty> getDkuProperties() {
        return this.params.dkuProperties;
    }

    @Override
    public ConnectionsTestService.ConnectionTestResult testConnection(AuthCtx authCtx, ConnectionsTestService connectionsTestService) throws Exception {
        return connectionsTestService.testSQS(authCtx, this);
    }

    public static class Params
    extends ConnectionWithAWSAuthCredentials.AWSAuthParams {
        public String regionOrEndpoint;
        public List<AbstractSQLConnection.CustomDatabaseProperty> dkuProperties = new ArrayList<AbstractSQLConnection.CustomDatabaseProperty>();
    }
}

