/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dao;

import com.codahale.metrics.Metric;
import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.DSSMetrics;
import com.dataiku.dip.dao.FileBasedSessionsDAO2;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dao.SessionsDAO;
import com.dataiku.dip.server.notifications.backend.SessionExpirationEvent;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.Params;
import java.io.IOException;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class SessionsDAOProvider {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.sessions.provider");

    @Bean
    public SessionsDAO sessionsDAO(final PubSubService pubSubService, final GeneralSettingsDAO generalSettingsDAO) throws IOException {
        Params p = ApplicationConfigurator.getParams();
        final String storageSettingValue = p.getParam("dku.sessions.storage", "auto");
        logger.info((Object)("Using session storage: " + storageSettingValue));
        FileBasedSessionsDAO2.SessionManagerConfig config = new FileBasedSessionsDAO2.SessionManagerConfig(){

            public void onSessionExpired(String user, FileBasedSessionsDAO2.ExpirationType expirationType) {
                pubSubService.publish(SessionExpirationEvent.withUsernameAndKind(user, user, expirationType));
            }

            public long getSessionsMaxIdleTimeMinutes() throws IOException {
                return generalSettingsDAO.getUnsafeAutoTXN().security.sessionsMaxIdleTimeMinutes;
            }

            public long getSessionsMaxTotalTimeMinutes() throws IOException {
                return generalSettingsDAO.getUnsafeAutoTXN().security.sessionsMaxTotalTimeMinutes;
            }

            public boolean getForceSingleSessionPerUser() throws IOException {
                return generalSettingsDAO.getUnsafeAutoTXN().security.forceSingleSessionPerUser;
            }

            public boolean getPersistOnDisk() throws IOException {
                return switch (storageSettingValue) {
                    case "memory" -> false;
                    case "disk" -> true;
                    default -> generalSettingsDAO.getUnsafeAutoTXN().security.persistSessionsOnDisk;
                };
            }

            public long getFlushPeriodSeconds() {
                return DKUApp.getParams().getLongParam("dku.sessions.flushPeriodSeconds", 60L);
            }
        };
        FileBasedSessionsDAO2 dao = new FileBasedSessionsDAO2(config);
        DSSMetrics.registry().register("dku.sessions", (Metric)dao.getMetrics());
        Runtime.getRuntime().addShutdownHook(new Thread(() -> ((SessionsDAO)dao).close()));
        return dao;
    }
}

