/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dashboards;

import com.dataiku.dip.dao.AbstractStandardDAO;
import com.dataiku.dip.dashboards.DashboardsDAO;
import com.dataiku.dip.dashboards.model.Dashboard;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.utils.FileFilter;
import com.dataiku.dip.transactions.fs.utils.RelFileFilter;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.utils.ExceptionUtils;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class FilesBasedDashboardsDAO
extends AbstractStandardDAO<Dashboard>
implements DashboardsDAO {
    @Override
    public String getHumanReadableType() {
        return ITaggingService.TaggableType.DASHBOARD.toHumanReadableString();
    }

    @Override
    protected Dashboard getOrNull_noTag(String projectKey, String id, boolean unsafe) throws IOException {
        TransactionRef t = TransactionContext.retrieveRead();
        RelFile dashboardFile = this.getDAOFile(projectKey, id);
        this.logger.trace((Object)("Reading dashboard file " + String.valueOf(dashboardFile)));
        if (!t.isFile(dashboardFile)) {
            return null;
        }
        Dashboard dashboard = unsafe ? (Dashboard)t.readObjectUnsafe(dashboardFile, Dashboard.class) : (Dashboard)t.readObject(dashboardFile, Dashboard.class);
        dashboard.id = id;
        dashboard.projectKey = projectKey;
        return dashboard;
    }

    @Override
    protected List<Dashboard> list_noTag(String projectKey, boolean unsafe) throws IOException {
        TransactionRef t = TransactionContext.retrieveRead();
        ArrayList<Dashboard> ret = new ArrayList<Dashboard>();
        RelFile dashboardsFolder = this.getDashboardsFolder(projectKey);
        if (!t.exists(dashboardsFolder)) {
            return ret;
        }
        for (RelFile file : t.listFiles(dashboardsFolder, (RelFileFilter)FileFilter.json())) {
            try {
                String dashboardId = StringUtils.removeEnd((String)file.getLeafName(), (String)".json");
                Dashboard dashboard = unsafe ? (Dashboard)t.readObjectUnsafe(file, Dashboard.class) : (Dashboard)t.readObject(file, Dashboard.class);
                dashboard.id = dashboardId;
                dashboard.projectKey = projectKey;
                ret.add(dashboard);
            }
            catch (Exception e) {
                this.logger.error((Object)("Failed to read dashboard file " + String.valueOf(file) + ": " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
            }
        }
        return ret;
    }

    @Override
    public int approximateCount(String projectKey) throws IOException {
        RelFile dashboardsFolder;
        TransactionRef t = TransactionContext.retrieveRead();
        if (!t.exists(dashboardsFolder = this.getDashboardsFolder(projectKey))) {
            return 0;
        }
        return t.listFiles(dashboardsFolder, (RelFileFilter)FileFilter.json()).size();
    }

    @Override
    public int countListed(String projectKey) throws IOException {
        int count = 0;
        for (Dashboard dashboard : this.listUnsafe(projectKey)) {
            if (!dashboard.listed) continue;
            ++count;
        }
        return count;
    }

    @Override
    public void delete(String projectKey, String id) throws IOException {
        RelFile dashboardFile;
        RWTransactionRef t = TransactionContext.retrieveWrite();
        if (!t.isFile(dashboardFile = this.getDAOFile(projectKey, id))) {
            throw new NotFoundException("Dashboard does not exist: " + projectKey + "." + id);
        }
        t.deleteFile(dashboardFile);
    }

    public RelFile getDashboardsFolder(String projectKey) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)projectKey), (Object)"Project key is not specifiedd");
        return new RelFile(new String[]{"projects", projectKey, "dashboards"});
    }

    @Override
    protected RelFile getDAOFile(String projectKey, String id) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)id), (Object)"Dashboard id is not specified");
        return new RelFile(this.getDashboardsFolder(projectKey), new String[]{id + ".json"});
    }
}

