/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow;

import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.ComputableFromRefService;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.RunnableSubgraph;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.dataflow.pdep.DimensionDependencySpec;
import com.dataiku.dip.recipes.FakeJobActivityFromRecipeBuilder;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.ErrorContext;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class RecipeRunnableSubgraph
extends RunnableSubgraph {
    @Autowired
    private ComputableFromRefService computableFromRefService;
    private FlowRecipe recipe;

    public RecipeRunnableSubgraph(FlowRecipe recipe) {
        this.recipe = recipe;
        SpringUtils.getInstance().autowire((Object)this);
    }

    public FlowRecipe getRecipe() {
        return this.recipe;
    }

    public List<FlowDataset> getTargetDatasetsForRole(String role) throws IOException {
        SerializedRecipe sr = this.recipe.getModel();
        ArrayList<FlowDataset> fdss = new ArrayList<FlowDataset>();
        for (SerializedRecipe.RecipeOutput recipeOutput : sr.getOutputsForRole(role)) {
            FlowComputable computable = this.computableFromRefService.get(sr.projectKey, recipeOutput.ref);
            if (computable.getType() != FlowComputable.FCType.DATASET) continue;
            fdss.add((FlowDataset)computable);
        }
        return fdss;
    }

    public FlowDataset getSingleTargetDatasetForRole(String role) throws IOException {
        List<FlowDataset> fdss = this.getTargetDatasetsForRole(role);
        if (fdss.size() != 1) {
            throw ErrorContext.iae((String)("Expected exactly one target dataset, got " + StringUtils.join(fdss, (String)",")));
        }
        return fdss.get(0);
    }

    public List<FlowDataset> getSourceDatasetsForRole(String[] roles) throws IOException {
        SerializedRecipe sr = this.recipe.getModel();
        ArrayList<FlowDataset> fdss = new ArrayList<FlowDataset>();
        for (String role : roles) {
            for (SerializedRecipe.RecipeInput recipeInput : sr.getInputsForRole(role)) {
                FlowComputable computable = this.computableFromRefService.get(sr.projectKey, recipeInput.ref);
                if (computable.getType() != FlowComputable.FCType.DATASET) continue;
                fdss.add((FlowDataset)computable);
            }
        }
        return fdss;
    }

    public List<FlowDataset> getSourceDatasetsForRole(String role) throws IOException {
        return this.getSourceDatasetsForRole(new String[]{role});
    }

    public FlowDataset getSingleSourceDatasetForRole(String role) throws IOException {
        List<FlowDataset> fdss = this.getSourceDatasetsForRole(role);
        if (fdss.size() != 1) {
            throw ErrorContext.iae((String)("Expected exactly one source dataset, got " + StringUtils.join(fdss, (String)",")));
        }
        return fdss.get(0);
    }

    @Override
    public Map<String, FlowComputable> getSourcesMap() {
        return this.recipe.getSourcesMap();
    }

    @Override
    public Map<String, FlowComputable> getTargetsMap() {
        return this.recipe.getTargetsMap();
    }

    @Override
    public List<? extends FlowComputable> getSources() {
        return this.recipe.getSources();
    }

    @Override
    public List<? extends FlowComputable> getTargets() {
        return this.recipe.getTargets();
    }

    @Override
    public List<FlowComputable.FlowComputableWithRole> getSourcesWithRoles() {
        return this.recipe.getSourcesWithRoles();
    }

    @Override
    public List<FlowComputable.FlowComputableWithRole> getTargetsWithRoles() {
        return this.recipe.getTargetsWithRoles();
    }

    public List<DimensionDependencySpec> getPartitionDeps() {
        return this.recipe.getPartitionDeps();
    }

    @Override
    public List<FlowRecipe> listRecipes() {
        return Collections.singletonList(this.recipe);
    }

    @Override
    public String getName() {
        return this.recipe.getName();
    }

    public boolean isNeverRecomputeExistingPartitions() {
        return this.recipe.isNeverRecomputeExistingPartitions();
    }

    @Override
    public void addSource_NoRole(FlowComputable source) {
        this.recipe.addPredecessor(source, null);
    }

    @Override
    public void addTarget_NoRole(FlowComputable target) {
        this.recipe.addSuccessor(target, null);
    }

    public void addSource(FlowComputable source, String role) {
        this.recipe.addPredecessor(source, role);
    }

    public void addTarget(FlowComputable target, String role) {
        this.recipe.addSuccessor(target, role);
    }

    @Override
    public boolean isAllTargetPartitions() {
        return this.recipe.getModel().redispatchPartitioning;
    }

    public static class JsonifiableRecipeRunnableSubgraph
    extends RunnableSubgraph.JsonifiableRunnableSubgraph {
        public SerializedRecipe recipe;
        public List<DimensionDependencySpec> partitionDeps = Lists.newArrayList();

        public void fromNative(RecipeRunnableSubgraph subgraph) {
            super.fromNative(subgraph);
            this.recipe = subgraph.recipe.getModel();
            this.partitionDeps = Lists.newArrayList(subgraph.getPartitionDeps());
        }

        public void toNative(RecipeRunnableSubgraph subgraph) throws IOException {
            super.toNative(subgraph);
            JobActivity fake = new FakeJobActivityFromRecipeBuilder().buildFakeJobActivity(this.recipe);
            subgraph.recipe = ((RecipeRunnableSubgraph)fake.getSubgraph()).getRecipe();
            this.partitionDeps.stream().forEach(d -> subgraph.recipe.addPartitionDeps((DimensionDependencySpec)d));
        }
    }
}

