/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.autofeaturegeneration;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.dataflow.exec.autofeaturegeneration.AutoFeatureGenerationRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.autofeaturegeneration.FeatureContainer;
import com.dataiku.dip.dataflow.exec.autofeaturegeneration.RelationshipGraph;
import com.dataiku.dip.dataflow.exec.autofeaturegeneration.TimeWindow;
import com.dataiku.dip.dataflow.exec.join.JoinQueryGenerator;
import com.dataiku.dip.dataflow.exec.join.JoinRecipeHelper;
import com.dataiku.dip.dataflow.exec.join.JoinRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.joinlike.ColumnDesc;
import com.dataiku.dip.dataflow.exec.joinlike.JoinOutputRole;
import com.dataiku.dip.dataflow.exec.joinlike.JoinType;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.queries.SelectQueryBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class AutoFeatureJoinQueryGenerator {
    private final Map<String, Dataset> datasetsMap;
    private final Map<String, SQLUtils.SQLTable> sqlTablesMap;
    private final Map<Integer, String> viewNameByDataset;
    private final SQLDialect dialect;

    public AutoFeatureJoinQueryGenerator(Map<String, Dataset> datasetsMap, Map<String, SQLUtils.SQLTable> sqlTablesMap, SQLDialect dialect, Map<Integer, String> viewNameByDataset) {
        this.datasetsMap = datasetsMap;
        this.sqlTablesMap = sqlTablesMap;
        this.viewNameByDataset = viewNameByDataset;
        this.dialect = dialect;
    }

    public String generateQuery(RelationshipGraph.ForwardEdge edge, List<FeatureContainer> forwardFeatures) {
        JoinRecipePayloadParams joinParams = this.generateParams(edge, forwardFeatures);
        return this.generateSqlQuery(joinParams, false);
    }

    public String generateQuery(RelationshipGraph.BackwardEdge edge, String groupByViewName, List<FeatureContainer> backwardFeatures) {
        JoinRecipePayloadParams joinParams = this.generateParams(edge, groupByViewName, backwardFeatures);
        return this.generateSqlQuery(joinParams, false);
    }

    public String generateQuery(RelationshipGraph.Edge edge, String cutoffTimeColumnName, boolean withDistinct) {
        JoinRecipePayloadParams joinParams = this.generateParams(edge, cutoffTimeColumnName);
        return this.generateSqlQuery(joinParams, withDistinct);
    }

    private String generateSqlQuery(JoinRecipePayloadParams joinParams, boolean withDistinct) {
        Schema schema = new Schema();
        JoinQueryGenerator joinQueryGenerator = new JoinQueryGenerator(joinParams, this.datasetsMap, this.sqlTablesMap, new Dataset().withSchema(schema), JoinOutputRole.MAIN);
        JoinRecipeHelper.unicizeTableAliases(joinParams);
        SelectQueryBuilder joinQuery = joinQueryGenerator.generateQuery(this.dialect);
        if (withDistinct) {
            SelectQueryBuilder joinWithDistinctQuery = new SelectQueryBuilder();
            joinWithDistinctQuery.selectDistinct();
            joinWithDistinctQuery.from(joinQuery, "__dku_afg_join_query");
            return joinWithDistinctQuery.toSQL(this.dialect);
        }
        return joinQuery.toSQL(this.dialect);
    }

    private JoinRecipePayloadParams generateParams(RelationshipGraph.ForwardEdge edge, List<FeatureContainer> features) {
        JoinRecipePayloadParams joinParams = AutoFeatureJoinQueryGenerator.initializeJoinParamsForFeatureComputation(edge, features);
        JoinRecipePayloadParams.InputDesc joinInput1 = AutoFeatureJoinQueryGenerator.generateJoinInput(edge.getCurrentNode(), 0, this.viewNameByDataset);
        joinParams.addVirtualInput(joinInput1);
        JoinRecipePayloadParams.InputDesc joinInput2 = AutoFeatureJoinQueryGenerator.generateJoinInput(edge.getRelatedNode(), 1, this.viewNameByDataset);
        joinParams.addVirtualInput(joinInput2);
        joinParams.resolveSelectedColumns(this.datasetsMap, false);
        return joinParams;
    }

    private JoinRecipePayloadParams generateParams(RelationshipGraph.BackwardEdge edge, String groupByViewName, List<FeatureContainer> features) {
        JoinRecipePayloadParams joinParams = AutoFeatureJoinQueryGenerator.initializeJoinParamsForFeatureComputation(edge, features);
        JoinRecipePayloadParams.InputDesc joinInput1 = AutoFeatureJoinQueryGenerator.generateJoinInput(edge.getCurrentNode(), 0, this.viewNameByDataset);
        joinParams.addVirtualInput(joinInput1);
        JoinRecipePayloadParams.InputDesc joinInput2 = new JoinRecipePayloadParams.InputDesc();
        joinInput2.index = 1;
        joinInput2.name = groupByViewName;
        joinInput2.originLabel = groupByViewName;
        joinInput2.alias = groupByViewName;
        joinParams.addVirtualInput(joinInput2);
        joinParams.resolveSelectedColumns(this.datasetsMap, false);
        return joinParams;
    }

    private static JoinRecipePayloadParams initializeJoinParamsForFeatureComputation(RelationshipGraph.Edge edge, List<FeatureContainer> features) {
        JoinRecipePayloadParams joinParams = new JoinRecipePayloadParams();
        JoinRecipePayloadParams.JoinDesc joinDesc = AutoFeatureJoinQueryGenerator.generateJoinDesc(edge);
        joinParams.joins.add(joinDesc);
        List<ColumnDesc> selectedColumns = AutoFeatureJoinQueryGenerator.getAllSelectedColumnsForJoin(edge.getCurrentNode().getSchemaColumnNames(), features);
        joinParams.setSelectedColumns(selectedColumns);
        return joinParams;
    }

    private JoinRecipePayloadParams generateParams(RelationshipGraph.Edge edge, String cutoffTimeColumnName) {
        JoinRecipePayloadParams joinParams = new JoinRecipePayloadParams();
        RelationshipGraph.Node currentNode = edge.getCurrentNode();
        RelationshipGraph.Node relatedNode = edge.getRelatedNode();
        joinParams.addVirtualInput(AutoFeatureJoinQueryGenerator.generateJoinInput(edge.getCurrentNode(), 0, this.viewNameByDataset));
        joinParams.addVirtualInput(AutoFeatureJoinQueryGenerator.generateJoinInput(edge.getRelatedNode(), 1, this.viewNameByDataset));
        ArrayList<ColumnDesc> selectedColumns = new ArrayList<ColumnDesc>();
        for (String relatedNodeColumName : relatedNode.getSchemaColumnNames()) {
            ColumnDesc column = new ColumnDesc(1, relatedNodeColumName, relatedNodeColumName);
            selectedColumns.add(column);
        }
        selectedColumns.add(new ColumnDesc(0, currentNode.getCutoffTimeColumn(), cutoffTimeColumnName));
        joinParams.setSelectedColumns(selectedColumns);
        joinParams.resolveSelectedColumns(this.datasetsMap, false);
        ArrayList<JoinRecipePayloadParams.MatchingCondition> matchingConditions = new ArrayList<JoinRecipePayloadParams.MatchingCondition>(edge.matchingConditions);
        if (relatedNode.hasTimeIndexColumn()) {
            matchingConditions.add(AutoFeatureJoinQueryGenerator.getTimeCondition(currentNode, relatedNode));
        }
        JoinRecipePayloadParams.JoinDesc joinDesc = AutoFeatureJoinQueryGenerator.generateJoinDesc(JoinType.INNER, matchingConditions);
        joinParams.joins.add(joinDesc);
        return joinParams;
    }

    private static JoinRecipePayloadParams.MatchingCondition getTimeCondition(RelationshipGraph.Node currentNode, RelationshipGraph.Node relatedNode) {
        JoinRecipePayloadParams.MatchingCondition timeCondition = new JoinRecipePayloadParams.MatchingCondition();
        timeCondition.column1 = new ColumnDesc(0, currentNode.getCutoffTimeColumn());
        timeCondition.column2 = new ColumnDesc(1, relatedNode.getTimeIndexColumn());
        if (!relatedNode.getTimeWindows().isEmpty()) {
            TimeWindow timeWindow = relatedNode.getTimeWindows().get(0);
            timeCondition.type = JoinRecipePayloadParams.MatchingType.WITHIN_WINDOW_OF;
            timeCondition.windowFrom = timeWindow.from;
            timeCondition.windowTo = timeWindow.to;
            timeCondition.dateDiffUnit = timeWindow.windowUnit.name().toUpperCase();
        } else {
            timeCondition.type = JoinRecipePayloadParams.MatchingType.GT;
        }
        return timeCondition;
    }

    private static JoinRecipePayloadParams.JoinDesc generateJoinDesc(RelationshipGraph.Edge edge) {
        ArrayList<JoinRecipePayloadParams.MatchingCondition> matchingConditions = new ArrayList<JoinRecipePayloadParams.MatchingCondition>(edge.matchingConditions);
        RelationshipGraph.Node currentNode = edge.getCurrentNode();
        RelationshipGraph.Node relatedNode = edge.getRelatedNode();
        if (StringUtils.isNotBlank((String)currentNode.getCutoffTimeColumn()) && StringUtils.isNotBlank((String)relatedNode.getCutoffTimeColumn())) {
            JoinRecipePayloadParams.MatchingCondition cutoffCondition = new JoinRecipePayloadParams.MatchingCondition();
            cutoffCondition.column1 = new ColumnDesc(0, currentNode.getCutoffTimeColumn());
            cutoffCondition.column2 = new ColumnDesc(1, relatedNode.getCutoffTimeColumn());
            cutoffCondition.type = JoinRecipePayloadParams.MatchingType.EQ;
            matchingConditions.add(cutoffCondition);
        }
        return AutoFeatureJoinQueryGenerator.generateJoinDesc(JoinType.LEFT, matchingConditions);
    }

    private static JoinRecipePayloadParams.JoinDesc generateJoinDesc(JoinType joinType, List<JoinRecipePayloadParams.MatchingCondition> matchingConditions) {
        JoinRecipePayloadParams.JoinDesc joinDesc = new JoinRecipePayloadParams.JoinDesc();
        joinDesc.table1 = 0;
        joinDesc.table2 = 1;
        joinDesc.type = joinType;
        for (JoinRecipePayloadParams.MatchingCondition relationshipCondition : matchingConditions) {
            JoinRecipePayloadParams.MatchingCondition joinCondition = new JoinRecipePayloadParams.MatchingCondition();
            joinCondition.column1 = new ColumnDesc(0, relationshipCondition.column1.name);
            joinCondition.column2 = new ColumnDesc(1, relationshipCondition.column2.name);
            joinCondition.type = relationshipCondition.type;
            joinCondition.windowTo = relationshipCondition.windowTo;
            joinCondition.windowFrom = relationshipCondition.windowFrom;
            joinCondition.dateDiffUnit = relationshipCondition.dateDiffUnit;
            joinDesc.on.add(joinCondition);
        }
        return joinDesc;
    }

    private static JoinRecipePayloadParams.InputDesc generateJoinInput(RelationshipGraph.Node node, int index, Map<Integer, String> viewNameByDataset) {
        JoinRecipePayloadParams.InputDesc joinInput = new JoinRecipePayloadParams.InputDesc();
        AutoFeatureGenerationRecipePayloadParams.InputDesc initialInput = node.getDataset();
        joinInput.index = index;
        joinInput.name = viewNameByDataset.getOrDefault(node.getId(), initialInput.name);
        joinInput.originLabel = viewNameByDataset.getOrDefault(node.getId(), initialInput.originLabel);
        joinInput.alias = initialInput.alias;
        return joinInput;
    }

    public static List<ColumnDesc> getAllSelectedColumnsForJoin(List<String> currentNodeColumnNames, List<FeatureContainer> relatedNodesColumns) {
        ArrayList<ColumnDesc> selectedColumns = new ArrayList<ColumnDesc>();
        for (String currentNodeColumName : currentNodeColumnNames) {
            ColumnDesc column = new ColumnDesc(0, currentNodeColumName, currentNodeColumName);
            selectedColumns.add(column);
        }
        for (FeatureContainer feature : relatedNodesColumns) {
            String inputColumnName = feature.groupByColumnName != null ? feature.groupByColumnName : feature.inputColumn;
            ColumnDesc column = new ColumnDesc(1, inputColumnName, feature.alias);
            selectedColumns.add(column);
        }
        return selectedColumns;
    }
}

