/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.fuzzyjoin.builtinengine.verifier;

import com.dataiku.dip.dataflow.exec.fuzzyjoin.FuzzyJoinRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.fuzzyjoin.builtinengine.verifier.Matcher;

public class HammingMatcher
extends Matcher {
    public HammingMatcher(double threshold, Integer relativeTo, boolean debugMode) {
        super(threshold, relativeTo, debugMode);
    }

    @Override
    protected boolean isValidInputs(String query, String candidate) {
        return query != null && candidate != null;
    }

    @Override
    public double computeDistance(String query, String candidate) {
        int lenQuery = query.length();
        int lenCandidate = candidate.length();
        int distance = Math.abs(lenQuery - lenCandidate);
        for (int idx = 0; idx < Math.min(lenQuery, lenCandidate); ++idx) {
            distance += query.charAt(idx) == candidate.charAt(idx) ? 0 : 1;
        }
        return distance;
    }

    @Override
    protected double computeNormalisationFactor(String query, String candidate) {
        if (this.relativeTo == null) {
            return 1.0;
        }
        return this.relativeTo == 0 ? (double)query.length() : (double)candidate.length();
    }

    @Override
    protected FuzzyJoinRecipePayloadParams.DistanceType getDistanceType() {
        return FuzzyJoinRecipePayloadParams.DistanceType.HAMMING;
    }
}

