/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.fuzzyjoin.builtinengine.verifier;

import com.dataiku.dip.dataflow.exec.fuzzyjoin.FuzzyJoinRecipePayloadParams;

public abstract class Matcher
implements Comparable<Matcher> {
    public static final double NO_MATCH = -1.0;
    protected final double threshold;
    protected final Integer relativeTo;
    protected final boolean debugMode;

    public Matcher(double threshold) {
        this(threshold, null, false);
    }

    public Matcher(double threshold, Integer relativeTo, boolean debugMode) {
        this.threshold = threshold;
        this.relativeTo = relativeTo;
        this.debugMode = debugMode;
    }

    @Override
    public int compareTo(Matcher otherMatcher) {
        return this.getDistanceType().compareTo(otherMatcher.getDistanceType());
    }

    public MatchResult computeMatch(String reference, String candidate) {
        MatchResult matchResult = new MatchResult();
        if (!this.isValidInputs(reference, candidate)) {
            return matchResult;
        }
        matchResult.distance = this.computeDistance(reference, candidate);
        if (Double.compare(matchResult.distance, -1.0) == 0) {
            return matchResult;
        }
        if (this.isRelative()) {
            matchResult.distance /= this.computeNormalisationFactor(reference, candidate);
        }
        matchResult.isMatch = matchResult.distance <= this.threshold;
        return matchResult;
    }

    public boolean isRelative() {
        return this.relativeTo != null;
    }

    protected abstract boolean isValidInputs(String var1, String var2);

    protected abstract double computeDistance(String var1, String var2);

    protected double computeNormalisationFactor(String query, String candidate) {
        return 1.0;
    }

    protected abstract FuzzyJoinRecipePayloadParams.DistanceType getDistanceType();

    public static class MatchResult {
        public double distance = -1.0;
        public boolean isMatch = false;
    }
}

