/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.graph;

import com.dataiku.dip.coremodel.Partitionable;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.graph.FlowPartitionable;
import com.dataiku.dip.managedfolder.ManagedFolder;
import java.io.IOException;

public class FlowManagedFolder
extends FlowComputable
implements FlowPartitionable {
    private ManagedFolder odb;

    public FlowManagedFolder(ManagedFolder odb) {
        super(FlowComputable.FCType.MANAGED_FOLDER);
        this.odb = odb;
    }

    public ManagedFolder getManagedFolder() {
        return this.odb;
    }

    @Override
    public String getFullId() {
        return this.odb.projectKey + "." + this.odb.id;
    }

    @Override
    public SerializedDataset.RebuildBehavior getRebuildBehavior() throws IOException {
        return this.odb.flowOptions.rebuildBehavior;
    }

    @Override
    public SerializedDataset.CrossProjectBuildBehaviour getCrossProjectBehavior() throws IOException {
        return this.odb.flowOptions.crossProjectBuildBehavior;
    }

    @Override
    public Partitionable getPartitioned(DatasetsDAO datasetsDAO) throws IOException {
        return this.odb;
    }

    @Override
    public String getFullName() {
        return this.odb.getFullName();
    }

    @Override
    public boolean isPartitionable() {
        return true;
    }
}

