/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.pipeline;

import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.JobAuthCtxService;
import com.dataiku.dip.dataflow.pipeline.RecipePipelineHelper;
import com.dataiku.dip.dataflow.pipeline.RecipePipelineHelperFactory;
import com.dataiku.dip.dataflow.pipeline.SparkPipelineDef;
import com.dataiku.dip.recipes.AbstractSparkRecipeParams;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.shaker.resources.ResourcesGatherer;
import com.dataiku.dip.spark.SparkOverrideConfig;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;

class SparkPipelineEltBuilder {
    private final ResourcesGatherer gatherer = new ResourcesGatherer();
    @Autowired
    private JobAuthCtxService authCtxService;
    private RecipePipelineHelperFactory recipePipelineHelperFactory;
    AuthCtx authCtx;

    SparkPipelineEltBuilder() {
        SpringUtils.getInstance().autowire((Object)this);
        SpringUtils.getInstance().autowire((Object)this.gatherer);
        this.recipePipelineHelperFactory = new RecipePipelineHelperFactory(RecipePipelineHelper.PipelineType.SPARK);
        this.authCtx = this.authCtxService.getAuthCtx();
    }

    public ResourcesGatherer getGatherer() {
        return this.gatherer;
    }

    void finalizePipeline(SparkPipelineDef def) throws IOException {
        this.gatherer.computeMapping();
        for (SparkPipelineDef.SparkPipelineElt elt : def.orderedElts) {
            if (elt.shaker != null) {
                elt.shaker.resourceMapping = this.gatherer.getResourceMapping();
            }
            if (elt.scoring == null) continue;
            elt.scoring.resourceMapping = this.gatherer.getResourceMapping();
        }
    }

    SparkPipelineDef.SparkPipelineElt buildPipelineElt(JobActivity activity) throws Exception {
        return this.recipePipelineHelperFactory.build(activity, this.authCtx).buildPipelineElt(activity, this.getGatherer());
    }

    boolean getGlobalMetastoreFromRecipeActivity(JobActivity activity) throws Exception {
        return this.recipePipelineHelperFactory.build(activity, this.authCtx).getGlobalMetastoreFromRecipeActivity();
    }

    SparkOverrideConfig getSparkConfFromRecipeActivity(JobActivity activity) throws Exception {
        return this.recipePipelineHelperFactory.build(activity, this.authCtx).getSparkConfFromRecipeActivity();
    }

    AbstractSparkRecipeParams.SparkExecutionEngine getSparkExecutionEngineFromRecipeActivity(JobActivity activity) throws Exception {
        return this.recipePipelineHelperFactory.build(activity, this.authCtx).getSparkExecutionEngineFromRecipeActivity();
    }
}

