/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datalayer.utils;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datalayer.sort.RowAndSortMark;
import com.dataiku.dip.datalayer.sort.SortedRowsIterator;
import com.dataiku.dip.datalayer.sort.Sorter;
import com.dataiku.dip.datalayer.sort.SpilledRowsStorage;
import com.dataiku.dip.datasets.StreamableDatasetSelection;
import com.dataiku.dip.datasets.Type;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class ColumnOrderedProcessorOutput
implements ProcessorOutput {
    private final ProcessorOutput finalOutput;
    private final Dataset dataset;
    private final ColumnFactory cf;
    private final RowFactory rf;
    private final StreamableDatasetSelection originalSelection;
    private SpilledRowsStorage storage = null;
    private Sorter sorter = null;
    private boolean isOrderColumnNumeric;
    private long rowCount = 0L;
    private static Logger logger = Logger.getLogger((String)"dip.ordered.sample");

    public ColumnOrderedProcessorOutput(ProcessorOutput finalOutput, Dataset dataset, ColumnFactory cf, RowFactory rf, StreamableDatasetSelection originalSelection) {
        this.finalOutput = finalOutput;
        this.dataset = dataset;
        this.cf = cf;
        this.rf = rf;
        this.originalSelection = originalSelection;
    }

    private void lazyInit() throws IOException {
        if (this.storage != null) {
            return;
        }
        Sorter.MergeSortParams mergeSortParams = new Sorter.MergeSortParams();
        Schema inputSchema = this.dataset.getSchema();
        File folder = Files.createTempDir();
        this.storage = new SpilledRowsStorage(folder, SpilledRowsStorage.factoryColumnsOfSchema(this.cf, inputSchema), mergeSortParams);
        ArrayList<Sorter.SortSpec> specs = new ArrayList<Sorter.SortSpec>();
        Sorter.SortSpec spec = new Sorter.SortSpec(this.originalSelection.column, this.originalSelection.ascending);
        specs.add(spec);
        this.sorter = new Sorter(specs, inputSchema, this.cf, this.storage, this.rf, this.cf, mergeSortParams);
        Type orderColumnType = inputSchema.getColumn(this.originalSelection.column).getType();
        this.isOrderColumnNumeric = orderColumnType.isNumeric();
        if (!this.isOrderColumnNumeric || !orderColumnType.isTemporal()) {
            logger.warn((Object)("Ordering column \"" + this.originalSelection.column + "\" is neither numeric or temporal but " + String.valueOf(orderColumnType)));
        }
    }

    public void emitRow(Row row) throws Exception {
        this.lazyInit();
        if (this.sorter.emitOnlyValidRowForColumn(row, this.originalSelection.column, this.isOrderColumnNumeric)) {
            ++this.rowCount;
        }
    }

    public void flush() throws Exception {
        long index;
        this.lazyInit();
        this.sorter.lastRowEmitted();
        this.storage.doneWriting();
        long maxRecords = this.originalSelection.maxRecords;
        logger.info((Object)("Sorter received " + this.rowCount + " rows, needs to produce " + maxRecords));
        SortedRowsIterator iterator = this.sorter.read();
        RowAndSortMark row = null;
        for (index = 0L; index < maxRecords && iterator.hasNext(); ++index) {
            row = iterator.next();
            this.finalOutput.emitRow(row.row.row);
        }
        this.storage.close();
        logger.info((Object)("Final output got " + index + " rows"));
    }

    public void lastRowEmitted() throws Exception {
        this.flush();
        this.finalOutput.lastRowEmitted();
    }

    public void cancel() throws Exception {
        if (this.storage != null) {
            this.storage.close();
        }
        this.finalOutput.cancel();
    }

    public void setMaxMemoryUsed(long size) {
        this.finalOutput.setMaxMemoryUsed(size);
    }
}

