/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataquality;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.dataquality.FailedRowsExtractRuleVisitor;
import com.dataiku.dip.dataquality.RuleValidationError;
import com.dataiku.dip.dataquality.rules.AbstractNewDataQualityRule;
import com.dataiku.dip.metrics.MetricsComputationService;
import com.dataiku.dip.metrics.checks.AbstractCheckContext;
import com.dataiku.dip.metrics.checks.Check;
import com.dataiku.dip.metrics.probes.Probe;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.polyjson.PolyClassMetadata;
import com.dataiku.j2ts.annotations.UIModel;
import com.google.common.annotations.VisibleForTesting;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;

@UIModel
public abstract class DataQualityRule {
    private String id;
    public String type;
    public String displayName = "";
    public Probe.ComputeMode computeOnBuildMode = Probe.ComputeMode.PARTITION;
    public boolean autoRun = true;
    public boolean enabled = true;

    public void ensureId() {
        if (StringUtils.isBlank((CharSequence)this.id)) {
            this.initializeId();
        }
    }

    public String ensureIdUsingCheckLegacyId(Set<String> alreadyUsedIds) {
        String computedId = this.getId();
        if (StringUtils.isBlank((CharSequence)computedId)) {
            this.initializeId();
        } else if (alreadyUsedIds.contains(computedId)) {
            int i = alreadyUsedIds.size();
            do {
                this.id = DigestUtils.md5Hex((String)(computedId + i++)).substring(0, 8);
            } while (alreadyUsedIds.contains(this.id));
        } else {
            this.id = computedId;
        }
        return this.id;
    }

    public Probe.ComputeMode getComputeMode() {
        return this.computeOnBuildMode;
    }

    public abstract void updateDisplayName();

    public void initializeId() {
        this.id = SecretKeyGenerator.generate((int)8);
    }

    public DataQualityRule withId(String id) {
        this.id = id;
        return this;
    }

    @VisibleForTesting
    public DataQualityRule withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public static void registerJsonAdapters() {
        JSON.registerAdapter(DataQualityRule.class, DataQualityRule.getRuleAdapter());
    }

    public static JSON.Adapter<DataQualityRule> getRuleAdapter() {
        final JSON.Adapter<Check> checkAdapter = Check.getAdapter();
        final PolyClassMetadata newRulesPolyMeta = JSON.getPolyJsonMeta(AbstractNewDataQualityRule.class);
        return new JSON.Adapter<DataQualityRule>(){

            public DataQualityRule deserialize(JsonElement json, Type type, JsonDeserializationContext ctx) throws JsonParseException {
                JsonObject jsonObj = json.getAsJsonObject();
                String ruleType = jsonObj.get("type").getAsString();
                Class clazz = newRulesPolyMeta.getClassFromType(ruleType);
                if (clazz == null) {
                    return (DataQualityRule)checkAdapter.deserialize(json, type, ctx);
                }
                return (DataQualityRule)ctx.deserialize(json, AbstractNewDataQualityRule.class);
            }

            public JsonElement serialize(DataQualityRule rule, Type type, JsonSerializationContext ctx) {
                if (rule instanceof Check) {
                    return checkAdapter.serialize((Object)((Check)rule), type, ctx);
                }
                if (rule instanceof AbstractNewDataQualityRule) {
                    return ctx.serialize((Object)rule, AbstractNewDataQualityRule.class);
                }
                throw new IllegalStateException("Unknown rule type: " + rule.getClass().getCanonicalName());
            }
        };
    }

    public abstract AbstractCheckContext.CheckResult run(AuthCtx var1, AbstractCheckContext var2, MetricsComputationService.MetricsCheckRunReport var3) throws Exception;

    @Nullable
    public abstract RuleValidationError verifyConfig(Dataset var1);

    @Nullable
    public abstract RuleValidationError verifyPreConditions(Dataset var1, List<MetricsComputationService.ValuedMetric> var2);

    public void accept(FailedRowsExtractRuleVisitor visitor) {
        throw new UnsupportedOperationException("Not implemented yet for rule " + String.valueOf(this.getClass()));
    }
}

