/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataquality.rules;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.dataquality.FailedRowsExtractRuleVisitor;
import com.dataiku.dip.dataquality.ReadMetricValueHelper;
import com.dataiku.dip.dataquality.RuleValidationError;
import com.dataiku.dip.dataquality.rules.AbstractMultiColumnRule;
import com.dataiku.dip.dataquality.rules.MetricsBasedDataQualityRule;
import com.dataiku.dip.meanings.AbstractBasicMeaningsService;
import com.dataiku.dip.metrics.Metric;
import com.dataiku.dip.metrics.MetricsComputationService;
import com.dataiku.dip.metrics.checks.AbstractCheckContext;
import com.dataiku.dip.metrics.checks.MetricInNumericRangeCheck;
import com.dataiku.dip.metrics.probes.VerifyDatasetColumnProbeType;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class ColumnMeaningValidityRule
extends AbstractMultiColumnRule
implements MetricsBasedDataQualityRule {
    public static final String TYPE = "ColumnMeaningValidityRule";
    List<ValidityRuleColumnSpec> columnSpecs;
    @Nullable
    public ThresholdType thresholdType;
    public boolean considerEmptyAsValid = false;
    public double minimum;
    public boolean minimumEnabled;
    public double softMinimum;
    public boolean softMinimumEnabled;
    private transient List<String> columns;
    private transient Map<String, String> meaningsMap;
    private static final VerifyDatasetColumnProbeType.VerifyDatasetColumnMetrics[] metricsToCompute = new VerifyDatasetColumnProbeType.VerifyDatasetColumnMetrics[]{VerifyDatasetColumnProbeType.VerifyDatasetColumnMetrics.FORCED_MEANING_VALID_COUNT, VerifyDatasetColumnProbeType.VerifyDatasetColumnMetrics.FORCED_MEANING_INVALID_COUNT, VerifyDatasetColumnProbeType.VerifyDatasetColumnMetrics.FORCED_MEANING_EMPTY_COUNT};

    @Override
    public List<String> getColumns() {
        if (this.columns == null) {
            this.columns = this.columnSpecs.stream().map(s -> s.column).collect(Collectors.toList());
        }
        return this.columns;
    }

    @Nullable
    public String getMeaningFor(String column) {
        if (this.meaningsMap == null) {
            this.meaningsMap = new HashMap<String, String>();
            for (ValidityRuleColumnSpec s : this.columnSpecs) {
                this.meaningsMap.put(s.column, s.meaning);
            }
        }
        return this.meaningsMap.get(column);
    }

    @Override
    public List<Metric> getMetricsForOneColumn(String column) {
        return Arrays.stream(metricsToCompute).map(m -> new VerifyDatasetColumnProbeType.VerifyDatasetColumnMetric((VerifyDatasetColumnProbeType.VerifyDatasetColumnMetrics)((Object)m), column, this.getMeaningFor(column))).collect(Collectors.toList());
    }

    private double readMetricsValue(AbstractCheckContext context, VerifyDatasetColumnProbeType.VerifyDatasetColumnMetrics metric, String column) throws Exception {
        return ReadMetricValueHelper.readDoubleMetricsValue(context, Metric.serializeMetric(new VerifyDatasetColumnProbeType.VerifyDatasetColumnMetric(metric, column, this.getMeaningFor(column))));
    }

    @Override
    public AbstractCheckContext.CheckResult runForOneColumn(String column, AuthCtx authCtx, AbstractCheckContext context, MetricsComputationService.MetricsCheckRunReport runReport) throws Exception {
        assert (this.thresholdType != null);
        MetricInNumericRangeCheck check = new MetricInNumericRangeCheck();
        double rawValidCount = this.readMetricsValue(context, VerifyDatasetColumnProbeType.VerifyDatasetColumnMetrics.FORCED_MEANING_VALID_COUNT, column);
        double rawInvalidCount = this.readMetricsValue(context, VerifyDatasetColumnProbeType.VerifyDatasetColumnMetrics.FORCED_MEANING_INVALID_COUNT, column);
        double emptyCount = this.readMetricsValue(context, VerifyDatasetColumnProbeType.VerifyDatasetColumnMetrics.FORCED_MEANING_EMPTY_COUNT, column);
        double validCount = rawValidCount + (this.considerEmptyAsValid ? emptyCount : 0.0);
        double invalidCount = rawInvalidCount + (this.considerEmptyAsValid ? 0.0 : emptyCount);
        double totalCount = rawValidCount + rawInvalidCount + emptyCount;
        switch (this.thresholdType) {
            case ENTIRE_COLUMN: {
                if (invalidCount > 0.0) {
                    Object message = String.format("%d invalid", (long)rawInvalidCount);
                    if (!this.considerEmptyAsValid && emptyCount > 0.0) {
                        message = (String)message + String.format(" and %d empty", (long)emptyCount);
                    }
                    message = (String)message + (invalidCount == 1.0 ? " value" : " values");
                    return new AbstractCheckContext.CheckResult(AbstractCheckContext.CheckOutcome.ERROR, (String)message);
                }
                Object message = String.format("%d valid", (long)rawValidCount);
                if (this.considerEmptyAsValid && emptyCount > 0.0) {
                    message = (String)message + String.format(" and %d empty", (long)emptyCount);
                }
                message = (String)message + (validCount == 1.0 ? " value" : " values");
                return new AbstractCheckContext.CheckResult(AbstractCheckContext.CheckOutcome.OK, (String)message);
            }
            case MIN_NUMBER_VALID: {
                return check.withMinimum(this.minimumEnabled, this.minimum).withSoftMinimum(this.softMinimumEnabled, this.softMinimum).runForResolvedValue(validCount);
            }
            case MIN_PERCENTAGE_VALID: {
                if (totalCount == 0.0) {
                    throw new AbstractMultiColumnRule.MultiRunStopException(new AbstractCheckContext.CheckResult(AbstractCheckContext.CheckOutcome.EMPTY, "Cannot compute percentage-based rule: dataset is empty"));
                }
                return check.withMinimum(this.minimumEnabled, this.minimum).withSoftMinimum(this.softMinimumEnabled, this.softMinimum).runForResolvedValue(100.0 * validCount / totalCount);
            }
        }
        throw new IllegalStateException("Unknown threshold type");
    }

    @Override
    @Nullable
    public RuleValidationError verifyConfigOtherThanColumnsExistence(Dataset dataset) {
        HashMap<String, Integer> frequencies = new HashMap<String, Integer>();
        for (String col : this.getColumns()) {
            int cnt = frequencies.getOrDefault(col, 0);
            frequencies.put(col, cnt + 1);
        }
        List duplicates = frequencies.entrySet().stream().filter(e -> (Integer)e.getValue() > 1).map(Map.Entry::getKey).collect(Collectors.toList());
        if (!duplicates.isEmpty()) {
            return new RuleValidationError("Columns cannot have multiple verifications: " + String.join((CharSequence)", ", duplicates));
        }
        if (this.thresholdType == null) {
            return new RuleValidationError("Threshold type cannot be null");
        }
        if (this.minimumEnabled && this.thresholdType == ThresholdType.MIN_PERCENTAGE_VALID && (this.minimum < 0.0 || this.minimum > 100.0)) {
            return new RuleValidationError("Minimum percentage must be between 0 and 100");
        }
        if (this.softMinimumEnabled && this.thresholdType == ThresholdType.MIN_PERCENTAGE_VALID && (this.softMinimum < 0.0 || this.softMinimum > 100.0)) {
            return new RuleValidationError("Soft minimum percentage must be between 0 and 100");
        }
        String invalidColumns = this.columnSpecs.stream().filter(s -> s.meaning == null && dataset.getSchema().getColumn(s.column).getMeaning() == null).map(s -> s.column).collect(Collectors.joining(", "));
        if (StringUtils.isNotBlank((CharSequence)invalidColumns)) {
            return new RuleValidationError("Columns with setting 'Use meaning from schema' option are invalid when their meaning is auto-detect: " + invalidColumns);
        }
        AbstractBasicMeaningsService ps2 = (AbstractBasicMeaningsService)SpringUtils.getBean(AbstractBasicMeaningsService.class);
        List invalidMeanings = this.columnSpecs.stream().map(s -> s.meaning).filter(meaning -> meaning != null && !ps2.hasDetector((String)meaning)).collect(Collectors.toList());
        if (!invalidMeanings.isEmpty()) {
            return new RuleValidationError(invalidMeanings.size() > 1 ? String.format("Selected meanings %s are invalid", invalidMeanings.stream().map(m -> "'" + m + "'").collect(Collectors.joining(", "))) : String.format("Selected meaning '%s' is invalid", invalidMeanings.get(0)));
        }
        return null;
    }

    @Override
    @Nullable
    public RuleValidationError verifyPreConditions(Dataset dataset, List<MetricsComputationService.ValuedMetric> computedMetrics) {
        return this.checkComputedMetricsPresent(computedMetrics);
    }

    @Override
    public void accept(FailedRowsExtractRuleVisitor visitor) {
        visitor.visit(this);
    }

    public class ValidityRuleColumnSpec {
        @Nullable
        public String column;
        @Nullable
        public String meaning;
    }

    public static enum ThresholdType {
        ENTIRE_COLUMN,
        MIN_PERCENTAGE_VALID,
        MIN_NUMBER_VALID;

    }
}

