/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.fs;

import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.SSHConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.fs.AbstractFSDatasetHandler;
import com.dataiku.dip.datasets.fs.BuiltinFSDatasets;
import com.dataiku.dip.datasets.fs.DirectoryAwareFSDatasetHandler;
import com.dataiku.dip.datasets.fs.FSProviderFactory;
import com.dataiku.dip.datasets.fs.SFTPDatasetTestHandler;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.fs.FSProvider;
import com.dataiku.dip.input.DatasetTestHandler;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.datasets.FSDatasetBrowseService;
import java.io.IOException;

public class SFTPDatasetHandler
extends DirectoryAwareFSDatasetHandler<BuiltinFSDatasets.SFTPDatasetConfig>
implements FSDatasetBrowseService.BrowsableHandler {
    public SFTPDatasetHandler(AuthCtx authCtx, Dataset dataset) {
        super(authCtx, dataset);
    }

    @Override
    public AbstractFSDatasetHandler.FSProviderAndPath getProviderInternal(String path) throws IOException, CodedException, DKUSecurityException {
        String providerPath = path == null ? ((BuiltinFSDatasets.SFTPDatasetConfig)this.resolvedConfig).path : path;
        FSProvider provider = FSProviderFactory.getProvider("SFTP", this.authCtx, this.dataset.getProjectKey(), this.resolvedConfig, providerPath, this.getConnection());
        return new AbstractFSDatasetHandler.FSProviderAndPath(provider, providerPath);
    }

    @Override
    protected DSSConnection getConnection() throws IOException, DKUSecurityException {
        return ConnectionsDAO.get().getMandatoryConnectionAs(this.authCtx, ((BuiltinFSDatasets.SFTPDatasetConfig)this.resolvedConfig).connection, SSHConnection.class);
    }

    @Override
    public DatasetHandler.DatasetMeta<?, ?> getMeta() {
        return BuiltinFSDatasets.SFTP_META;
    }

    @Override
    public DatasetTestHandler buildTestHandler() throws IOException {
        return new SFTPDatasetTestHandler(this.authCtx, this, (DatasetHandler)this, this.dataset);
    }
}

