/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.sql.treasuredata;

import com.dataiku.dip.datasets.Type;
import com.google.gson.JsonArray;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class RowData {
    public static final String TIME_COLUMN_NAME = "time";
    public final List<Cell> cells = new ArrayList<Cell>();
    public boolean allTypesOk = true;
    public boolean timeColumnAdded;

    public void add(Cell cell) {
        this.cells.add(cell);
        if (TIME_COLUMN_NAME.equalsIgnoreCase(cell.name)) {
            this.timeColumnAdded = true;
        }
    }

    public void addAll(List<Cell> cells) {
        cells.forEach(this::add);
    }

    public static class Cell {
        public final String name;
        public final String value;
        public final Type type;
        public final JsonArray array;
        public final Type arrayItemType;

        public static Cell primitive(String name, String value, Type type) {
            return new Cell(name, value, type, null, null);
        }

        public static Cell array(String name, JsonArray array, Type arrayItemType) {
            return new Cell(name, null, Type.ARRAY, array, arrayItemType);
        }

        private Cell(String name, String value, Type type, JsonArray array, Type arrayItemType) {
            this.name = name.toLowerCase(Locale.ROOT);
            this.value = value;
            this.type = type;
            this.array = array;
            this.arrayItemType = arrayItemType;
        }
    }
}

