/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.docgen.flow.placeholders.folder;

import com.dataiku.dip.docgen.flow.FlowDocumentContext;
import com.dataiku.dip.docgen.flow.FlowPlaceholder;
import com.dataiku.dip.docgen.helpers.PlaceholderOutputFactory;
import com.dataiku.dip.docgen.resolver.PlaceholderExpectedException;
import com.dataiku.dip.docgen.resolver.PlaceholderOutput;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.ReadOnlyJobsInternalDB;
import com.dataiku.dip.server.services.ReadWriteJobsInternalDB;
import com.dataiku.dip.server.services.TaggableObjectsService;
import java.sql.SQLException;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;

public class FolderLastBuildDatePlaceholder
implements FlowPlaceholder.TextPlaceholder<ManagedFolder> {
    @Autowired
    private ReadWriteJobsInternalDB jobsDBService;

    public FolderLastBuildDatePlaceholder() {
        SpringUtils.getInstance().autowire((Object)this);
    }

    @Override
    public Class<ManagedFolder> getInputType() {
        return ManagedFolder.class;
    }

    @Override
    public PlaceholderOutput.Text resolve(FlowDocumentContext flowDocumentContext, ManagedFolder folder) throws PlaceholderExpectedException {
        try {
            ReadOnlyJobsInternalDB.ObjectBuild lastBuild = this.jobsDBService.getLatestBuildForObject(new TaggableObjectsService.TaggableObjectRef(folder));
            if (lastBuild == null) {
                return new PlaceholderOutput.Text("No build recorded");
            }
            return PlaceholderOutputFactory.makeDate(new Date(lastBuild.buildEndTime));
        }
        catch (SQLException e) {
            throw PlaceholderExpectedException.createWithLog("Error while trying to read last build time for managed folder " + folder.getDisplayName(), e);
        }
    }
}

