/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.docgen.helpers;

import com.dataiku.dip.docgen.resolver.PlaceholderExpectedException;
import com.dataiku.dip.docgen.resolver.PlaceholderOutput;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.UsersService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.jgit.util.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class PlaceholderOutputFactory {
    private static InstantiatedHelper INSTANCE = new InstantiatedHelper();

    public static PlaceholderOutput.Text makeEmptyTextOutput() throws PlaceholderExpectedException {
        return new PlaceholderOutput.Text("");
    }

    public static PlaceholderOutput.Text makeTextOutputMaybeNull(String value) throws PlaceholderExpectedException {
        return new PlaceholderOutput.Text(value == null ? "" : value);
    }

    public static PlaceholderOutput.Text makeBoolean(boolean value) throws PlaceholderExpectedException {
        return new PlaceholderOutput.Text(value ? "Yes" : "No");
    }

    public static PlaceholderOutput.Text textFromEnum(Enum<?> e) throws PlaceholderExpectedException {
        return new PlaceholderOutput.Text(StringUtils.capitalize((String)e.name().toLowerCase().replace('_', ' ')));
    }

    public static PlaceholderOutput.Text makeDate(Date date) throws PlaceholderExpectedException {
        return PlaceholderOutputFactory.makeDate(date, new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
    }

    public static PlaceholderOutput.Text makeDate(Date date, SimpleDateFormat format) throws PlaceholderExpectedException {
        if (date == null) {
            return new PlaceholderOutput.Text("Unknown");
        }
        return new PlaceholderOutput.Text(format.format(date));
    }

    public static PlaceholderOutput.Text makeUserDisplayName(String user) throws PlaceholderExpectedException {
        return INSTANCE.resolveUser(user);
    }

    public static class InstantiatedHelper {
        @Autowired
        private TransactionService transactionService;
        @Autowired
        private UsersService usersService;

        public InstantiatedHelper() {
            SpringUtils.getInstance().autowire((Object)this);
        }

        PlaceholderOutput.Text resolveUser(String user) throws PlaceholderExpectedException {
            PlaceholderOutput.Text text;
            block9: {
                if (user == null) {
                    return new PlaceholderOutput.Text("Unknown user");
                }
                Transaction ignored = this.transactionService.beginRead();
                try {
                    String displayName = this.usersService.getPublicUser((String)user).displayName;
                    text = new PlaceholderOutput.Text(displayName);
                    if (ignored == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignored != null) {
                            try {
                                ignored.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw PlaceholderExpectedException.createWithLog("Cannot retrieve user " + user, e);
                    }
                }
                ignored.close();
            }
            return text;
        }
    }
}

