/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.compute.computations.transformers;

import com.dataiku.dip.eda.compute.computations.Computation;
import com.dataiku.dip.eda.compute.computations.ComputationResult;
import com.dataiku.dip.eda.compute.computations.UnavailableResult;
import com.dataiku.dip.eda.compute.computations.common.GroupedComputation;
import com.dataiku.dip.eda.compute.computations.common.MultiComputation;
import com.dataiku.dip.eda.compute.computations.common.ResampledComputation;
import com.dataiku.dip.eda.compute.computations.transformers.TransformedComputation;
import com.dataiku.dip.eda.compute.computations.univariate.Quantiles;
import com.dataiku.dip.eda.compute.filtering.AllFilter;
import com.dataiku.dip.eda.compute.grouping.CrossGrouping;
import com.dataiku.dip.eda.compute.grouping.Grouping;
import com.dataiku.dip.eda.compute.grouping.GroupingResult;
import com.dataiku.dip.eda.compute.grouping.SubsetGrouping;
import com.dataiku.dip.eda.compute.grouping.UnionGrouping;
import com.dataiku.dip.eda.compute.resampling.ResamplerSpec;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.Pair;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public abstract class Transformer {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.eda.compute.transformers");

    public TransformedComputation transform(Computation computation) {
        final String transformerName = this.getClass().getSimpleName();
        Stopwatch stopwatch = Stopwatch.createStarted();
        final TransformedComputation transformed = this.transform(TransformedComputation.identity(computation));
        TransformedComputation profiledTransformed = new TransformedComputation(transformed.computation){

            @Override
            public ComputationResult reconstruct(ComputationResult result) {
                Stopwatch reconstructionStopwatch = Stopwatch.createStarted();
                ComputationResult reconstructed = transformed.reconstruct(result);
                logger.info((Object)("Computation results reconstructed in " + reconstructionStopwatch.elapsed(TimeUnit.MILLISECONDS) + " ms (" + transformerName + ")"));
                return reconstructed;
            }
        };
        logger.info((Object)("Computation tree transformed in " + stopwatch.elapsed(TimeUnit.MILLISECONDS) + " ms (" + transformerName + ")"));
        return profiledTransformed;
    }

    protected abstract TransformedComputation transform(TransformedComputation var1);

    protected TransformedComputation transformWithinGroupedComputation(TransformedComputation input) {
        Computation original = input.computation;
        if (!original.isGrouped()) {
            return input;
        }
        Computation subComputation = original.asGrouped().computation;
        TransformedComputation identity = TransformedComputation.identity(subComputation);
        final TransformedComputation flattened = this.transform(identity);
        if (flattened == identity) {
            return input;
        }
        GroupedComputation newComputation = new GroupedComputation(flattened.computation, original.asGrouped().grouping);
        return new TransformedComputation(newComputation){

            @Override
            public ComputationResult reconstruct(ComputationResult result) {
                if (!result.isAvailable()) {
                    return result;
                }
                ArrayList<ComputationResult> resultsPerGroup = new ArrayList<ComputationResult>();
                for (ComputationResult resultInGroup : result.asGrouped().results) {
                    resultsPerGroup.add(flattened.reconstruct(resultInGroup));
                }
                return new GroupedComputation.GroupedComputationResult(result.asGrouped().groups, resultsPerGroup);
            }
        }.compose(input);
    }

    protected TransformedComputation transformWithinResampledComputation(TransformedComputation input) {
        if (!input.computation.isResampled()) {
            return input;
        }
        ResampledComputation resampled = input.computation.asResampled();
        TransformedComputation identity = TransformedComputation.identity(resampled.computation);
        final TransformedComputation flattened = this.transform(identity);
        if (flattened == identity) {
            return input;
        }
        ResampledComputation newComputation = new ResampledComputation(flattened.computation, resampled.spec);
        return new TransformedComputation(newComputation){

            @Override
            public ComputationResult reconstruct(ComputationResult result) {
                if (!result.isAvailable()) {
                    return result;
                }
                ResampledComputation.ResampledComputationResult resampledResult = result.asResampled();
                return new ResampledComputation.ResampledComputationResult(flattened.reconstruct(resampledResult.result));
            }
        }.compose(input);
    }

    protected TransformedComputation pruneCrossGroupingWithOneElement(TransformedComputation input) {
        Computation original = input.computation;
        if (!original.isGrouped()) {
            return input;
        }
        GroupedComputation grouped = original.asGrouped();
        if (!(grouped.grouping instanceof CrossGrouping)) {
            return input;
        }
        CrossGrouping initialCrossGrouping = (CrossGrouping)grouped.grouping;
        if (initialCrossGrouping.groupings.size() != 1) {
            return input;
        }
        return new TransformedComputation(new GroupedComputation(grouped.computation, initialCrossGrouping.groupings.get(0))){

            @Override
            public ComputationResult reconstruct(ComputationResult result) {
                if (!result.isAvailable()) {
                    return result;
                }
                GroupedComputation.GroupedComputationResult groupedResults = result.asGrouped();
                return new GroupedComputation.GroupedComputationResult((GroupingResult)new CrossGrouping.CrossGroupingResult(groupedResults.groups), groupedResults.results);
            }
        }.compose(input);
    }

    protected TransformedComputation pruneSubsetAllWithinCrossGrouping(TransformedComputation input) {
        Computation original = input.computation;
        if (!original.isGrouped()) {
            return input;
        }
        GroupedComputation grouped = original.asGrouped();
        if (!(grouped.grouping instanceof CrossGrouping)) {
            return input;
        }
        final CrossGrouping initialCrossGrouping = (CrossGrouping)grouped.grouping;
        final ArrayList<Grouping> newCrossedGroupings = new ArrayList<Grouping>();
        boolean foundAll = false;
        for (Grouping grouping : initialCrossGrouping.groupings) {
            if (grouping instanceof SubsetGrouping && ((SubsetGrouping)grouping).filter instanceof AllFilter) {
                foundAll = true;
                continue;
            }
            newCrossedGroupings.add(grouping);
        }
        if (!foundAll) {
            return input;
        }
        Computation newComputation = newCrossedGroupings.isEmpty() ? grouped.computation : new GroupedComputation(grouped.computation, new CrossGrouping(newCrossedGroupings));
        return new TransformedComputation(newComputation){

            @Override
            public ComputationResult reconstruct(ComputationResult result) {
                if (!result.isAvailable()) {
                    return result;
                }
                ArrayList<GroupingResult> reconstructedCrossGroups = new ArrayList<GroupingResult>();
                int groupingIndex = 0;
                for (Grouping grouping : initialCrossGrouping.groupings) {
                    if (grouping instanceof SubsetGrouping && ((SubsetGrouping)grouping).filter instanceof AllFilter) {
                        reconstructedCrossGroups.add(new SubsetGrouping.SubsetGroupingResult(((SubsetGrouping)grouping).filter));
                        continue;
                    }
                    reconstructedCrossGroups.add(result.asGrouped().asGrouped().groups.asCross().groups.get(groupingIndex));
                    ++groupingIndex;
                }
                ArrayList results = newCrossedGroupings.isEmpty() ? Lists.newArrayList((Object[])new ComputationResult[]{result}) : result.asGrouped().results;
                return new GroupedComputation.GroupedComputationResult((GroupingResult)new CrossGrouping.CrossGroupingResult(reconstructedCrossGroups), results);
            }
        }.compose(input);
    }

    protected TransformedComputation distributeUnionGroupingWithinCrossGrouping(TransformedComputation input) {
        Computation original = input.computation;
        if (!original.isGrouped()) {
            return input;
        }
        GroupedComputation grouped = original.asGrouped();
        if (!(grouped.grouping instanceof CrossGrouping)) {
            return input;
        }
        final CrossGrouping initialCrossGrouping = (CrossGrouping)grouped.grouping;
        UnionGrouping initialUnionGrouping = null;
        int initialUnionGroupingIndex = -1;
        for (int idxInInitialCross = 0; idxInInitialCross < initialCrossGrouping.groupings.size(); ++idxInInitialCross) {
            Grouping childGrouping = initialCrossGrouping.groupings.get(idxInInitialCross);
            if (!(childGrouping instanceof UnionGrouping)) continue;
            UnionGrouping currentUnion = (UnionGrouping)childGrouping;
            if (currentUnion.groupings.size() > 2) continue;
            initialUnionGroupingIndex = idxInInitialCross;
            initialUnionGrouping = currentUnion;
            break;
        }
        final UnionGrouping finalInitialUnionGrouping = initialUnionGrouping;
        final int finalInitialUnionGroupingIndex = initialUnionGroupingIndex;
        if (initialUnionGrouping == null) {
            return input;
        }
        ArrayList<Grouping> newCrossGroupings = new ArrayList<Grouping>();
        for (int i = 0; i < initialUnionGrouping.groupings.size(); ++i) {
            ArrayList newCrossGroupingElements = Lists.newArrayList(initialCrossGrouping.groupings);
            newCrossGroupingElements.set(initialUnionGroupingIndex, initialUnionGrouping.groupings.get(i));
            newCrossGroupings.add(new CrossGrouping(newCrossGroupingElements));
        }
        UnionGrouping newUnionGrouping = new UnionGrouping(newCrossGroupings);
        return new TransformedComputation(new GroupedComputation(grouped.computation, newUnionGrouping)){

            @Override
            public ComputationResult reconstruct(ComputationResult result) {
                if (!result.isAvailable()) {
                    return result;
                }
                GroupedComputation.GroupedComputationResult groupedResults = result.asGrouped();
                UnionGrouping.UnionGroupingResult unionGroupingResult = groupedResults.groups.asUnion();
                ArrayList<GroupingResult> reconstructedUnionGroups = new ArrayList<GroupingResult>();
                for (int idxInInitialUnion = 0; idxInInitialUnion < finalInitialUnionGrouping.groupings.size(); ++idxInInitialUnion) {
                    GroupingResult union = unionGroupingResult.groupings.get((int)idxInInitialUnion).asCross().groups.get(finalInitialUnionGroupingIndex);
                    reconstructedUnionGroups.add(union);
                }
                ArrayList<GroupingResult> reconstructedCrossGroups = new ArrayList<GroupingResult>();
                for (int idxInInitialCross = 0; idxInInitialCross < initialCrossGrouping.groupings.size(); ++idxInInitialCross) {
                    if (idxInInitialCross == finalInitialUnionGroupingIndex) {
                        reconstructedCrossGroups.add(new UnionGrouping.UnionGroupingResult(reconstructedUnionGroups));
                        continue;
                    }
                    reconstructedCrossGroups.add(unionGroupingResult.groupings.get((int)0).asCross().groups.get(idxInInitialCross));
                }
                CrossGrouping.CrossGroupingResult reconstructedGroupingResult = new CrossGrouping.CrossGroupingResult(reconstructedCrossGroups);
                ComputationResult[] reorderedResults = new ComputationResult[groupedResults.results.size()];
                for (int resultIdx = 0; resultIdx < groupedResults.results.size(); ++resultIdx) {
                    int[] unflat = unionGroupingResult.unflattenIndex(resultIdx);
                    CrossGrouping.CrossGroupingResult cross = unionGroupingResult.groupings.get(unflat[0]).asCross();
                    int[] unflattenedIndex = cross.unflattenIndex(unflat[1]);
                    for (int i = 0; i < unflat[0]; ++i) {
                        int n = finalInitialUnionGroupingIndex;
                        unflattenedIndex[n] = unflattenedIndex[n] + unionGroupingResult.groupings.get((int)i).asCross().groups.get(finalInitialUnionGroupingIndex).size();
                    }
                    int flatIdx = reconstructedGroupingResult.flattenIndex(unflattenedIndex);
                    reorderedResults[flatIdx] = groupedResults.results.get(resultIdx);
                }
                return new GroupedComputation.GroupedComputationResult((GroupingResult)reconstructedGroupingResult, reorderedResults);
            }
        }.compose(input);
    }

    protected TransformedComputation flattenUnionGrouping(TransformedComputation input) {
        Computation original = input.computation;
        if (!original.isGrouped()) {
            return input;
        }
        GroupedComputation grouped = original.asGrouped();
        if (!(grouped.grouping instanceof UnionGrouping)) {
            return input;
        }
        UnionGrouping union = (UnionGrouping)grouped.grouping;
        ArrayList<Computation> newComputations = new ArrayList<Computation>();
        for (Grouping innerGrouping : union.groupings) {
            newComputations.add(new GroupedComputation(grouped.computation, innerGrouping));
        }
        return new TransformedComputation(new MultiComputation(newComputations)){

            @Override
            public ComputationResult reconstruct(ComputationResult result) {
                if (!result.isAvailable()) {
                    return result;
                }
                MultiComputation.MultiComputationResult multiResult = result.asMulti();
                ArrayList<GroupingResult> innerGroupingResult = new ArrayList<GroupingResult>();
                ArrayList<ComputationResult> concatenatedComputationResult = new ArrayList<ComputationResult>();
                for (ComputationResult innerResult : multiResult) {
                    if (!innerResult.isFailed()) continue;
                    return innerResult;
                }
                for (ComputationResult innerResult : multiResult) {
                    if (!innerResult.isAvailable()) {
                        return innerResult;
                    }
                    concatenatedComputationResult.addAll(innerResult.asGrouped().results);
                    innerGroupingResult.add(innerResult.asGrouped().groups);
                }
                return new GroupedComputation.GroupedComputationResult((GroupingResult)new UnionGrouping.UnionGroupingResult(innerGroupingResult), concatenatedComputationResult);
            }
        }.compose(input);
    }

    protected TransformedComputation eliminateGroupingOnSubsetAll(TransformedComputation input) {
        Computation original = input.computation;
        if (!original.isGrouped()) {
            return input;
        }
        GroupedComputation grouped = original.asGrouped();
        if (!(grouped.grouping instanceof SubsetGrouping)) {
            return input;
        }
        final SubsetGrouping subset = (SubsetGrouping)grouped.grouping;
        if (!(subset.filter instanceof AllFilter)) {
            return input;
        }
        return new TransformedComputation(grouped.computation){

            @Override
            public ComputationResult reconstruct(ComputationResult result) {
                return new GroupedComputation.GroupedComputationResult((GroupingResult)new SubsetGrouping.SubsetGroupingResult(subset.filter), (List<ComputationResult>)ImmutableList.of((Object)((Object)result)));
            }
        }.compose(input);
    }

    protected TransformedComputation transformWithinMultiComputation(TransformedComputation input) {
        Computation original = input.computation;
        if (!original.isMulti()) {
            return input;
        }
        List<Computation> originalComputations = original.asMulti().computations;
        final ArrayList<TransformedComputation> deflatteners = new ArrayList<TransformedComputation>();
        MultiComputation flattenedComputations = new MultiComputation(new Computation[0]);
        boolean changed = false;
        for (Computation computation : originalComputations) {
            TransformedComputation identity = TransformedComputation.identity(computation);
            TransformedComputation flattened = this.transform(identity);
            if (flattened != identity) {
                changed = true;
            }
            flattenedComputations.computations.add(flattened.computation);
            deflatteners.add(flattened);
        }
        if (!changed) {
            return input;
        }
        return new TransformedComputation(flattenedComputations){

            @Override
            public ComputationResult reconstruct(ComputationResult result) {
                if (!result.isAvailable()) {
                    return result;
                }
                MultiComputation.MultiComputationResult castedResult = result.asMulti();
                ArrayList<ComputationResult> newResults = new ArrayList<ComputationResult>();
                for (int i = 0; i < deflatteners.size(); ++i) {
                    newResults.add(((TransformedComputation)deflatteners.get(i)).reconstruct(castedResult.get(i)));
                }
                return new MultiComputation.MultiComputationResult(newResults);
            }
        }.compose(input);
    }

    protected TransformedComputation tryDedupeMultiComputation(TransformedComputation input) {
        Computation computation = input.computation;
        if (!computation.isMulti()) {
            return input;
        }
        MultiComputation dedupedMC = new MultiComputation(new Computation[0]);
        final List<Computation> toCompute = computation.asMulti().computations;
        int newIndex = 0;
        final HashMap<Computation, Integer> computationIndexes = new HashMap<Computation, Integer>(toCompute.size());
        for (Computation current : toCompute) {
            if (computationIndexes.containsKey((Object)current)) continue;
            computationIndexes.put(current, newIndex++);
            dedupedMC.computations.add(current);
        }
        if (computationIndexes.size() == toCompute.size()) {
            return input;
        }
        logger.debugV("Computation to perform list deduplicated from %d to %d unique computations", new Object[]{toCompute.size(), dedupedMC.computations.size()});
        return new TransformedComputation(dedupedMC){

            @Override
            public ComputationResult reconstruct(ComputationResult result) {
                if (!result.isAvailable()) {
                    return result;
                }
                MultiComputation.MultiComputationResult mcr = result.asMulti();
                ArrayList<ComputationResult> results = new ArrayList<ComputationResult>(mcr.size());
                for (Computation c2 : toCompute) {
                    results.add(mcr.get((Integer)computationIndexes.get((Object)c2)));
                }
                return new MultiComputation.MultiComputationResult(results);
            }
        }.compose(input);
    }

    protected TransformedComputation flattenMultiComputation(TransformedComputation input) {
        Computation original = input.computation;
        if (!original.isMulti()) {
            return input;
        }
        final List<Computation> originalComputations = original.asMulti().computations;
        ArrayList<Computation> flattenedComputations = new ArrayList<Computation>();
        boolean hasFlattened = false;
        for (Computation computation : originalComputations) {
            if (computation.isMulti()) {
                flattenedComputations.addAll(computation.asMulti().computations);
                hasFlattened = true;
                continue;
            }
            flattenedComputations.add(computation);
        }
        if (!hasFlattened) {
            return input;
        }
        return new TransformedComputation(new MultiComputation(flattenedComputations)){

            @Override
            public ComputationResult reconstruct(ComputationResult result) {
                if (!result.isAvailable()) {
                    return result;
                }
                MultiComputation.MultiComputationResult castedResult = result.asMulti();
                ArrayList<ComputationResult> outputResults = new ArrayList<ComputationResult>();
                int i = 0;
                for (Computation computation : originalComputations) {
                    if (computation.isMulti()) {
                        int count = computation.asMulti().computations.size();
                        outputResults.add(castedResult.subList(i, i + count));
                        i += count;
                        continue;
                    }
                    outputResults.add(castedResult.get(i));
                    ++i;
                }
                return new MultiComputation.MultiComputationResult(outputResults);
            }
        }.compose(input);
    }

    protected TransformedComputation expandQuantileComputation(TransformedComputation input) {
        Computation original = input.computation;
        if (!(original instanceof Quantiles)) {
            return input;
        }
        Quantiles quantiles = original.as(Quantiles.class);
        if (quantiles.freqs.size() == 1) {
            return input;
        }
        ArrayList<Computation> newComputations = new ArrayList<Computation>();
        for (double freq : quantiles.freqs) {
            newComputations.add(new Quantiles(quantiles.column, (List<Double>)ImmutableList.of((Object)freq), quantiles.confidence));
        }
        return new TransformedComputation(new MultiComputation(newComputations)){

            @Override
            public ComputationResult reconstruct(ComputationResult result) {
                if (result.isAtLeastPartiallyFailed()) {
                    return result.getFirstFailedResult();
                }
                if (!result.isFullyAvailable()) {
                    return result.getFirstUnavailableResult();
                }
                MultiComputation.MultiComputationResult multiResult = result.asMulti();
                ArrayList<Quantiles.QuantileDesc> quantilesDescs = new ArrayList<Quantiles.QuantileDesc>();
                for (ComputationResult computationResult : multiResult) {
                    Quantiles.QuantilesResult quantileResult = computationResult.as(Quantiles.QuantilesResult.class);
                    quantilesDescs.add(quantileResult.quantiles.get(0));
                }
                return new Quantiles.QuantilesResult(quantilesDescs);
            }
        }.compose(input);
    }

    protected TransformedComputation factorizeQuantileComputations(TransformedComputation input) {
        if (!input.computation.isMulti()) {
            return input;
        }
        final MultiComputation computations = input.computation.asMulti();
        int nbQuantileComputations = 0;
        for (Object computation : computations) {
            if (!(computation instanceof Quantiles)) continue;
            ++nbQuantileComputations;
        }
        if (nbQuantileComputations <= 1) {
            return input;
        }
        final LinkedHashMap<Pair, Pair> mapping = new LinkedHashMap<Pair, Pair>();
        for (Computation computation : computations) {
            if (!(computation instanceof Quantiles)) continue;
            Quantiles quantiles = computation.as(Quantiles.class);
            for (double freq : quantiles.freqs) {
                Pair key = new Pair((Object)quantiles.column, (Object)quantiles.confidence);
                Pair entry = (Pair)mapping.get(key);
                if (entry == null) {
                    entry = new Pair((Object)mapping.size(), new ArrayList());
                    mapping.put(key, entry);
                }
                ((ArrayList)entry.second).add(freq);
            }
        }
        ArrayList<Computation> newComputations = new ArrayList<Computation>();
        for (Map.Entry entry : mapping.entrySet()) {
            List freqs = (List)((Pair)entry.getValue()).second;
            Pair key = (Pair)entry.getKey();
            newComputations.add(new Quantiles((String)key.first, freqs, (Double)key.second));
        }
        for (Computation computation : computations) {
            if (computation instanceof Quantiles) continue;
            newComputations.add(computation);
        }
        if (newComputations.size() >= computations.size()) {
            return input;
        }
        return new TransformedComputation(new MultiComputation(newComputations)){

            @Override
            public ComputationResult reconstruct(ComputationResult result) {
                if (!result.isAvailable()) {
                    return result;
                }
                MultiComputation.MultiComputationResult multiResults = result.asMulti();
                ArrayList<ComputationResult> reconstructedResults = new ArrayList<ComputationResult>();
                int currentOther = 0;
                for (Computation computation : computations) {
                    if (computation instanceof Quantiles) {
                        UnavailableResult unavailableResult = null;
                        Quantiles quantiles = computation.as(Quantiles.class);
                        ArrayList<Quantiles.QuantileDesc> reconstructedQuantileDescs = new ArrayList<Quantiles.QuantileDesc>();
                        for (double freq : quantiles.freqs) {
                            Pair key = new Pair((Object)quantiles.column, (Object)quantiles.confidence);
                            int newComputationIndex = (Integer)((Pair)mapping.get((Object)key)).first;
                            ComputationResult newQuantilesComputationResults = multiResults.get(newComputationIndex);
                            if (newQuantilesComputationResults.isAvailable()) {
                                reconstructedQuantileDescs.add(newQuantilesComputationResults.as(Quantiles.QuantilesResult.class).getMand(freq));
                                continue;
                            }
                            unavailableResult = newQuantilesComputationResults.asUnavailable();
                            break;
                        }
                        if (unavailableResult == null) {
                            reconstructedResults.add(new Quantiles.QuantilesResult(reconstructedQuantileDescs));
                            continue;
                        }
                        reconstructedResults.add(unavailableResult);
                        continue;
                    }
                    reconstructedResults.add(multiResults.get(currentOther + mapping.size()));
                    ++currentOther;
                }
                return new MultiComputation.MultiComputationResult(reconstructedResults);
            }
        }.compose(input);
    }

    protected TransformedComputation unwrapFromSingletonMultiComputation(TransformedComputation input) {
        Computation original = input.computation;
        if (!original.isMulti() || original.asMulti().size() != 1) {
            return input;
        }
        return new TransformedComputation(original.asMulti().get(0)){

            @Override
            public ComputationResult reconstruct(ComputationResult result) {
                return new MultiComputation.MultiComputationResult(result);
            }
        }.compose(input);
    }

    protected TransformedComputation rotateGroupedComputation(TransformedComputation input) {
        Computation original = input.computation;
        if (!original.isGrouped()) {
            return input;
        }
        GroupedComputation groupedComputation = original.asGrouped();
        if (!groupedComputation.computation.isMulti()) {
            return input;
        }
        MultiComputation multiComputation = groupedComputation.computation.asMulti();
        if (multiComputation.computations.isEmpty()) {
            return input;
        }
        MultiComputation newComputations = new MultiComputation(new Computation[0]);
        for (Computation computation : multiComputation.computations) {
            newComputations.computations.add(new GroupedComputation(computation, groupedComputation.grouping));
        }
        return new TransformedComputation(newComputations){

            @Override
            public ComputationResult reconstruct(ComputationResult result) {
                if (!result.isAvailable()) {
                    return result;
                }
                MultiComputation.MultiComputationResult castedResult = result.asMulti();
                GroupedComputation.GroupedComputationResult firstAvailableComputation = null;
                for (ComputationResult subResult : castedResult) {
                    if (!subResult.isAvailable()) continue;
                    firstAvailableComputation = subResult.asGrouped();
                    break;
                }
                if (firstAvailableComputation == null) {
                    return castedResult.getFirstUnavailableResult();
                }
                for (ComputationResult subResult : castedResult) {
                    if (!subResult.isAvailable() || subResult.asGrouped().groups.equals((Object)firstAvailableComputation.groups)) continue;
                    throw new RuntimeException("Unreachable: groups are different");
                }
                ArrayList<ComputationResult> newGroupedResults = new ArrayList<ComputationResult>();
                for (int groupIdx = 0; groupIdx < firstAvailableComputation.results.size(); ++groupIdx) {
                    ArrayList<ComputationResult> multiComputationResult = new ArrayList<ComputationResult>();
                    for (int compIdx = 0; compIdx < castedResult.size(); ++compIdx) {
                        ComputationResult g = castedResult.get(compIdx);
                        if (g.isAvailable()) {
                            multiComputationResult.add(g.asGrouped().results.get(groupIdx));
                            continue;
                        }
                        multiComputationResult.add(g);
                    }
                    newGroupedResults.add(new MultiComputation.MultiComputationResult(multiComputationResult));
                }
                return new GroupedComputation.GroupedComputationResult(firstAvailableComputation.groups, newGroupedResults);
            }
        }.compose(input);
    }

    protected TransformedComputation rotateResampledComputation(TransformedComputation input) {
        if (!input.computation.isResampled()) {
            return input;
        }
        ResampledComputation resampled = input.computation.asResampled();
        if (!resampled.computation.isMulti()) {
            return input;
        }
        MultiComputation multiComputation = resampled.computation.asMulti();
        if (multiComputation.computations.isEmpty()) {
            return input;
        }
        MultiComputation newMultiComputation = new MultiComputation(new Computation[0]);
        for (Computation computation : multiComputation.computations) {
            ResampledComputation newComputation = new ResampledComputation(computation, resampled.spec);
            newMultiComputation.computations.add(newComputation);
        }
        return new TransformedComputation(newMultiComputation){

            @Override
            public ComputationResult reconstruct(ComputationResult result) {
                if (!result.isAvailable()) {
                    return result;
                }
                MultiComputation.MultiComputationResult multiResult = result.asMulti();
                ArrayList<ComputationResult> actualResults = new ArrayList<ComputationResult>();
                for (ComputationResult r : multiResult) {
                    if (r.isAvailable()) {
                        actualResults.add(r.asResampled().result);
                        continue;
                    }
                    actualResults.add(r);
                }
                return new ResampledComputation.ResampledComputationResult(new MultiComputation.MultiComputationResult(actualResults));
            }
        }.compose(input);
    }

    protected TransformedComputation factorizeIdenticalGrouping(TransformedComputation input) {
        if (!input.computation.isMulti()) {
            return input;
        }
        final MultiComputation computations = input.computation.asMulti();
        final LinkedHashMap<Grouping, Pair> forwardMap = new LinkedHashMap<Grouping, Pair>();
        final ArrayList<Pair> backwardMap = new ArrayList<Pair>();
        ArrayList<Computation> others = new ArrayList<Computation>();
        boolean changed = false;
        for (Computation computation : computations.computations) {
            if (computation.isGrouped()) {
                GroupedComputation groupedComp = computation.asGrouped();
                Pair subComps = (Pair)forwardMap.get((Object)groupedComp.grouping);
                if (subComps == null) {
                    subComps = new Pair((Object)forwardMap.size(), new ArrayList());
                    forwardMap.put(groupedComp.grouping, subComps);
                }
                backwardMap.add(new Pair((Object)((Integer)subComps.first), (Object)((List)subComps.second).size()));
                ((List)subComps.second).add(groupedComp.computation);
                if (((List)subComps.second).size() <= 1) continue;
                changed = true;
                continue;
            }
            others.add(computation);
        }
        if (!changed) {
            return input;
        }
        ArrayList<Computation> newComputations = new ArrayList<Computation>();
        for (Map.Entry entry : forwardMap.entrySet()) {
            newComputations.add(new GroupedComputation(new MultiComputation((List)((Pair)entry.getValue()).second), (Grouping)((Object)entry.getKey())));
        }
        newComputations.addAll(others);
        return new TransformedComputation(new MultiComputation(newComputations)){

            @Override
            public ComputationResult reconstruct(ComputationResult result) {
                if (!result.isAvailable()) {
                    return result;
                }
                ArrayList<ComputationResult> reconstructedResults = new ArrayList<ComputationResult>();
                int currentGroup = 0;
                int currentOther = 0;
                for (int i = 0; i < computations.computations.size(); ++i) {
                    Computation computation = computations.computations.get(i);
                    if (computation.isGrouped()) {
                        Pair mapping = (Pair)backwardMap.get(currentGroup);
                        ++currentGroup;
                        ComputationResult groupResult = result.asMulti().get((Integer)mapping.first);
                        if (!groupResult.isAvailable()) {
                            reconstructedResults.add(groupResult);
                            continue;
                        }
                        GroupedComputation.GroupedComputationResult r = groupResult.asGrouped();
                        ArrayList<ComputationResult> reconstructedGroupResult = new ArrayList<ComputationResult>();
                        for (ComputationResult gr : r.results) {
                            if (gr.isAvailable()) {
                                reconstructedGroupResult.add(gr.asMulti().get((Integer)mapping.second));
                                continue;
                            }
                            reconstructedGroupResult.add(gr);
                        }
                        reconstructedResults.add(new GroupedComputation.GroupedComputationResult(r.groups, reconstructedGroupResult));
                        continue;
                    }
                    reconstructedResults.add(result.asMulti().get(currentOther + forwardMap.size()));
                    ++currentOther;
                }
                return new MultiComputation.MultiComputationResult(reconstructedResults);
            }
        }.compose(input);
    }

    protected TransformedComputation factorizeIdenticalResampling(TransformedComputation input) {
        if (!input.computation.isMulti()) {
            return input;
        }
        final List<Computation> originals = input.computation.asMulti().computations;
        ArrayList<Computation> otherComputations = new ArrayList<Computation>();
        final LinkedHashMap<ResamplerSpec, Pair> factorizedMapping = new LinkedHashMap<ResamplerSpec, Pair>();
        final ArrayList<Pair> reconstructionIndexes = new ArrayList<Pair>();
        for (Computation c2 : originals) {
            if (!c2.isResampled()) {
                otherComputations.add(c2);
                continue;
            }
            ResampledComputation resampled = c2.asResampled();
            Pair mapping = (Pair)factorizedMapping.get((Object)resampled.spec);
            if (mapping == null) {
                mapping = new Pair((Object)factorizedMapping.size(), new ArrayList());
                factorizedMapping.put(resampled.spec, mapping);
            }
            reconstructionIndexes.add(new Pair((Object)((Integer)mapping.first), (Object)((List)mapping.second).size()));
            ((List)mapping.second).add(resampled.computation);
        }
        boolean hasFactoredAtLeastOnce = factorizedMapping.values().stream().anyMatch(it -> ((List)it.second).size() > 1);
        if (!hasFactoredAtLeastOnce) {
            return input;
        }
        MultiComputation newMultiComputation = new MultiComputation(new Computation[0]);
        for (Map.Entry entry : factorizedMapping.entrySet()) {
            ResampledComputation newComputation = new ResampledComputation(new MultiComputation((List)((Pair)entry.getValue()).second), (ResamplerSpec)((Object)entry.getKey()));
            newMultiComputation.computations.add(newComputation);
        }
        newMultiComputation.computations.addAll(otherComputations);
        return new TransformedComputation(newMultiComputation){

            @Override
            public ComputationResult reconstruct(ComputationResult result) {
                if (!result.isAvailable()) {
                    return result;
                }
                MultiComputation.MultiComputationResult topLevelMultiResult = result.asMulti();
                int currentResampling = 0;
                int currentOther = 0;
                ArrayList<ComputationResult> reconstructedResults = new ArrayList<ComputationResult>();
                for (Computation c2 : originals) {
                    if (!c2.isResampled()) {
                        ComputationResult otherResult = topLevelMultiResult.get(currentOther + factorizedMapping.size());
                        ++currentOther;
                        reconstructedResults.add(otherResult);
                        continue;
                    }
                    Pair indexes = (Pair)reconstructionIndexes.get(currentResampling);
                    ++currentResampling;
                    ComputationResult innerResult = topLevelMultiResult.get((Integer)indexes.first);
                    if (!innerResult.isAvailable()) {
                        reconstructedResults.add(innerResult);
                        continue;
                    }
                    ResampledComputation.ResampledComputationResult innerResampledResult = innerResult.asResampled();
                    if (!innerResampledResult.result.isAvailable()) {
                        reconstructedResults.add(innerResampledResult.result);
                        continue;
                    }
                    MultiComputation.MultiComputationResult innerMultiResult = innerResampledResult.result.asMulti();
                    ComputationResult targetResult = innerMultiResult.get((Integer)indexes.second);
                    reconstructedResults.add(new ResampledComputation.ResampledComputationResult(targetResult));
                }
                return new MultiComputation.MultiComputationResult(reconstructedResults);
            }
        }.compose(input);
    }
}

