/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.worksheets.cards;

import com.dataiku.dip.eda.compute.computations.ComputationResult;
import com.dataiku.dip.eda.compute.computations.common.GroupedComputation;
import com.dataiku.dip.eda.compute.computations.univariate.EmpiricalCDF;
import com.dataiku.dip.eda.compute.engine.ComputationResultDataStreamer;
import com.dataiku.dip.eda.compute.filtering.Filter;
import com.dataiku.dip.eda.compute.grouping.CrossGrouping;
import com.dataiku.dip.eda.compute.grouping.Grouping;
import com.dataiku.dip.eda.compute.grouping.GroupingResult;
import com.dataiku.dip.eda.compute.grouping.SubsetGrouping;
import com.dataiku.dip.eda.compute.grouping.UnionGrouping;
import com.dataiku.dip.eda.worksheets.cards.CardResult;
import com.dataiku.dip.eda.worksheets.cards.UnivariateCard;
import com.dataiku.dip.eda.worksheets.cards.common.AbstractCompiledCard;
import com.dataiku.dip.eda.worksheets.cards.common.CardWithColorBy;
import com.dataiku.dip.eda.worksheets.cards.common.CardWithHighlight;
import com.dataiku.dip.eda.worksheets.cards.common.CompiledCard;
import com.dataiku.dip.eda.worksheets.models.SplitBySpec;
import com.dataiku.dip.utils.ImmutableValueObject;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class CDFPlotCard
extends UnivariateCard
implements CardWithHighlight,
CardWithColorBy {
    public static final String TYPE = "cdf_plot";
    @Nullable
    public Filter highlightFilter;
    @Nullable
    public SplitBySpec colorBy;

    @Override
    public void setHighlightFilter(Filter filter) {
        this.highlightFilter = filter;
    }

    @Override
    public void setColorBy(SplitBySpec colorBy) {
        this.colorBy = colorBy;
    }

    @Override
    protected CompiledCard compileNoSplitNoFilter() {
        return new AbstractCompiledCard<GroupedComputation, GroupedComputation.GroupedComputationResult>(){

            @Override
            public GroupedComputation getComputationPlan() {
                Grouping highlightGrouping = CDFPlotCard.this.highlightFilter == null ? SubsetGrouping.all() : new UnionGrouping(new SubsetGrouping(CDFPlotCard.this.highlightFilter), SubsetGrouping.all());
                Grouping colorByGrouping = CDFPlotCard.this.colorBy == null ? SubsetGrouping.all() : CDFPlotCard.this.colorBy.asGrouping();
                return new GroupedComputation(new EmpiricalCDF(CDFPlotCard.this.column.name), new CrossGrouping(highlightGrouping, colorByGrouping));
            }

            @Override
            protected CardResult buildFromAvailableResult(GroupedComputation.GroupedComputationResult result, ComputationResultDataStreamer dataStreamer) {
                GroupingResult highlightGroups = result.groups.asCross().groups.get(0);
                GroupingResult colorByGroups = result.groups.asCross().groups.get(1);
                CDFPlotCardResult cardResult = new CDFPlotCardResult();
                cardResult.groups.addAll(colorByGroups.listFilters());
                for (int highlightIndex = 0; highlightIndex < highlightGroups.size(); ++highlightIndex) {
                    for (int groupIndex = 0; groupIndex < colorByGroups.size(); ++groupIndex) {
                        ComputationResult cdfResult = result.results.get(highlightIndex * colorByGroups.size() + groupIndex);
                        if (!cdfResult.isFullyAvailable()) continue;
                        EmpiricalCDF.EmpiricalCDFResult castedCdfResult = cdfResult.as(EmpiricalCDF.EmpiricalCDFResult.class);
                        CDFItem item = new CDFItem();
                        item.groupIndex = groupIndex;
                        item.probs = castedCdfResult.probs;
                        item.xvals = castedCdfResult.xvals;
                        item.isHighlighted = highlightGroups.size() > 1 && highlightIndex == 0;
                        cardResult.cdfs.add(item);
                    }
                }
                return cardResult;
            }
        };
    }

    public static class CDFPlotCardResult
    extends CardResult {
        List<Filter> groups = new ArrayList<Filter>();
        List<CDFItem> cdfs = new ArrayList<CDFItem>();
    }

    public static class CDFItem
    extends ImmutableValueObject {
        boolean isHighlighted;
        int groupIndex;
        public double[] xvals;
        public double[] probs;
    }
}

