/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.worksheets.cards;

import com.dataiku.dip.eda.compute.computations.Computation;
import com.dataiku.dip.eda.compute.computations.ComputationResult;
import com.dataiku.dip.eda.compute.computations.bivariate.Pearson;
import com.dataiku.dip.eda.compute.computations.bivariate.Spearman;
import com.dataiku.dip.eda.compute.computations.common.MultiComputation;
import com.dataiku.dip.eda.compute.engine.ComputationResultDataStreamer;
import com.dataiku.dip.eda.worksheets.cards.CardResult;
import com.dataiku.dip.eda.worksheets.cards.MultivariateCard;
import com.dataiku.dip.eda.worksheets.cards.common.AbstractCompiledCard;
import com.dataiku.dip.eda.worksheets.cards.common.CompiledCard;
import com.dataiku.dip.eda.worksheets.cards.common.HeatmapParams;
import com.dataiku.dip.eda.worksheets.models.Variable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class CorrelationMatrixCard
extends MultivariateCard {
    public static final String TYPE = "correlation_matrix";
    public HeatmapParams heatmapParams;
    public CorrelationMetric metric = CorrelationMetric.PEARSON;

    public CorrelationMatrixCard(List<Variable> columns, CorrelationMetric metric, HeatmapParams heatmapParams) {
        this.columns = columns;
        this.metric = metric;
        this.heatmapParams = null != heatmapParams ? heatmapParams : new HeatmapParams();
    }

    private CorrelationMatrixCard() {
    }

    @Override
    protected CompiledCard compileNoSplitNoFilter() {
        return new AbstractCompiledCard<MultiComputation, MultiComputation.MultiComputationResult>(){

            @Override
            public MultiComputation getComputationPlan() {
                ArrayList<Computation> scoreParams = new ArrayList<Computation>();
                for (int i = 0; i < CorrelationMatrixCard.this.columns.size(); ++i) {
                    block5: for (int j = i; j < CorrelationMatrixCard.this.columns.size(); ++j) {
                        switch (CorrelationMatrixCard.this.metric) {
                            case PEARSON: {
                                scoreParams.add(new Pearson(((Variable)((Object)CorrelationMatrixCard.this.columns.get((int)i))).name, ((Variable)((Object)CorrelationMatrixCard.this.columns.get((int)j))).name));
                                continue block5;
                            }
                            case SPEARMAN: {
                                scoreParams.add(new Spearman(((Variable)((Object)CorrelationMatrixCard.this.columns.get((int)i))).name, ((Variable)((Object)CorrelationMatrixCard.this.columns.get((int)j))).name));
                            }
                        }
                    }
                }
                return new MultiComputation(scoreParams);
            }

            @Override
            protected CardResult buildFromAvailableResult(MultiComputation.MultiComputationResult result, ComputationResultDataStreamer dataStreamer) {
                Double[] scores = new Double[CorrelationMatrixCard.this.columns.size() * (CorrelationMatrixCard.this.columns.size() + 1) / 2];
                block4: for (int i = 0; i < result.size(); ++i) {
                    ComputationResult scoreResult = result.get(i);
                    if (!scoreResult.isFullyAvailable()) continue;
                    switch (CorrelationMatrixCard.this.metric) {
                        case PEARSON: {
                            scores[i] = scoreResult.as(Pearson.PearsonResult.class).correlation;
                            continue block4;
                        }
                        case SPEARMAN: {
                            scores[i] = scoreResult.as(Spearman.SpearmanResult.class).correlation;
                        }
                    }
                }
                if (result.isAtLeastPartiallyNotComputed()) {
                    return new CardResult.UnavailableCardResult(CardResult.UnavailabilityReason.NOT_COMPUTED, null, null);
                }
                return new CorrelationMatrixCardResult(scores, result.collectWarnings(), this.collectPartialErrors(result));
            }

            protected List<String> collectPartialErrors(MultiComputation.MultiComputationResult results) {
                ArrayList<String> output = new ArrayList<String>();
                for (ComputationResult result : results) {
                    if (!result.isFailed()) continue;
                    output.add(result.asFailed().message);
                }
                return output;
            }
        };
    }

    public static enum CorrelationMetric {
        PEARSON,
        SPEARMAN;

    }

    public static class CorrelationMatrixCardResult
    extends CardResult {
        Double[] scores;
        @Nullable
        List<String> partialErrors;

        public CorrelationMatrixCardResult(Double[] scores, List<String> warnings, List<String> partialErrors) {
            super(warnings);
            this.scores = scores;
            this.partialErrors = partialErrors;
        }

        private CorrelationMatrixCardResult() {
        }
    }
}

