/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.worksheets.cards;

import com.dataiku.dip.eda.compute.computations.ComputationResult;
import com.dataiku.dip.eda.compute.computations.common.GroupedComputation;
import com.dataiku.dip.eda.compute.computations.multivariate.FetchValues;
import com.dataiku.dip.eda.compute.computations.multivariate.PCA;
import com.dataiku.dip.eda.compute.engine.ComputationResultDataStreamer;
import com.dataiku.dip.eda.compute.filtering.AllFilter;
import com.dataiku.dip.eda.compute.filtering.Filter;
import com.dataiku.dip.eda.compute.grouping.Grouping;
import com.dataiku.dip.eda.compute.grouping.SubsetGrouping;
import com.dataiku.dip.eda.worksheets.cards.CardResult;
import com.dataiku.dip.eda.worksheets.cards.MultivariateCard;
import com.dataiku.dip.eda.worksheets.cards.common.AbstractCompiledCard;
import com.dataiku.dip.eda.worksheets.cards.common.CardWithColorBy;
import com.dataiku.dip.eda.worksheets.cards.common.CompiledCard;
import com.dataiku.dip.eda.worksheets.cards.common.FilteredCompiledCardWrapper;
import com.dataiku.dip.eda.worksheets.cards.common.HeatmapParams;
import com.dataiku.dip.eda.worksheets.cards.common.RecipeCompatibleCard;
import com.dataiku.dip.eda.worksheets.models.SplitBySpec;
import com.dataiku.dip.eda.worksheets.models.Variable;
import com.dataiku.dip.utils.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;

public class PCACard
extends MultivariateCard
implements CardWithColorBy,
RecipeCompatibleCard {
    public static final String TYPE = "pca";
    private static final String INPUT_PREFIX = "input_";
    @Nullable
    public SplitBySpec colorBy;
    public HeatmapParams heatmapParams;
    public boolean showScatterPlot = true;
    public boolean showLoadingPlot = false;
    public boolean showScreePlot = true;
    public boolean showComponents = true;

    public PCACard(List<Variable> columns, HeatmapParams heatmapParams) {
        this.columns = columns;
        this.heatmapParams = null != heatmapParams ? heatmapParams : new HeatmapParams();
    }

    private PCACard() {
    }

    @Override
    public void setColorBy(SplitBySpec colorBy) {
        this.colorBy = colorBy;
    }

    @Override
    public CompiledCard compileNoSplitNoFilter() {
        AbstractCompiledCard<PCA, PCA.PCAResult> compiled = new AbstractCompiledCard<PCA, PCA.PCAResult>(){

            @Override
            public PCA getComputationPlan() {
                Grouping grouping;
                if (PCACard.this.colorBy == null) {
                    grouping = new SubsetGrouping(new AllFilter());
                } else {
                    SplitBySpec aliasedColorBy = (SplitBySpec)((Object)JSON.deepCopy((Object)((Object)PCACard.this.colorBy)));
                    aliasedColorBy.groupingColumn.name = String.format("%s%s", PCACard.INPUT_PREFIX, aliasedColorBy.groupingColumn.name);
                    grouping = aliasedColorBy.asGrouping();
                }
                int projectionDimension = 2;
                List<String> projectionColumnNames = PCA.generateProjectionColumnNames(projectionDimension);
                GroupedComputation projectionComputation = new GroupedComputation(new FetchValues(projectionColumnNames), grouping);
                return new PCA(PCACard.this.getColumnNames(), projectionComputation, projectionDimension, PCACard.INPUT_PREFIX);
            }

            @Override
            protected CardResult buildFromAvailableResult(PCA.PCAResult pca, ComputationResultDataStreamer dataStreamer) {
                GroupedComputation.GroupedComputationResult projectionComputationResult = pca.projectionComputationResult.asGrouped();
                ArrayList<double[][]> projections = new ArrayList<double[][]>();
                for (ComputationResult result : projectionComputationResult.results) {
                    projections.add((double[][])result.as(FetchValues.FetchValuesResult.class).series.toArray((T[])new double[0][]));
                }
                List<Filter> groupFilters = projectionComputationResult.groups.listFilters();
                for (Filter f : groupFilters) {
                    f.trimColumnNamePrefix(PCACard.INPUT_PREFIX);
                }
                return new PCACardResult(pca.eigenvectors, pca.eigenvalues, PCACard.explainedVarianceRatio(pca.eigenvalues), groupFilters, (double[][][])projections.toArray((T[])new double[0][][]), pca.collectWarnings());
            }
        };
        if (this.filter != null) {
            compiled = new FilteredCompiledCardWrapper(this.filter, compiled);
        }
        return compiled;
    }

    public static double[] explainedVarianceRatio(double[] eigenvalues) {
        double total = 0.0;
        for (double v : eigenvalues) {
            total += v;
        }
        double[] ratios = Arrays.copyOf(eigenvalues, eigenvalues.length);
        for (int i = 0; i < ratios.length; ++i) {
            ratios[i] = total > 0.0 ? ratios[i] / total : 0.0;
        }
        return ratios;
    }

    public static class PCACardResult
    extends CardResult {
        public double[][] components;
        public double[] explainedVariance;
        public double[] explainedVarianceRatio;
        public List<Filter> groups;
        public double[][][] projections;

        public PCACardResult(double[][] components, double[] explainedVariance, double[] explainedVarianceRatio, List<Filter> groups, double[][][] projections, List<String> warnings) {
            super(warnings);
            this.components = components;
            this.explainedVariance = explainedVariance;
            this.explainedVarianceRatio = explainedVarianceRatio;
            this.groups = groups;
            this.projections = projections;
        }

        private PCACardResult() {
        }
    }
}

