/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.input.formats;

import com.dataiku.dip.coremodel.FormatParams;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datasets.SchemaDetection;
import com.dataiku.dip.formats.FormatFactory;
import com.dataiku.dip.formats.FormatMeta;
import com.dataiku.dip.input.formats.ArchiveCapableFormatExtractor;
import com.dataiku.dip.output.OutputFormatter;
import com.dataiku.dip.plugin.InputStreamWithContextInfo;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.util.ParamDesc;
import com.dataiku.dip.utils.NotImplementedException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class MySQLDumpFormatExtractor
extends ArchiveCapableFormatExtractor {
    public static final FormatMeta<MySQLDumpFormatExtractor, Config> META = new FormatMeta<MySQLDumpFormatExtractor, Config>(){

        @Override
        public String getType() {
            return "mysql_dump";
        }

        @Override
        public Class<? extends FormatParams> paramsClass() {
            return Config.class;
        }

        @Override
        public MySQLDumpFormatExtractor build(AuthCtx authCtx, String projectKey, FormatParams params) {
            return new MySQLDumpFormatExtractor((Config)params);
        }

        @Override
        public OutputFormatter buildFormatter(AuthCtx authCtx, String projectKey, FormatParams params) {
            throw new NotImplementedException();
        }

        @Override
        public String getLabel() {
            return "MySQL dump";
        }

        @Override
        public SchemaDetection.SchemaHandlingType getSchemaHandlingType() {
            return SchemaDetection.SchemaHandlingType.TEXT_POSITION_BASED_FIXED_COLUMNS;
        }

        @Override
        public ParamDesc[] getParams() {
            return new ParamDesc[]{ParamDesc.string("table", "Table").withMandatory(true), ParamDesc.string("charset", "Charset").withMandatory(false), FormatFactory.getStandardCompressionMethods()};
        }
    };
    private Config config;
    private static Logger logger = Logger.getLogger((String)"dku.format.mysql");

    public MySQLDumpFormatExtractor(Config config) {
        if (config == null || StringUtils.isBlank((String)config.table)) {
            throw new IllegalArgumentException("Missing 'table' argument in MySQL Dump format");
        }
        this.config = config;
    }

    @Override
    protected boolean doExtractStream(InputStreamWithContextInfo isn, ProcessorOutput out, ColumnFactory cf, RowFactory rf, ArchiveCapableFormatExtractor.ArchiveCapableObserver observer) throws Exception {
        InputStream is = isn.getInputStream();
        long nlines = 0L;
        Pattern linePattern = Pattern.compile("([\"'])((?:\\\\.|(?!\\1).)*+)\\1|((?:\\d|\\.)++)|(NULL)");
        Pattern insertPattern = Pattern.compile("^INSERT INTO ([\"`])" + Pattern.quote(this.config.table) + "\\1 VALUES ");
        logger.info((Object)"MySQL dump, starting to process one stream");
        Matcher lineMatcher = linePattern.matcher("");
        Matcher insertMatcher = insertPattern.matcher("");
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(is, this.config.charset));){
            block20: {
                int pos;
                int lineIdx = 0;
                block6: while (true) {
                    if (!observer.checkLimit(lineIdx)) {
                        boolean bl = false;
                        return bl;
                    }
                    String line = reader.readLine();
                    if (line == null) break block20;
                    ++lineIdx;
                    if (!insertMatcher.reset(line).find()) continue;
                    lineMatcher.reset(line);
                    pos = insertMatcher.end();
                    while (true) {
                        if (pos >= line.length()) continue block6;
                        Row row = rf.row();
                        if (line.charAt(pos) != '(') {
                            throw new IOException("Failed to parse MySQL dump");
                        }
                        ++pos;
                        int colIdx = 0;
                        while (true) {
                            if (lineMatcher.find(pos)) {
                                if (lineMatcher.group(2) != null) {
                                    String val = lineMatcher.group(2);
                                    if (val.indexOf(92) >= 0) {
                                        val = StringUtils.replace((String)val, (String)"\\'", (String)"'");
                                        val = StringUtils.replace((String)val, (String)"\\n", (String)"\n");
                                        val = StringUtils.replace((String)val, (String)"\\r", (String)"\r");
                                    }
                                    row.put(cf.column("col_" + colIdx), val);
                                } else if (lineMatcher.group(3) != null) {
                                    row.put(cf.column("col_" + colIdx), lineMatcher.group(3));
                                }
                            } else {
                                throw new IOException();
                            }
                            pos = lineMatcher.end();
                            ++colIdx;
                            if (line.charAt(pos) != ',') break;
                            ++pos;
                        }
                        if (line.charAt(pos) == ')') {
                            ++pos;
                        } else {
                            throw new IOException();
                        }
                        out.emitRow(row);
                        if (++nlines % 500L == 0L) {
                            observer.onInterval(nlines);
                        }
                        if (line.charAt(pos) != ',') break;
                        ++pos;
                    }
                    if (line.charAt(pos) != ';') break;
                }
                throw new IOException("Failed to parse MySQL dump at line " + lineIdx + " pos " + pos);
            }
            observer.onEnd(nlines);
        }
        return true;
    }

    public static class Config
    implements FormatParams {
        public String table;
        public String charset = "utf8";

        public Config() {
        }

        public Config(String table) {
            this.table = table;
        }
    }
}

