/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.labeling.consensus;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.labeling.BaseLabelingAnswer;
import com.dataiku.dip.labeling.LabelingAnswer;
import com.dataiku.dip.labeling.LabelingInternalDBService;
import com.dataiku.dip.labeling.LabelingService;
import com.dataiku.dip.labeling.LabelingTask;
import com.dataiku.dip.labeling.VerifiedLabelingAnswer;
import com.dataiku.dip.labeling.consensus.ConsensusLabelingAnswerComputerImpl;
import com.dataiku.dip.labeling.consensus.ResolutionResult;
import com.dataiku.dip.labeling.score.LabelingScoreComputer;
import com.dataiku.dip.labeling.score.LabelingScoreComputerFactory;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ResolutionService {
    @Autowired
    private FutureService futureService;
    @Autowired
    private LabelingInternalDBService labelingInternalDBService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.labeling.resolution.service");

    public VerifiedLabelingAnswer saveConsensus(LabelingTask labelingTask, VerifiedLabelingAnswer consensusAnswer, AuthCtx authCtx) throws Exception {
        List<LabelingAnswer> answers = this.labelingInternalDBService.listAll(authCtx, labelingTask, consensusAnswer.recordId);
        ResolutionService.prepareConsensusAnswersForSaving(labelingTask, authCtx, consensusAnswer, answers);
        this.labelingInternalDBService.saveAnswer(consensusAnswer);
        this.labelingInternalDBService.saveAnswers(answers);
        return consensusAnswer;
    }

    private static void prepareConsensusAnswersForSaving(LabelingTask labelingTask, AuthCtx authCtx, VerifiedLabelingAnswer consensusAnswer, List<LabelingAnswer> answers) {
        LabelingScoreComputer<?, ?> computer = LabelingScoreComputerFactory.getScoreComputer(labelingTask);
        long currentTime = System.currentTimeMillis();
        for (LabelingAnswer answer : answers) {
            answer.status = LabelingAnswer.AnswerStatus.REVIEWED;
            answer.reviewer = authCtx.getIdentifier();
            answer.reviewTime = currentTime;
            answer.verifiedLabel = computer.computeVerifiedLabel(answer, consensusAnswer);
            answer.lastUpdateTime = currentTime;
        }
        consensusAnswer.lastUpdateTime = currentTime;
        consensusAnswer.creationTime = currentTime;
        consensusAnswer.reviewer = authCtx.getIdentifier();
    }

    public static FuturePayload buildFuturePayload(LabelingTask labelingTask) {
        FuturePayload fp = FuturePayload.newSimple((String)"labeling_resolve_consensual_records", (String)"Resolve consensual records");
        fp.targets.add(new FuturePayload.FuturePayloadTarget(labelingTask.getProjectKey(), labelingTask.id, "Labeling task " + labelingTask.id + " of project " + labelingTask.getProjectKey(), null));
        return fp;
    }

    public FutureResponse<ResolutionResult> resolveConsensualRecordsInFuture(LabelingTask labelingTask, AuthCtx authCtx) throws Exception {
        ResolveConsensualRecordsThread ft = new ResolveConsensualRecordsThread(labelingTask, (DSSAuthCtx)authCtx);
        return this.futureService.runFuture(ft, 0L, new TypeToken<FutureResponse<ResolutionResult>>(){});
    }

    static class ResolveConsensualRecordsThread
    extends SimpleFutureThread<ResolutionResult> {
        private final FuturePayload futurePayload;
        private final LabelingTask labelingTask;
        @Autowired
        private LabelingInternalDBService labelingInternalDBService;
        @Autowired
        private LabelingService labelingService;

        public ResolveConsensualRecordsThread(LabelingTask labelingTask, DSSAuthCtx authCtx) {
            super((AuthCtx)authCtx);
            this.labelingTask = labelingTask;
            this.futurePayload = ResolutionService.buildFuturePayload(labelingTask);
            SpringUtils.getInstance().autowire((Object)this);
        }

        public FuturePayload getPayload() {
            return this.futurePayload;
        }

        @Override
        public double getDangerosity() {
            return 1.0;
        }

        @Override
        public ResolutionResult compute() throws Exception {
            Dataset metadataDataset = this.labelingService.getMetadataDataset(this.labelingTask);
            ConsensusLabelingAnswerComputerImpl consensusAnswerComputer = new ConsensusLabelingAnswerComputerImpl(this.labelingTask);
            long start = System.currentTimeMillis();
            List<String> recordIdsToResolve = this.labelingInternalDBService.getAnnotatedButNotReviewedRecordIds(this.owner, this.labelingTask, metadataDataset);
            int nbResolvedRecords = 0;
            int nbConflictingRecords = 0;
            ArrayList<BaseLabelingAnswer> answersToSave = new ArrayList<BaseLabelingAnswer>();
            for (String recordIdToReview : recordIdsToResolve) {
                List<LabelingAnswer> answers;
                VerifiedLabelingAnswer consensusAnswer = consensusAnswerComputer.compute(recordIdToReview, answers = this.labelingInternalDBService.listAll(this.owner, this.labelingTask, recordIdToReview));
                if (consensusAnswer != null) {
                    ResolutionService.prepareConsensusAnswersForSaving(this.labelingTask, this.owner, consensusAnswer, answers);
                    answersToSave.add(consensusAnswer);
                    answersToSave.addAll(answers);
                    ++nbResolvedRecords;
                    continue;
                }
                ++nbConflictingRecords;
            }
            this.labelingInternalDBService.saveAnswers(answersToSave);
            long timeInMs = System.currentTimeMillis() - start;
            logger.info((Object)("Done resolving consensual record: nbResolved=" + nbResolvedRecords + ", nbConflicting=" + nbConflictingRecords + " (in " + timeInMs + "ms)"));
            return new ResolutionResult(nbResolvedRecords, timeInMs);
        }

        static {
            JSON.registerAdapter(ResolveConsensualRecordsThread.class, (Object)new JSON.Adapter<ResolveConsensualRecordsThread>(){

                public ResolveConsensualRecordsThread deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext ctx) throws JsonParseException {
                    JsonObject jsonObj = jsonElement.getAsJsonObject();
                    DSSAuthCtx owner = (DSSAuthCtx)((Object)ctx.deserialize(jsonObj.get("owner"), DSSAuthCtx.class));
                    LabelingTask labelingTask = (LabelingTask)ctx.deserialize(jsonObj.get("labelingTask"), LabelingTask.class);
                    return new ResolveConsensualRecordsThread(labelingTask, owner);
                }

                public JsonElement serialize(ResolveConsensualRecordsThread resolveConsensualRecordsThread, Type type, JsonSerializationContext ctx) {
                    JsonObject ret = new JsonObject();
                    ret.add("owner", ctx.serialize((Object)resolveConsensualRecordsThread.owner));
                    ret.add("labelingTask", ctx.serialize((Object)resolveConsensualRecordsThread.labelingTask));
                    return ret;
                }
            });
        }
    }
}

