/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.custom;

import com.dataiku.dip.custom.PluginSettingsResolver;
import com.dataiku.dip.llm.LLMStructuredRef;
import com.dataiku.dip.llm.online.LLMClient;
import com.dataiku.dip.llm.promptstudio.PromptStudio;
import com.dataiku.dip.resourceusage.ComputeResourceUsage;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.NotImplementedException;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;

public abstract class CustomLLMClient
implements Closeable {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.llm.custom");

    public abstract void init(PluginSettingsResolver.ResolvedSettings var1);

    public abstract int getMaxParallelism();

    public abstract List<LLMClient.SimpleCompletionResponse> completeBatch(List<LLMClient.CompletionQuery> var1) throws IOException;

    @Deprecated(since="12.6.0", forRemoval=true)
    public List<LLMClient.SimpleEmbeddingResponse> embedBatch(List<LLMClient.EmbeddingQuery> queries) throws IOException {
        throw new NotImplementedException("This plugin should override the method embedBatch(List, EmbeddingSettings)");
    }

    public List<LLMClient.SimpleEmbeddingResponse> embedBatch(List<LLMClient.EmbeddingQuery> queries, LLMClient.EmbeddingSettings settings) throws IOException {
        logger.info((Object)"Using deprecated embedBatch method that does not leverage embedding settings");
        return this.embedBatch(queries);
    }

    public boolean supportsStream() {
        return false;
    }

    public void streamComplete(LLMClient.CompletionQuery query, LLMClient.StreamedCompletionResponseConsumer consumer) throws Exception {
        throw new UnsupportedOperationException("Streaming not supported on LLM: " + String.valueOf(this.getClass()));
    }

    public LLMClient.ImageGenerationResponse generateImages(LLMClient.ImageGenerationQuery query) throws Exception {
        throw new UnsupportedOperationException("Image generation not supported on LLM: " + String.valueOf(this.getClass()));
    }

    public RateLimitingRetrySettings getRetrySettings() {
        return new RateLimitingRetrySettings();
    }

    @Deprecated(since="14.0.0", forRemoval=true)
    public ComputeResourceUsage getTotalCRU(ComputeResourceUsage.LLMUsageType usageType, PromptStudio.LLMStructuredRef llmRef) {
        throw new NotImplementedException("This plugin should override the method getTotalCRU(LLMUsageType, LLMStructuredRef)");
    }

    public ComputeResourceUsage getTotalCRU(ComputeResourceUsage.LLMUsageType usageType, LLMStructuredRef llmRef) {
        PromptStudio.LLMStructuredRef backwardCompatibleLLMRef = new PromptStudio.LLMStructuredRef(llmRef);
        return this.getTotalCRU(usageType, backwardCompatibleLLMRef);
    }

    @Override
    public void close() {
    }

    public static class RateLimitingRetrySettings {
        public int maxRetries = 3;
        public long initialRetryDelayMS = 3000L;
        public double retryDelayScalingFactor = 2.0;

        public final boolean equals(Object o) {
            if (!(o instanceof RateLimitingRetrySettings)) {
                return false;
            }
            RateLimitingRetrySettings that = (RateLimitingRetrySettings)o;
            return this.maxRetries == that.maxRetries && this.initialRetryDelayMS == that.initialRetryDelayMS && Double.compare(this.retryDelayScalingFactor, that.retryDelayScalingFactor) == 0;
        }

        public int hashCode() {
            int result = this.maxRetries;
            result = 31 * result + Long.hashCode(this.initialRetryDelayMS);
            result = 31 * result + Double.hashCode(this.retryDelayScalingFactor);
            return result;
        }
    }

    public static class RetryableException
    extends IOException {
        public RetryableException(Exception cause) {
            super(cause);
        }

        public RetryableException(String message) {
            super(new Exception(message));
        }
    }
}

