/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.online.openai;

import com.dataiku.common.stereotype.RoutinelyUsedInExtensionCode;
import com.dataiku.dip.llm.online.marshall.CoreCompletionSettings;
import com.dataiku.dip.llm.online.marshall.CoreCompletionSettingsValidator;
import com.dataiku.dip.llm.online.openai.OpenAIMode;

@RoutinelyUsedInExtensionCode
public class OpenAIChatCompletionSettingsValidator {
    private static final CoreCompletionSettingsValidator azureLLMValidator = new CoreCompletionSettingsValidator("Azure LLM (chat)").allowMaxTokens().allowTemperature().allowTopP().allowFrequencyPenalty().allowPresencePenalty().allowLogitBias().allowStopSequences().allowTools();
    private static final CoreCompletionSettingsValidator openAIValidator = new CoreCompletionSettingsValidator("OpenAI (chat)", azureLLMValidator).allowJsonMode().allowJsonSchema().allowLogProbs();
    private static final CoreCompletionSettingsValidator azureOpenAIValidator = new CoreCompletionSettingsValidator("Azure OpenAI (chat)", azureLLMValidator).allowJsonMode().allowJsonSchema().allowLogProbs();
    private static final CoreCompletionSettingsValidator nvidiaNimValidator = new CoreCompletionSettingsValidator("NVIDIA NIM (chat)", azureLLMValidator).allowJsonMode().allowJsonSchema().allowLogProbs();

    @RoutinelyUsedInExtensionCode
    public void validate(OpenAIMode mode, CoreCompletionSettings ccs) {
        switch (mode) {
            case OPENAI: {
                openAIValidator.validate(ccs);
                break;
            }
            case AZURE_OPENAI: 
            case AZURE_AI_FOUNDRY: {
                azureOpenAIValidator.validate(ccs);
                break;
            }
            case AZURE_LLM: {
                azureLLMValidator.validate(ccs);
                break;
            }
            case NVIDIA_NIM: {
                nvidiaNimValidator.validate(ccs);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unknown mode: %s", mode.name()));
            }
        }
    }
}

