/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.metrics.probes;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.DSSTempUtils;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dataflow.exec.grouping.Grouper2;
import com.dataiku.dip.dataflow.exec.grouping.GroupingRecipePayloadParams;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datalayer.SinkProcessorOutput;
import com.dataiku.dip.datalayer.sort.Sorter;
import com.dataiku.dip.datalayer.streamimpl.StreamColumnFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamRowFactory;
import com.dataiku.dip.datasets.DatasetCodes;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.SchemaUtils;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.datasets.sql.BuiltinSQLDatasets;
import com.dataiku.dip.input.formats.csv.CSVDeserializer;
import com.dataiku.dip.meanings.IBasicMeaningsService;
import com.dataiku.dip.metrics.Metric;
import com.dataiku.dip.metrics.MetricComputation;
import com.dataiku.dip.metrics.MetricComputer;
import com.dataiku.dip.metrics.MetricMetadata;
import com.dataiku.dip.metrics.MetricTargetType;
import com.dataiku.dip.metrics.engines.DSSMetricsEngine;
import com.dataiku.dip.metrics.engines.HiveMetricsEngine;
import com.dataiku.dip.metrics.engines.ImpalaMetricsEngine;
import com.dataiku.dip.metrics.engines.MetricsEngineRun;
import com.dataiku.dip.metrics.engines.MetricsQueryBuilder;
import com.dataiku.dip.metrics.engines.SQLMetricsEngine;
import com.dataiku.dip.metrics.engines.SparkMetricsEngine;
import com.dataiku.dip.metrics.probes.Probe;
import com.dataiku.dip.metrics.probes.ProbeConfiguration;
import com.dataiku.dip.metrics.probes.ProbeMetadata;
import com.dataiku.dip.metrics.probes.ProbeType;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.queries.QueryRunResult;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.shaker.types.Date;
import com.dataiku.dip.shaker.types.DateOnly;
import com.dataiku.dip.shaker.types.DatetimeNoTz;
import com.dataiku.dip.sql.BigQuerySQLDialect;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.TeradataSQLDialect;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.ExpressionUtils;
import com.dataiku.dip.sql.queries.QueryAst;
import com.dataiku.dip.sql.queries.SelectQueryBuilder;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.utils.DKUDateUtils;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import com.dataiku.dss.shadelib.org.joda.time.LocalDateTime;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.log4j.Logger;

public class BasicStatsDatasetProbeType
extends ProbeType {
    public static final String TYPE = "col_stats";
    private static Map<BasicStatsDatasetMetrics, MetricMetadata> metadataPerType = Maps.newHashMap();
    private static Date dateMeaning = new Date();
    private static DateOnly dateOnlyMeaning = new DateOnly();
    private static DatetimeNoTz datetimeNoTzMeaning = new DatetimeNoTz();
    private static Logger logger = Logger.getLogger((String)"dku.datasets.metrics.basicstats");

    @Override
    public List<MetricComputer> getComputers(IBasicMeaningsService basicMeaningsService) {
        ArrayList computers = Lists.newArrayList();
        computers.add(new BasicStatsDSSGrouperComputer());
        computers.add(new BasicStatsDSSHistogramComputer());
        computers.add(new BasicStatsSQLMetricsEngineComputer(new BasicStatsMetricsEngineComputer(true)));
        computers.add(new BasicStatsImpalaMetricsEngineComputer(new BasicStatsMetricsEngineComputer(false)));
        computers.add(new BasicStatsHiveMetricsEngineComputer(new BasicStatsMetricsEngineComputer(false)));
        computers.add(new BasicStatsSparkMetricsEngineComputer(new BasicStatsMetricsEngineComputer(false)));
        return computers;
    }

    public BasicStatsDatasetProbeType() {
        metadataPerType.put(BasicStatsDatasetMetrics.MIN, new MetricMetadata().withName("Min").withFormat("longReadableNumber"));
        metadataPerType.put(BasicStatsDatasetMetrics.MAX, new MetricMetadata().withName("Max").withFormat("longReadableNumber"));
        metadataPerType.put(BasicStatsDatasetMetrics.MEAN, new MetricMetadata().withName("Avg").withFormat("longReadableNumber"));
        metadataPerType.put(BasicStatsDatasetMetrics.SUM, new MetricMetadata().withName("Sum").withFormat("longReadableNumber"));
        metadataPerType.put(BasicStatsDatasetMetrics.COUNT, new MetricMetadata().withName("Count").withFormat("longReadableNumber"));
        metadataPerType.put(BasicStatsDatasetMetrics.COUNT_NULL, new MetricMetadata().withName("Empty value count"));
        metadataPerType.put(BasicStatsDatasetMetrics.STDDEV, new MetricMetadata().withName("Std. dev.").withFormat("longReadableNumber"));
        metadataPerType.put(BasicStatsDatasetMetrics.COUNT_DISTINCT, new MetricMetadata().withName("Distinct value count"));
        metadataPerType.put(BasicStatsDatasetMetrics.COUNT_UNIQUE, new MetricMetadata().withName("Unique value count"));
        metadataPerType.put(BasicStatsDatasetMetrics.HISTOGRAM, new MetricMetadata().withName("Histogram"));
        this.type = TYPE;
    }

    @Override
    public List<Metric> listBuildableMetrics(Object object, MetricTargetType objectType) {
        ArrayList metrics = Lists.newArrayList();
        if (objectType == MetricTargetType.DATASET) {
            Dataset dataset = (Dataset)object;
            for (SchemaColumn column : dataset.getSchema().getColumns()) {
                for (BasicStatsDatasetMetrics aggregated : BasicStatsDatasetMetrics.values()) {
                    boolean enabled;
                    boolean aggregateNeedNumeric = aggregated == BasicStatsDatasetMetrics.SUM;
                    boolean aggregateNeedNumericOrTemporal = aggregated == BasicStatsDatasetMetrics.STDDEV || aggregated == BasicStatsDatasetMetrics.MEAN || aggregated == BasicStatsDatasetMetrics.HISTOGRAM;
                    boolean bl = enabled = !(aggregateNeedNumeric && !column.getType().isNumeric() || aggregateNeedNumericOrTemporal && !column.getType().isNumeric() && !column.getType().isTemporal());
                    if (!enabled) continue;
                    BasicStatsDatasetMetric metric = new BasicStatsDatasetMetric(aggregated, column.getName(), column.getType());
                    metrics.add(metric);
                }
            }
        }
        return metrics;
    }

    @Override
    public Object listSelectableMetrics(Probe probe, Object object, MetricTargetType objectType) {
        if (objectType == MetricTargetType.DATASET) {
            BasicStatsDatasetProbeHint probeHint = new BasicStatsDatasetProbeHint();
            Dataset dataset = (Dataset)object;
            for (SchemaColumn column : dataset.getSchema().getColumns()) {
                BasicStatsDatasetProbeColumnHint columnHint = new BasicStatsDatasetProbeColumnHint(column.getName());
                HashSet activeMetrics = Sets.newHashSet();
                for (BasicStatsDatasetProbeColumnConfiguration aggregate : ((BasicStatsDatasetProbeConfiguration)probe.configuration).aggregates) {
                    if (!Objects.equals(aggregate.column, column.getName())) continue;
                    activeMetrics.add(aggregate.aggregated);
                }
                for (BasicStatsDatasetMetrics aggregated : BasicStatsDatasetMetrics.values()) {
                    boolean aggregateNeedNumeric = aggregated == BasicStatsDatasetMetrics.SUM;
                    boolean aggregateNeedNumericOrTemporal = aggregated == BasicStatsDatasetMetrics.STDDEV || aggregated == BasicStatsDatasetMetrics.MEAN || aggregated == BasicStatsDatasetMetrics.HISTOGRAM;
                    boolean enabled = !(aggregateNeedNumeric && !column.getType().isNumeric() || aggregateNeedNumericOrTemporal && !column.getType().isNumeric() && !column.getType().isTemporal());
                    columnHint.metrics.add(new BasicStatsDatasetProbeMetricHint(BasicStatsDatasetProbeType.metadataPerType.get((Object)((Object)aggregated)).name, aggregated, activeMetrics.contains((Object)aggregated), !enabled));
                }
                probeHint.columns.add(columnHint);
            }
            return probeHint;
        }
        return null;
    }

    @Override
    public List<Metric> getMetricsToCompute(Probe probe, Object object, MetricTargetType objectType, boolean forDisplay) {
        ArrayList metrics = Lists.newArrayList();
        if (objectType == MetricTargetType.DATASET) {
            Dataset dataset = (Dataset)object;
            BasicStatsDatasetProbeConfiguration configuration = (BasicStatsDatasetProbeConfiguration)probe.getConfiguration();
            for (BasicStatsDatasetProbeColumnConfiguration configured : configuration.aggregates) {
                SchemaColumn column = dataset.getSchema().getColumn(configured.column);
                if (column != null) {
                    BasicStatsDatasetMetric metric = new BasicStatsDatasetMetric(configured.aggregated, column.getName(), column.getType());
                    metrics.add(metric);
                    if (configured.aggregated == BasicStatsDatasetMetrics.HISTOGRAM) {
                        BasicStatsDatasetMetric minMetric = new BasicStatsDatasetMetric(BasicStatsDatasetMetrics.MIN, column.getName(), column.getType());
                        BasicStatsDatasetMetric maxMetric = new BasicStatsDatasetMetric(BasicStatsDatasetMetrics.MAX, column.getName(), column.getType());
                        metrics.add(minMetric);
                        metrics.add(maxMetric);
                        continue;
                    }
                    if (configured.aggregated != BasicStatsDatasetMetrics.STDDEV || !column.getType().isTemporal()) continue;
                    BasicStatsDatasetMetric meanMetric = new BasicStatsDatasetMetric(BasicStatsDatasetMetrics.MEAN, column.getName(), column.getType());
                    metrics.add(meanMetric);
                    continue;
                }
                logger.warn((Object)("Configured a metric on '" + configured.column + "' which has disappeared since. Skipping."));
            }
        }
        return metrics;
    }

    @Override
    public ProbeConfiguration buildFullConfiguration(List<SchemaColumn> columns, Probe probe) {
        BasicStatsDatasetProbeConfiguration configuration = new BasicStatsDatasetProbeConfiguration();
        for (SchemaColumn column : columns) {
            for (BasicStatsDatasetMetrics aggregated : BasicStatsDatasetMetrics.values()) {
                boolean enabled;
                boolean aggregateNeedNumeric = aggregated == BasicStatsDatasetMetrics.SUM;
                boolean aggregateNeedNumericOrTemporal = aggregated == BasicStatsDatasetMetrics.STDDEV || aggregated == BasicStatsDatasetMetrics.MEAN || aggregated == BasicStatsDatasetMetrics.HISTOGRAM;
                boolean bl = enabled = !(aggregateNeedNumeric && !column.getType().isNumeric() || aggregateNeedNumericOrTemporal && !column.getType().isNumeric() && !column.getType().isTemporal());
                if (!enabled) continue;
                BasicStatsDatasetProbeColumnConfiguration columnConfiguration = new BasicStatsDatasetProbeColumnConfiguration();
                columnConfiguration.aggregated = aggregated;
                columnConfiguration.column = column.getName();
                configuration.aggregates.add(columnConfiguration);
            }
        }
        return configuration;
    }

    @Override
    public ProbeType trimForSave() {
        return new BasicStatsDatasetProbeType();
    }

    @Override
    public Class<? extends ProbeConfiguration> getParamsClazz() {
        return BasicStatsDatasetProbeConfiguration.class;
    }

    @Override
    public ProbeMetadata getMeta() {
        return new ProbeMetadata().withLevel(2).withName("Columns statistics");
    }

    @Override
    public boolean isUserSelectedProbe() {
        return false;
    }

    private static long getLongEvenOnOracle(String value) {
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException ex) {
            if (value.endsWith(".0")) {
                return Long.parseLong(value.substring(0, value.length() - 2));
            }
            throw ex;
        }
    }

    private static Double getStdDevOnDouble(String sumStr, String sum2Str, String cntStr) {
        if (StringUtils.isBlank((String)sumStr) || StringUtils.isBlank((String)sum2Str) || StringUtils.isBlank((String)cntStr)) {
            return null;
        }
        double sum = Double.parseDouble(sumStr);
        double sum2 = Double.parseDouble(sum2Str);
        double cnt = Double.parseDouble(cntStr);
        if (cnt < 1.0E-10) {
            return null;
        }
        return Math.sqrt(Math.max(0.0, (sum2 - sum * sum / cnt) / cnt));
    }

    private static Double getStdDevOnLong(String sumStr, String sum2Str, String cntStr) {
        if (StringUtils.isBlank((String)sumStr) || StringUtils.isBlank((String)sum2Str) || StringUtils.isBlank((String)cntStr)) {
            return null;
        }
        long sum = BasicStatsDatasetProbeType.getLongEvenOnOracle(sumStr);
        long sum2 = BasicStatsDatasetProbeType.getLongEvenOnOracle(sum2Str);
        long cnt = BasicStatsDatasetProbeType.getLongEvenOnOracle(cntStr);
        if ((double)cnt < 1.0000000001) {
            return null;
        }
        return Math.sqrt(Math.max(0L, (sum2 - sum * sum / (cnt - 1L)) / (cnt - 1L)));
    }

    private static String getDateMean(String lowerStr, String upperStr, String countStr) {
        if (StringUtils.isBlank((String)lowerStr) || StringUtils.isBlank((String)upperStr) || StringUtils.isBlank((String)countStr)) {
            return null;
        }
        long lower = BasicStatsDatasetProbeType.getLongEvenOnOracle(lowerStr);
        long upper = BasicStatsDatasetProbeType.getLongEvenOnOracle(upperStr);
        long count = BasicStatsDatasetProbeType.getLongEvenOnOracle(countStr);
        double mean = (double)upper / (double)count * 8.64E7 + (double)lower / (double)count;
        return DKUDateUtils.isoFormatUTC((long)((long)mean));
    }

    private static String getDatetimeNoTzMean(String lowerStr, String upperStr, String countStr) {
        if (StringUtils.isBlank((String)lowerStr) || StringUtils.isBlank((String)upperStr) || StringUtils.isBlank((String)countStr)) {
            return null;
        }
        long lower = BasicStatsDatasetProbeType.getLongEvenOnOracle(lowerStr);
        long upper = BasicStatsDatasetProbeType.getLongEvenOnOracle(upperStr);
        long count = BasicStatsDatasetProbeType.getLongEvenOnOracle(countStr);
        double mean = (double)upper / (double)count * 8.64E7 + (double)lower / (double)count;
        return DatetimeNoTz.CANONICAL_FORMATTER.print((long)mean);
    }

    private static String getTemporalStddev(String lowerLowerStr, String upperUpperStr, String lowerUpperStr, String countStr) {
        if (StringUtils.isBlank((String)lowerLowerStr) || StringUtils.isBlank((String)upperUpperStr) || StringUtils.isBlank((String)lowerUpperStr) || StringUtils.isBlank((String)countStr)) {
            return null;
        }
        double lowerLower = Double.parseDouble(lowerLowerStr);
        double upperUpper = Double.parseDouble(upperUpperStr);
        double lowerUpper = Double.parseDouble(lowerUpperStr);
        double count = Double.parseDouble(countStr);
        if (Math.abs(count) < 1.0000000001) {
            return null;
        }
        double slice = 8.64E7;
        double res = slice * Math.sqrt(Math.max(0.0, upperUpper / (count - 1.0))) * Math.sqrt(Math.max(0.0, 1.0 + (2.0 * slice * lowerUpper + lowerLower) / (slice * slice * upperUpper)));
        return Double.toString(res);
    }

    public static class BasicStatsDSSGrouperComputer
    extends DSSMetricsEngine.DSSMetricsEngineComputer {
        @Override
        public String getProbeType() {
            return BasicStatsDatasetProbeType.TYPE;
        }

        @Override
        public MetricsEngineRun handles(AuthCtx authCtx, Probe probe, Metric metric, Object object, MetricTargetType objectType, Partition partition) {
            BasicStatsDatasetMetrics aggregated = ((BasicStatsDatasetMetric)metric).getMetricType();
            if (aggregated == BasicStatsDatasetMetrics.HISTOGRAM) {
                return null;
            }
            return new DSSMetricsEngine.DSSMetricsEngineRun().with(new MetricComputation(probe, this, metric, 10.0));
        }

        @Override
        public boolean canComputeWith(List<MetricComputation> handledComputations, List<MetricComputation> otherComputations) {
            return otherComputations.stream().allMatch(computation -> computation.computer instanceof BasicStatsDSSGrouperComputer);
        }

        public List<GroupingRecipePayloadParams.GroupingValue> getGroupingValues(DSSMetricsEngine.DSSMetricsEngineCallbacks engine, List<MetricComputation> computations) {
            HashMap<String, GroupingRecipePayloadParams.GroupingValue> groupingValuePerColumn = new HashMap<String, GroupingRecipePayloadParams.GroupingValue>();
            block10: for (Metric metric : computations.stream().map(computation -> computation.metric).collect(Collectors.toList())) {
                groupingValuePerColumn.computeIfAbsent(metric.getColumn(), c2 -> {
                    GroupingRecipePayloadParams.GroupingValue groupingValue = new GroupingRecipePayloadParams.GroupingValue((String)c2, false, false, false, false, false, false, false, false, null);
                    groupingValue.setType(engine.getColumnByName().get(metric.getColumn()).getType());
                    return groupingValue;
                });
                BasicStatsDatasetMetric basicStatsDatasetMetric = (BasicStatsDatasetMetric)metric;
                GroupingRecipePayloadParams.GroupingValue groupingValue = (GroupingRecipePayloadParams.GroupingValue)groupingValuePerColumn.get(metric.getColumn());
                switch (basicStatsDatasetMetric.getMetricType()) {
                    case MIN: {
                        groupingValue.min = true;
                        continue block10;
                    }
                    case MAX: {
                        groupingValue.max = true;
                        continue block10;
                    }
                    case STDDEV: {
                        groupingValue.stddev = true;
                        continue block10;
                    }
                    case MEAN: {
                        groupingValue.avg = true;
                        continue block10;
                    }
                    case SUM: {
                        groupingValue.sum = true;
                        continue block10;
                    }
                    case COUNT: 
                    case COUNT_NULL: {
                        groupingValue.count = true;
                        continue block10;
                    }
                    case COUNT_DISTINCT: {
                        groupingValue.countDistinct = true;
                        continue block10;
                    }
                    case COUNT_UNIQUE: {
                        groupingValue.countUnique = true;
                        continue block10;
                    }
                }
                throw new IllegalStateException(String.format("BasicStatsDatasetProbeType cannot handle %s metric type", new Object[]{basicStatsDatasetMetric.getMetricType()}));
            }
            return new ArrayList<GroupingRecipePayloadParams.GroupingValue>(groupingValuePerColumn.values());
        }

        public String getAggregate(Row row, ColumnFactory cf, MetricComputation computation, Map<String, SchemaColumn> aggregateColumns) {
            long globalCount = Long.parseLong(row.get(cf.column("dku_group_count")));
            if (aggregateColumns.isEmpty()) {
                return null;
            }
            String value = row.get(cf.column(aggregateColumns.get(this.getAggregateColumnName((BasicStatsDatasetMetric)computation.metric)).getName()));
            if (((BasicStatsDatasetMetric)computation.metric).getMetricType() == BasicStatsDatasetMetrics.COUNT_NULL) {
                if (StringUtils.isNotBlank((String)value)) {
                    return Long.toString(globalCount - Long.parseLong(value));
                }
                return null;
            }
            return value;
        }

        private String getAggregateColumnName(BasicStatsDatasetMetric metric) {
            switch (metric.getMetricType()) {
                case MEAN: {
                    return metric.getColumn() + "_avg";
                }
                case COUNT_NULL: {
                    return metric.getColumn() + "_count";
                }
                case COUNT_DISTINCT: {
                    return metric.getColumn() + "_distinct";
                }
                case COUNT_UNIQUE: {
                    return metric.getColumn() + "_unique";
                }
            }
            return metric.getColumn() + "_" + metric.getMetricType().toString().toLowerCase();
        }

        @Override
        public DSSMetricsEngine.DSSMetricsEngineComputer.DSSComputerSession start(DSSMetricsEngine.DSSMetricsEngineCallbacks engine, List<MetricComputation> computations, Map<String, String> alreadyComputed) throws Exception {
            BasicStatsDSSGrouperComputerSession session = new BasicStatsDSSGrouperComputerSession();
            session.tempDirectory = DSSTempUtils.getTempFolder((String)"dss-engine-metrics", (String)"basic-stats-", (boolean)true);
            session.inputSchema = engine.getDataset().getSchema();
            session.modes = this.getGroupingValues(engine, computations);
            session.grouper = new Grouper2(new ArrayList<GroupingRecipePayloadParams.GroupingKey>(), session.modes, "dku_group_count", (File)session.tempDirectory, new Sorter.MergeSortParams(), null);
            session.grouper.startAccumulating((ColumnFactory)engine.getColumnFactory(), session.inputSchema);
            session.computations = computations;
            computations.forEach(computation -> {
                computation.session = session;
            });
            return session;
        }

        @Override
        public void cleanup(DSSMetricsEngine.DSSMetricsEngineComputer.DSSComputerSession dssComputerSession) throws Exception {
            BasicStatsDSSGrouperComputerSession session = (BasicStatsDSSGrouperComputerSession)dssComputerSession;
            if (session.grouper != null) {
                session.grouper.close();
            }
        }

        @Override
        public boolean accumulate(Row row, DSSMetricsEngine.DSSMetricsEngineComputer.DSSComputerSession session) throws Exception {
            ((BasicStatsDSSGrouperComputerSession)session).grouper.accumulate(row);
            return true;
        }

        @Override
        public Map<Metric, String> getAggregates(DSSMetricsEngine.DSSMetricsEngineComputer.DSSComputerSession dssComputerSession) throws Exception {
            BasicStatsDSSGrouperComputerSession session = (BasicStatsDSSGrouperComputerSession)dssComputerSession;
            session.grouper.finishAccumulating();
            StreamColumnFactory outputCf = new StreamColumnFactory();
            final ArrayList emitted = Lists.newArrayList();
            StreamRowFactory outputRf = new StreamRowFactory();
            SinkProcessorOutput out = new SinkProcessorOutput(){

                public void emitRow(Row row) {
                    emitted.add(row);
                }
            };
            session.grouper.startAggregating((ColumnFactory)outputCf, session.inputSchema);
            session.grouper.aggregate((ProcessorOutput)out, (ColumnFactory)outputCf, (RowFactory)outputRf);
            session.grouper.finishAggregating();
            session.grouper.close();
            HashMap<Metric, String> aggregates = new HashMap<Metric, String>();
            if (!emitted.isEmpty()) {
                Map aggregateColumns = session.modes.stream().map(groupingValue -> groupingValue.getDerivedColumns(new GroupingRecipePayloadParams(), groupingValue.getType(), new SchemaUtils.SafeColumnIdentifierSuffixer(null, session.inputSchema))).flatMap(Collection::stream).collect(Collectors.toMap(SchemaColumn::getName, Function.identity()));
                Row aggRow = (Row)emitted.get(0);
                session.computations.forEach(arg_0 -> this.lambda$getAggregates$5(aggregates, aggRow, (ColumnFactory)outputCf, aggregateColumns, arg_0));
            } else {
                session.computations.forEach(computation -> aggregates.put(computation.metric, null));
            }
            session.tempDirectory.close();
            session.tempDirectory = null;
            return aggregates;
        }

        @Override
        public JsonObject writeJson(JsonSerializationContext ctx) {
            return new JsonObject();
        }

        @Override
        public void readJson(JsonObject jsonObj, JsonDeserializationContext ctx) {
        }

        private /* synthetic */ void lambda$getAggregates$5(Map aggregates, Row aggRow, ColumnFactory outputCf, Map aggregateColumns, MetricComputation computation) {
            aggregates.put(computation.metric, this.getAggregate(aggRow, outputCf, computation, aggregateColumns));
        }

        public static class BasicStatsDSSGrouperComputerSession
        implements DSSMetricsEngine.DSSMetricsEngineComputer.DSSComputerSession {
            public List<MetricComputation> computations;
            private AutoDelete tempDirectory;
            private Grouper2 grouper;
            private List<GroupingRecipePayloadParams.GroupingValue> modes;
            private Schema inputSchema;
        }
    }

    public static class BasicStatsDSSHistogramComputer
    extends DSSMetricsEngine.DSSMetricsEngineComputer {
        @Override
        public String getProbeType() {
            return BasicStatsDatasetProbeType.TYPE;
        }

        @Override
        public MetricsEngineRun handles(AuthCtx authCtx, Probe probe, Metric metric, Object object, MetricTargetType objectType, Partition partition) {
            if (((BasicStatsDatasetMetric)metric).getMetricType() == BasicStatsDatasetMetrics.HISTOGRAM) {
                return new DSSMetricsEngine.DSSMetricsEngineRun(10.0, Lists.newArrayList((Object[])new MetricComputation[]{new MetricComputation(probe, this, metric, 10.0)}), 2);
            }
            return null;
        }

        @Override
        public DSSMetricsEngine.DSSMetricsEngineComputer.DSSComputerSession start(DSSMetricsEngine.DSSMetricsEngineCallbacks engine, List<MetricComputation> computations, Map<String, String> alreadyComputed) throws Exception {
            Validate.isTrue((computations.size() == 1 ? 1 : 0) != 0, (String)"BasicStatsDSSHistogramComputer can only compute one histogram", (Object[])new Object[0]);
            MetricComputation computation = computations.get(0);
            BasicStatsDatasetMetric metric = (BasicStatsDatasetMetric)computation.metric;
            BasicStatsDSSHistogramComputerSession session = new BasicStatsDSSHistogramComputerSession();
            Dataset dataset = engine.getDataset();
            SchemaColumn schemaColumn = dataset.getSchema().getColumn(metric.getColumn());
            String minValue = alreadyComputed.get(new BasicStatsDatasetMetric(BasicStatsDatasetMetrics.MIN, metric.getColumn(), schemaColumn.getType()).getId());
            String maxValue = alreadyComputed.get(new BasicStatsDatasetMetric(BasicStatsDatasetMetrics.MAX, metric.getColumn(), schemaColumn.getType()).getId());
            session.computation = computation;
            session.histogramSession = new BuildHistogramSession(metric.getColumn(), schemaColumn.getType(), minValue, maxValue);
            session.column = engine.getColumnFactory().column(metric.getColumn());
            session.bins = new long[session.histogramSession.singleBin ? 1 : 30];
            computation.session = session;
            return session;
        }

        @Override
        public void cleanup(DSSMetricsEngine.DSSMetricsEngineComputer.DSSComputerSession dssComputerSession) throws Exception {
        }

        @Override
        public boolean accumulate(Row row, DSSMetricsEngine.DSSMetricsEngineComputer.DSSComputerSession dssComputerSession) throws Exception {
            BasicStatsDSSHistogramComputerSession session = (BasicStatsDSSHistogramComputerSession)dssComputerSession;
            String value = row.get(session.column);
            if (session.histogramSession.active && StringUtils.isNotBlank((String)value)) {
                try {
                    int n = session.bins.length;
                    int bin = session.histogramSession.getBinOf(value, n);
                    int n2 = bin = Math.max(0, Math.min(n - 1, bin));
                    session.bins[n2] = session.bins[n2] + 1L;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return true;
        }

        @Override
        public Map<Metric, String> getAggregates(DSSMetricsEngine.DSSMetricsEngineComputer.DSSComputerSession dssComputerSession) {
            BasicStatsDSSHistogramComputerSession session = (BasicStatsDSSHistogramComputerSession)dssComputerSession;
            HashMap<Metric, String> aggregates = new HashMap<Metric, String>();
            if (session.histogramSession.active) {
                ArrayList binCounts = Lists.newArrayList();
                for (long n : session.bins) {
                    binCounts.add(String.valueOf(n));
                }
                aggregates.put(session.computation.metric, session.histogramSession.buildHistogramJson(binCounts));
            }
            return aggregates;
        }

        @Override
        public JsonObject writeJson(JsonSerializationContext ctx) {
            return new JsonObject();
        }

        @Override
        public void readJson(JsonObject jsonObj, JsonDeserializationContext ctx) {
        }

        public static class BasicStatsDSSHistogramComputerSession
        implements DSSMetricsEngine.DSSMetricsEngineComputer.DSSComputerSession {
            public MetricComputation computation;
            private BuildHistogramSession histogramSession;
            private long[] bins;
            private Column column;
        }
    }

    public static class BasicStatsSQLMetricsEngineComputer
    extends MetricComputer.SQLMetricsEngineComputer {
        private final BasicStatsMetricsEngineComputer subComputer;
        private final Set<String> datasetTypesWithoutMssToEpoch = Sets.newHashSet();

        public BasicStatsSQLMetricsEngineComputer(BasicStatsMetricsEngineComputer subComputer) {
            this.subComputer = subComputer;
            this.datasetTypesWithoutMssToEpoch.add(BuiltinSQLDatasets.SAPHANA_META.getType());
        }

        @Override
        public String getProbeType() {
            return BasicStatsDatasetProbeType.TYPE;
        }

        @Override
        public MetricsEngineRun handles(AuthCtx authCtx, Probe probe, Metric metric, Object object, MetricTargetType objectType, Partition partition) {
            if (objectType == MetricTargetType.DATASET && DatasetInspector.isSQLAble(authCtx, (Dataset)object)) {
                Dataset dataset = (Dataset)object;
                BasicStatsDatasetMetrics aggregated = ((BasicStatsDatasetMetric)metric).getMetricType();
                if (aggregated == BasicStatsDatasetMetrics.MEAN || aggregated == BasicStatsDatasetMetrics.STDDEV) {
                    SchemaColumn schemaColumn = dataset.getSchema().getColumn(metric.getColumn());
                    if (schemaColumn.getType().isTemporal()) {
                        if (this.datasetTypesWithoutMssToEpoch.contains(dataset.getType())) {
                            return null;
                        }
                        if (aggregated == BasicStatsDatasetMetrics.STDDEV) {
                            return new SQLMetricsEngine.SQLMetricsEngineRun(1.0, Lists.newArrayList((Object[])new MetricComputation[]{new MetricComputation(probe, this, metric, 1.0)}), 2);
                        }
                        return new SQLMetricsEngine.SQLMetricsEngineRun(1.0, Lists.newArrayList((Object[])new MetricComputation[]{new MetricComputation(probe, this, metric, 1.0)}), 1);
                    }
                    return new SQLMetricsEngine.SQLMetricsEngineRun(1.0, Lists.newArrayList((Object[])new MetricComputation[]{new MetricComputation(probe, this, metric, 1.0)}), 1);
                }
                if (aggregated == BasicStatsDatasetMetrics.HISTOGRAM) {
                    return new SQLMetricsEngine.SQLMetricsEngineRun(1.0, Lists.newArrayList((Object[])new MetricComputation[]{new MetricComputation(probe, this, metric, 1.0)}), 2);
                }
                return new SQLMetricsEngine.SQLMetricsEngineRun().with(new MetricComputation(probe, this, metric, 1.0));
            }
            return null;
        }

        @Override
        public void addAggregations(AuthCtx authCtx, MetricsQueryBuilder.MetricsQueryBuilderEngine engine, MetricComputation computation, SQLDialect dialect, SelectQueryBuilder queryBuilder, Map<String, String> alreadyComputed) throws Exception {
            this.subComputer.addAggregations(engine.getDataset(), computation, dialect, queryBuilder, alreadyComputed);
        }

        @Override
        public boolean addPreAggregations(AuthCtx authCtx, MetricsQueryBuilder.MetricsQueryBuilderEngine engine, MetricComputation computation, SQLDialect dialect, SelectQueryBuilder queryBuilder, Map<String, String> alreadyComputed) {
            return this.subComputer.addPreAggregations(computation, dialect, queryBuilder);
        }

        @Override
        public String getAggregate(QueryRunResult rs2, MetricComputation computation) throws Exception {
            return this.subComputer.getAggregate(rs2, computation);
        }
    }

    public static class BasicStatsMetricsEngineComputer {
        private final boolean boolToInt;

        public BasicStatsMetricsEngineComputer(boolean boolToInt) {
            this.boolToInt = boolToInt;
        }

        public List<ExpressionBuilder> getAggregations(BasicStatsDatasetMetrics aggregated, SchemaColumn column, boolean isDatasetManaged, DatasetHandler.DatasetParams datasetParams, SQLDialect dialect, ExpressionBuilder.ExpressionBuilderFactory ef, BuildHistogramSession histogramSession, Long temporalMean) {
            Type columnType = column.getType();
            ExpressionBuilder col = this.boolToInt && columnType == Type.BOOLEAN ? (aggregated == BasicStatsDatasetMetrics.MIN || aggregated == BasicStatsDatasetMetrics.MAX ? ef.col(column.getName()).castToInt() : ef.col(column.getName())) : ExpressionUtils.getAdjustedColumn(ef.col(column.getName()), column, datasetParams, isDatasetManaged, dialect);
            switch (aggregated) {
                case MIN: {
                    return Lists.newArrayList((Object[])new ExpressionBuilder[]{col.min()});
                }
                case MAX: {
                    return Lists.newArrayList((Object[])new ExpressionBuilder[]{col.max()});
                }
                case MEAN: {
                    if (column.getType() == Type.DATE) {
                        return Lists.newArrayList((Object[])new ExpressionBuilder[]{col.mssToEpoch().mod(86400000).sum().castToBigint(), col.mssToEpoch().quotient(86400000).sum().castToBigint(), col.count().castToBigint()});
                    }
                    if (column.getType() == Type.DATEONLY) {
                        return Lists.newArrayList((Object[])new ExpressionBuilder[]{col.mssToDateOnlyEpoch().mod(86400000).sum().castToBigint(), col.mssToDateOnlyEpoch().quotient(86400000).sum().castToBigint(), col.count().castToBigint()});
                    }
                    if (column.getType() == Type.DATETIMENOTZ) {
                        return Lists.newArrayList((Object[])new ExpressionBuilder[]{col.mssToDatetimeNoTzEpoch().mod(86400000).sum().castToBigint(), col.mssToDatetimeNoTzEpoch().quotient(86400000).sum().castToBigint(), col.count().castToBigint()});
                    }
                    return Lists.newArrayList((Object[])new ExpressionBuilder[]{col.castForAggregateIfNeeded(dialect, columnType).avg()});
                }
                case SUM: {
                    if (column.getType().isInteger()) {
                        return Lists.newArrayList((Object[])new ExpressionBuilder[]{col.castForAggregateIfNeeded(dialect, columnType).sum().castToBigint()});
                    }
                    return Lists.newArrayList((Object[])new ExpressionBuilder[]{col.sum()});
                }
                case COUNT: {
                    return Lists.newArrayList((Object[])new ExpressionBuilder[]{col.count().castToBigint()});
                }
                case COUNT_DISTINCT: {
                    return Lists.newArrayList((Object[])new ExpressionBuilder[]{col.countDistinct().castToBigint()});
                }
                case COUNT_UNIQUE: {
                    ExpressionBuilder isUniqueValue = ef.col(this.getUniqueSubQueryColumnName(column.getName())).eq(1).and(ef.col(column.getName()).isnotnull());
                    return Lists.newArrayList((Object[])new ExpressionBuilder[]{ef.caseWhen(isUniqueValue, 1, null).count().castToBigint()});
                }
                case STDDEV: {
                    if (column.getType().isTemporal()) {
                        if (temporalMean != null) {
                            ExpressionBuilder delta = column.getType() == Type.DATE ? col.mssToEpoch().minus(temporalMean) : (column.getType() == Type.DATEONLY ? col.mssToDateOnlyEpoch().minus(temporalMean) : col.mssToDatetimeNoTzEpoch().minus(temporalMean));
                            ExpressionBuilder div = delta.div(86400000).floor();
                            ExpressionBuilder rem = delta.minus(div.time(ef.cst(86400000)));
                            ExpressionBuilder lowerLowerHalfSum = rem.time(rem).sum();
                            ExpressionBuilder upperUpperHalfSum = div.time(div).sum();
                            ExpressionBuilder lowerUpperHalfSum = div.time(rem).sum();
                            ExpressionBuilder count = col.count();
                            return Lists.newArrayList((Object[])new ExpressionBuilder[]{lowerLowerHalfSum, upperUpperHalfSum, lowerUpperHalfSum, count});
                        }
                        return Lists.newArrayList();
                    }
                    if (column.getType().isFloatingPoint()) {
                        col = col.castToFloat();
                    }
                    return Lists.newArrayList((Object[])new ExpressionBuilder[]{col.stdDevSamp()});
                }
                case COUNT_NULL: {
                    return Lists.newArrayList((Object[])new ExpressionBuilder[]{ef.count("*").minus(col.count()).castToBigint()});
                }
                case HISTOGRAM: {
                    ExpressionBuilder binnedCol = col;
                    if (dialect instanceof TeradataSQLDialect && histogramSession.type == Type.DATEONLY) {
                        binnedCol = col.cast(Type.DATETIMENOTZ);
                    }
                    ArrayList bins = Lists.newArrayList();
                    if (histogramSession.active) {
                        int n = histogramSession.singleBin ? 1 : 30;
                        for (int i = 0; i < n; ++i) {
                            Object binMin = histogramSession.getBinEdge(i, n);
                            Object binMax = histogramSession.getBinEdge(i + 1, n);
                            ExpressionBuilder cond = i == 0 ? binnedCol.lt(ef.cst(binMax)) : (i == n - 1 ? binnedCol.gte(ef.cst(binMin)) : binnedCol.lt(ef.cst(binMax)).and(binnedCol.gte(ef.cst(binMin))));
                            bins.add(ef.caseWhen(cond, ef.cst(1), ef.cst(0)).sum().castToBigint());
                        }
                    }
                    return bins;
                }
            }
            return Lists.newArrayList();
        }

        private String getUniqueSubQueryColumnName(String columnName) {
            return "dku__count_unique_" + columnName;
        }

        public boolean addPreAggregations(MetricComputation computation, SQLDialect dialect, SelectQueryBuilder queryBuilder) {
            BasicStatsDatasetMetric metric = (BasicStatsDatasetMetric)computation.metric;
            ExpressionBuilder.ExpressionBuilderFactory ebf = new ExpressionBuilder.ExpressionBuilderFactory();
            String columnName = metric.getColumn();
            if (metric.getMetricType() != BasicStatsDatasetMetrics.COUNT_UNIQUE) {
                return false;
            }
            ExpressionBuilder partitioningColumn = ebf.col(columnName);
            if (dialect instanceof BigQuerySQLDialect) {
                partitioningColumn = partitioningColumn.castToString(dialect.getDefaultVarcharLen());
            }
            QueryAst.Window window = SelectQueryBuilder.window(Lists.newArrayList((Object[])new ExpressionBuilder[]{partitioningColumn}), Lists.newArrayList(), Lists.newArrayList());
            queryBuilder.select(ebf.count("*").over(window), this.getUniqueSubQueryColumnName(columnName));
            return true;
        }

        public void addAggregations(Dataset dataset, MetricComputation computation, SQLDialect dialect, SelectQueryBuilder queryBuilder, Map<String, String> alreadyComputed) {
            BasicStatsComputerSession session = new BasicStatsComputerSession();
            computation.session = session;
            session.dialect = dialect;
            BasicStatsDatasetMetric metric = (BasicStatsDatasetMetric)computation.metric;
            session.aggregated = metric.getMetricType();
            String columnName = metric.getColumn();
            SchemaColumn column = dataset.getSchema().getColumn(columnName);
            session.type = column.getType();
            session.sameType = session.aggregated == BasicStatsDatasetMetrics.MIN || session.aggregated == BasicStatsDatasetMetrics.MAX;
            session.expectDouble = session.aggregated == BasicStatsDatasetMetrics.MEAN || session.aggregated == BasicStatsDatasetMetrics.STDDEV || session.aggregated == BasicStatsDatasetMetrics.SUM && column.getType().isFloatingPoint();
            boolean bl = session.expectLong = session.aggregated == BasicStatsDatasetMetrics.HISTOGRAM || session.aggregated == BasicStatsDatasetMetrics.COUNT || session.aggregated == BasicStatsDatasetMetrics.COUNT_NULL || session.aggregated == BasicStatsDatasetMetrics.COUNT_DISTINCT || session.aggregated == BasicStatsDatasetMetrics.COUNT_UNIQUE || session.aggregated == BasicStatsDatasetMetrics.SUM && !column.getType().isFloatingPoint();
            if (metric.getMetricType() == BasicStatsDatasetMetrics.HISTOGRAM) {
                String minValue = alreadyComputed.get(new BasicStatsDatasetMetric(BasicStatsDatasetMetrics.MIN, column.getName(), column.getType()).getId());
                String maxValue = alreadyComputed.get(new BasicStatsDatasetMetric(BasicStatsDatasetMetrics.MAX, column.getName(), column.getType()).getId());
                session.histogramSession = new BuildHistogramSession(metric.getColumn(), column.getType(), minValue, maxValue);
            } else if (metric.getMetricType() == BasicStatsDatasetMetrics.STDDEV && column.getType() == Type.DATE) {
                meanValue = alreadyComputed.get(new BasicStatsDatasetMetric(BasicStatsDatasetMetrics.MEAN, column.getName(), column.getType()).getId());
                session.temporalMean = StringUtils.isBlank((String)meanValue) ? null : Long.valueOf(dateMeaning.longValue(meanValue));
            } else if (metric.getMetricType() == BasicStatsDatasetMetrics.STDDEV && column.getType() == Type.DATEONLY) {
                meanValue = alreadyComputed.get(new BasicStatsDatasetMetric(BasicStatsDatasetMetrics.MEAN, column.getName(), column.getType()).getId());
                session.temporalMean = StringUtils.isBlank((String)meanValue) ? null : Long.valueOf(datetimeNoTzMeaning.longValue(meanValue));
            } else if (metric.getMetricType() == BasicStatsDatasetMetrics.STDDEV && column.getType() == Type.DATETIMENOTZ) {
                meanValue = alreadyComputed.get(new BasicStatsDatasetMetric(BasicStatsDatasetMetrics.MEAN, column.getName(), column.getType()).getId());
                session.temporalMean = StringUtils.isBlank((String)meanValue) ? null : Long.valueOf(datetimeNoTzMeaning.longValue(meanValue));
            }
            ExpressionBuilder.ExpressionBuilderFactory ef = new ExpressionBuilder.ExpressionBuilderFactory();
            int aggCount = 0;
            for (ExpressionBuilder expr : this.getAggregations(metric.getMetricType(), column, dataset.isManaged(), dataset.getParams(), dialect, ef, session.histogramSession, session.temporalMean)) {
                SelectQueryBuilder.SelectRefBuilder ref = queryBuilder.select(expr, metric.getMetricType().name() + "_" + columnName + "_" + aggCount++);
                session.offsets.add(ref.getIndex());
            }
        }

        public String getAggregate(BasicStatsComputerSession session, QueryRunResult rs2, List<Integer> offsets, BasicStatsDatasetMetrics aggregated, Metric metric) {
            if (session.aggregated == BasicStatsDatasetMetrics.HISTOGRAM) {
                if (session.histogramSession.active) {
                    ArrayList binCounts = Lists.newArrayList();
                    for (int offset : offsets) {
                        binCounts.add(rs2.rows.get(0)[offset - 1]);
                    }
                    return session.histogramSession.buildHistogramJson(binCounts);
                }
                return null;
            }
            if (session.aggregated == BasicStatsDatasetMetrics.MEAN && session.type == Type.DATE) {
                String l = rs2.rows.get(0)[offsets.get(0) - 1];
                String u = rs2.rows.get(0)[offsets.get(1) - 1];
                String c2 = rs2.rows.get(0)[offsets.get(2) - 1];
                return BasicStatsDatasetProbeType.getDateMean(l, u, c2);
            }
            if (session.aggregated == BasicStatsDatasetMetrics.MEAN && (session.type == Type.DATETIMENOTZ || session.type == Type.DATEONLY)) {
                String l = rs2.rows.get(0)[offsets.get(0) - 1];
                String u = rs2.rows.get(0)[offsets.get(1) - 1];
                String c3 = rs2.rows.get(0)[offsets.get(2) - 1];
                return BasicStatsDatasetProbeType.getDatetimeNoTzMean(l, u, c3);
            }
            if (session.aggregated == BasicStatsDatasetMetrics.STDDEV && session.type.isTemporal()) {
                if (session.temporalMean == null) {
                    return null;
                }
                String ll = rs2.rows.get(0)[offsets.get(0) - 1];
                String uu = rs2.rows.get(0)[offsets.get(1) - 1];
                String ul = rs2.rows.get(0)[offsets.get(2) - 1];
                String c4 = rs2.rows.get(0)[offsets.get(3) - 1];
                return BasicStatsDatasetProbeType.getTemporalStddev(ll, uu, ul, c4);
            }
            Type dssType = session.sameType ? session.type : (session.expectDouble ? Type.DOUBLE : (session.expectLong ? Type.BIGINT : Type.STRING));
            int offset = offsets.get(0);
            String v = rs2.rows.get(0)[offset - 1];
            try {
                if (dssType == Type.DATE) {
                    v = DKUtils.isoFormatReadableByDateFormat((long)CSVDeserializer.hiveDateParser.parseDateTime(v).getMillis());
                }
            }
            catch (Exception e) {
                logger.error((Object)"Failure while trying to harmonize hive date to ISO format");
            }
            return v;
        }

        public String getAggregate(QueryRunResult rs2, MetricComputation computation) {
            BasicStatsComputerSession session = (BasicStatsComputerSession)computation.session;
            return this.getAggregate(session, rs2, session.offsets, session.aggregated, computation.metric);
        }

        public static class BasicStatsComputerSession {
            public BasicStatsDatasetMetrics aggregated;
            public Type type;
            public SQLDialect dialect;
            public List<Integer> offsets = Lists.newArrayList();
            public boolean expectDouble;
            public boolean expectLong;
            public boolean sameType;
            public BuildHistogramSession histogramSession;
            public Long temporalMean;
        }
    }

    public static class BasicStatsImpalaMetricsEngineComputer
    extends MetricComputer.ImpalaMetricsEngineComputer {
        private final BasicStatsMetricsEngineComputer subComputer;

        public BasicStatsImpalaMetricsEngineComputer(BasicStatsMetricsEngineComputer subComputer) {
            this.subComputer = subComputer;
        }

        @Override
        public String getProbeType() {
            return BasicStatsDatasetProbeType.TYPE;
        }

        @Override
        public MetricsEngineRun handles(AuthCtx authCtx, Probe probe, Metric metric, Object object, MetricTargetType objectType, Partition partition) {
            if (objectType == MetricTargetType.DATASET && DatasetInspector.isHDFSDatasetOrHiveTableDataset((Dataset)object)) {
                BasicStatsDatasetMetric basicMetric = (BasicStatsDatasetMetric)metric;
                BasicStatsDatasetMetrics aggregated = ((BasicStatsDatasetMetric)metric).getMetricType();
                SchemaColumn schemaColumn = ((Dataset)object).getSchema().getColumn(metric.getColumn());
                if (!schemaColumn.getType().isPrimitive()) {
                    return null;
                }
                if (aggregated == BasicStatsDatasetMetrics.COUNT_DISTINCT) {
                    return new ImpalaMetricsEngine.ImpalaMetricsEngineRun(basicMetric.getColumn()).with(new MetricComputation(probe, this, metric, 1.0));
                }
                if (aggregated == BasicStatsDatasetMetrics.HISTOGRAM) {
                    return new ImpalaMetricsEngine.ImpalaMetricsEngineRun(null, 1.0, (List<MetricComputation>)Lists.newArrayList((Object[])new MetricComputation[]{new MetricComputation(probe, this, metric, 1.0)}), 2);
                }
                if (aggregated == BasicStatsDatasetMetrics.STDDEV) {
                    if (schemaColumn.getType().isTemporal()) {
                        return new ImpalaMetricsEngine.ImpalaMetricsEngineRun(null, 1.0, (List<MetricComputation>)Lists.newArrayList((Object[])new MetricComputation[]{new MetricComputation(probe, this, metric, 1.0)}), 2);
                    }
                    return new ImpalaMetricsEngine.ImpalaMetricsEngineRun(null, 1.0, (List<MetricComputation>)Lists.newArrayList((Object[])new MetricComputation[]{new MetricComputation(probe, this, metric, 1.0)}), 1);
                }
                return new ImpalaMetricsEngine.ImpalaMetricsEngineRun(null).with(new MetricComputation(probe, this, metric, 1.0));
            }
            return null;
        }

        @Override
        public boolean addPreAggregations(AuthCtx authCtx, MetricsQueryBuilder.MetricsQueryBuilderEngine engine, MetricComputation computation, SQLDialect dialect, SelectQueryBuilder queryBuilder, Map<String, String> alreadyComputed) {
            return this.subComputer.addPreAggregations(computation, dialect, queryBuilder);
        }

        @Override
        public void addAggregations(AuthCtx authCtx, MetricsQueryBuilder.MetricsQueryBuilderEngine engine, MetricComputation computation, SQLDialect dialect, SelectQueryBuilder queryBuilder, Map<String, String> alreadyComputed) throws Exception {
            this.subComputer.addAggregations(engine.getDataset(), computation, dialect, queryBuilder, alreadyComputed);
        }

        @Override
        public String getAggregate(QueryRunResult rs2, MetricComputation computation) throws Exception {
            return this.subComputer.getAggregate(rs2, computation);
        }
    }

    public static class BasicStatsHiveMetricsEngineComputer
    extends MetricComputer.HiveMetricsEngineComputer {
        private BasicStatsMetricsEngineComputer subComputer;

        public BasicStatsHiveMetricsEngineComputer(BasicStatsMetricsEngineComputer subComputer) {
            this.subComputer = subComputer;
        }

        @Override
        public String getProbeType() {
            return BasicStatsDatasetProbeType.TYPE;
        }

        @Override
        public MetricsEngineRun handles(AuthCtx authCtx, Probe probe, Metric metric, Object object, MetricTargetType objectType, Partition partition) {
            if (objectType == MetricTargetType.DATASET && DatasetInspector.isHDFSDatasetOrHiveTableDataset((Dataset)object)) {
                BasicStatsDatasetMetrics aggregated = ((BasicStatsDatasetMetric)metric).getMetricType();
                if (aggregated == BasicStatsDatasetMetrics.HISTOGRAM) {
                    return new HiveMetricsEngine.HiveMetricsEngineRun(2.0, Lists.newArrayList((Object[])new MetricComputation[]{new MetricComputation(probe, this, metric, 2.0)}), 2);
                }
                if (aggregated == BasicStatsDatasetMetrics.STDDEV) {
                    SchemaColumn schemaColumn = ((Dataset)object).getSchema().getColumn(metric.getColumn());
                    if (schemaColumn.getType().isTemporal()) {
                        return new HiveMetricsEngine.HiveMetricsEngineRun(2.0, Lists.newArrayList((Object[])new MetricComputation[]{new MetricComputation(probe, this, metric, 2.0)}), 2);
                    }
                    return new HiveMetricsEngine.HiveMetricsEngineRun(2.0, Lists.newArrayList((Object[])new MetricComputation[]{new MetricComputation(probe, this, metric, 2.0)}), 1);
                }
                return new HiveMetricsEngine.HiveMetricsEngineRun().with(new MetricComputation(probe, this, metric, 2.0));
            }
            return null;
        }

        @Override
        public boolean addPreAggregations(AuthCtx authCtx, MetricsQueryBuilder.MetricsQueryBuilderEngine engine, MetricComputation computation, SQLDialect dialect, SelectQueryBuilder queryBuilder, Map<String, String> alreadyComputed) {
            return this.subComputer.addPreAggregations(computation, dialect, queryBuilder);
        }

        @Override
        public void addAggregations(AuthCtx authCtx, MetricsQueryBuilder.MetricsQueryBuilderEngine engine, MetricComputation computation, SQLDialect dialect, SelectQueryBuilder queryBuilder, Map<String, String> alreadyComputed) throws Exception {
            this.subComputer.addAggregations(engine.getDataset(), computation, dialect, queryBuilder, alreadyComputed);
        }

        @Override
        public String getAggregate(QueryRunResult rs2, MetricComputation computation) throws Exception {
            return this.subComputer.getAggregate(rs2, computation);
        }
    }

    public static class BasicStatsSparkMetricsEngineComputer
    extends MetricComputer.SparkMetricsEngineComputer {
        private BasicStatsMetricsEngineComputer subComputer;

        public BasicStatsSparkMetricsEngineComputer(BasicStatsMetricsEngineComputer subComputer) {
            this.subComputer = subComputer;
        }

        @Override
        public String getProbeType() {
            return BasicStatsDatasetProbeType.TYPE;
        }

        @Override
        public MetricsEngineRun handles(AuthCtx authCtx, Probe probe, Metric metric, Object object, MetricTargetType objectType, Partition partition) {
            if (objectType == MetricTargetType.DATASET) {
                BasicStatsDatasetMetrics aggregated = ((BasicStatsDatasetMetric)metric).getMetricType();
                if (aggregated == BasicStatsDatasetMetrics.HISTOGRAM) {
                    return new SparkMetricsEngine.SparkMetricsEngineRun(2.0, Lists.newArrayList((Object[])new MetricComputation[]{new MetricComputation(probe, this, metric, 3.0)}), 2);
                }
                if (aggregated == BasicStatsDatasetMetrics.STDDEV) {
                    SchemaColumn schemaColumn = ((Dataset)object).getSchema().getColumn(metric.getColumn());
                    if (schemaColumn.getType().isTemporal()) {
                        return new SparkMetricsEngine.SparkMetricsEngineRun(2.0, Lists.newArrayList((Object[])new MetricComputation[]{new MetricComputation(probe, this, metric, 3.0)}), 2);
                    }
                    return new SparkMetricsEngine.SparkMetricsEngineRun(2.0, Lists.newArrayList((Object[])new MetricComputation[]{new MetricComputation(probe, this, metric, 3.0)}), 1);
                }
                return new SparkMetricsEngine.SparkMetricsEngineRun().with(new MetricComputation(probe, this, metric, 3.0));
            }
            return null;
        }

        @Override
        public boolean addPreAggregations(AuthCtx authCtx, MetricsQueryBuilder.MetricsQueryBuilderEngine engine, MetricComputation computation, SQLDialect dialect, SelectQueryBuilder queryBuilder, Map<String, String> alreadyComputed) {
            return this.subComputer.addPreAggregations(computation, dialect, queryBuilder);
        }

        @Override
        public void addAggregations(AuthCtx authCtx, MetricsQueryBuilder.MetricsQueryBuilderEngine engine, MetricComputation computation, SQLDialect dialect, SelectQueryBuilder queryBuilder, Map<String, String> alreadyComputed) throws Exception {
            this.subComputer.addAggregations(engine.getDataset(), computation, dialect, queryBuilder, alreadyComputed);
        }

        @Override
        public String getAggregate(QueryRunResult rs2, MetricComputation computation) throws Exception {
            return this.subComputer.getAggregate(rs2, computation);
        }
    }

    public static enum BasicStatsDatasetMetrics {
        MIN,
        MEAN,
        MAX,
        SUM,
        COUNT,
        COUNT_NULL,
        STDDEV,
        COUNT_DISTINCT,
        COUNT_UNIQUE,
        HISTOGRAM;

    }

    public static class BasicStatsDatasetMetric
    extends Metric {
        public BasicStatsDatasetMetrics metricType;
        public String column;

        public BasicStatsDatasetMetric(BasicStatsDatasetMetrics metricType, String column, Type columnType) {
            super(BasicStatsDatasetProbeType.TYPE, BasicStatsDatasetMetric.getDataTypeFromMetricType(metricType, columnType));
            this.metricType = metricType;
            this.column = column;
            this.id = Metric.serializeMetric(this);
        }

        private static Type getDataTypeFromMetricType(BasicStatsDatasetMetrics metricType, Type columnType) {
            switch (metricType) {
                case MIN: 
                case MAX: {
                    return columnType;
                }
                case STDDEV: {
                    return Type.DOUBLE;
                }
                case MEAN: {
                    return columnType == Type.DATE || columnType == Type.DATEONLY ? Type.DATE : (columnType == Type.DATETIMENOTZ ? Type.DATETIMENOTZ : Type.DOUBLE);
                }
                case SUM: {
                    return columnType.isNumeric() ? (columnType.isFloatingPoint() ? Type.DOUBLE : Type.BIGINT) : Type.STRING;
                }
                case COUNT: 
                case COUNT_NULL: 
                case COUNT_DISTINCT: 
                case COUNT_UNIQUE: {
                    return Type.BIGINT;
                }
                case HISTOGRAM: {
                    return Type.ARRAY;
                }
            }
            return Type.STRING;
        }

        public BasicStatsDatasetMetrics getMetricType() {
            return this.metricType;
        }

        @Override
        public String getColumn() {
            return this.column;
        }

        @Override
        public MetricMetadata getMeta() {
            MetricMetadata meta = new MetricMetadata(metadataPerType.get((Object)this.metricType));
            meta.withFullName(meta.getName() + " of " + this.column);
            return meta;
        }

        @Override
        public String getColumnInvariantId(String placeholder) {
            return new BasicStatsDatasetMetric(this.metricType, placeholder, this.dataType).getId();
        }

        @Override
        public Probe getMatchingProbe(List<Probe> probes) {
            BasicStatsDatasetProbeConfiguration conf = new BasicStatsDatasetProbeConfiguration();
            BasicStatsDatasetProbeColumnConfiguration col = new BasicStatsDatasetProbeColumnConfiguration();
            col.column = this.column;
            col.aggregated = this.metricType;
            conf.aggregates.add(col);
            return new Probe(this.getType()).withConfiguration(conf).withMeta(ProbeType.getProbeType(BasicStatsDatasetProbeType.TYPE).getMeta());
        }
    }

    public static class BasicStatsDatasetProbeHint {
        public List<BasicStatsDatasetProbeColumnHint> columns = Lists.newArrayList();
    }

    public static class BasicStatsDatasetProbeColumnHint {
        public String column;
        public List<BasicStatsDatasetProbeMetricHint> metrics = Lists.newArrayList();

        BasicStatsDatasetProbeColumnHint(String column) {
            this.column = column;
        }
    }

    public static class BasicStatsDatasetProbeConfiguration
    implements ProbeConfiguration {
        public List<BasicStatsDatasetProbeColumnConfiguration> aggregates = Lists.newArrayList();

        public void filterOutExpensiveAggregations(boolean allowCountDistinct, boolean allowCountUnique) {
            this.aggregates = this.aggregates.stream().filter(agg -> !(!allowCountDistinct && agg.aggregated == BasicStatsDatasetMetrics.COUNT_DISTINCT || !allowCountUnique && agg.aggregated == BasicStatsDatasetMetrics.COUNT_UNIQUE)).collect(Collectors.toList());
        }
    }

    public static class BasicStatsDatasetProbeColumnConfiguration {
        public String column;
        public BasicStatsDatasetMetrics aggregated;
    }

    public static class BasicStatsDatasetProbeMetricHint {
        public String name;
        public boolean disabled;
        public boolean active;
        public BasicStatsDatasetMetrics aggregated;

        BasicStatsDatasetProbeMetricHint(String name, BasicStatsDatasetMetrics aggregated, boolean active, boolean disabled) {
            this.name = name;
            this.aggregated = aggregated;
            this.active = active;
            this.disabled = disabled;
        }
    }

    static class BuildHistogramSession {
        public boolean active;
        public double minNumeric;
        public double maxNumeric;
        public long minTemporal;
        public long maxTemporal;
        public String column;
        public Type type;
        private boolean singleBin;

        public BuildHistogramSession(String column, Type type, String minValue, String maxValue) {
            this.column = column;
            this.type = type;
            this.active = false;
            if (StringUtils.isBlank((String)minValue) || StringUtils.isBlank((String)maxValue)) {
                logger.info((Object)("Min/max not computed, cannot do histogram of " + column));
            } else if (type == Type.DATE) {
                try {
                    this.minTemporal = dateMeaning.msSinceEpoch(minValue);
                    this.maxTemporal = dateMeaning.msSinceEpoch(maxValue);
                    this.active = true;
                    this.singleBin = this.minTemporal == this.maxTemporal;
                }
                catch (Exception e) {
                    logger.info((Object)("Min/max computed but not valid datetime with tz, cannot do histogram of " + column), (Throwable)e);
                }
            } else if (type == Type.DATEONLY) {
                try {
                    this.minTemporal = dateOnlyMeaning.msSinceEpoch(minValue);
                    this.maxTemporal = dateOnlyMeaning.msSinceEpoch(maxValue);
                    this.active = true;
                    this.singleBin = this.minTemporal == this.maxTemporal;
                }
                catch (Exception e) {
                    logger.info((Object)("Min/max computed but not valid date only, cannot do histogram of " + column), (Throwable)e);
                }
            } else if (type == Type.DATETIMENOTZ) {
                try {
                    this.minTemporal = datetimeNoTzMeaning.msSinceEpoch(minValue);
                    this.maxTemporal = datetimeNoTzMeaning.msSinceEpoch(maxValue);
                    this.active = true;
                    this.singleBin = this.minTemporal == this.maxTemporal;
                }
                catch (Exception e) {
                    logger.info((Object)("Min/max computed but not valid datetime no tz, cannot do histogram of " + column), (Throwable)e);
                }
            } else if (type.isNumeric()) {
                try {
                    this.minNumeric = Double.parseDouble(minValue);
                    this.maxNumeric = Double.parseDouble(maxValue);
                    this.active = true;
                    this.singleBin = this.minNumeric == this.maxNumeric;
                }
                catch (Exception e) {
                    logger.info((Object)("Min/max computed but not numeric, cannot do histogram of " + column), (Throwable)e);
                }
            }
        }

        public double getNumericBinEdge(int i, int n) {
            if (this.singleBin) {
                return i == 0 ? this.minNumeric : this.maxNumeric;
            }
            return this.minNumeric + (this.maxNumeric - this.minNumeric) * (double)i / (double)n;
        }

        public long getRawTimestampBinEdge(int i, int n) {
            if (this.singleBin) {
                return i == 0 ? this.minTemporal : this.maxTemporal;
            }
            return this.minTemporal + (this.maxTemporal - this.minTemporal) * (long)i / (long)n;
        }

        public Object getBinEdge(int i, int n) {
            if (this.type == Type.DATE) {
                return new DateTime(this.getRawTimestampBinEdge(i, n), DateTimeZone.UTC);
            }
            if (this.type == Type.DATETIMENOTZ || this.type == Type.DATEONLY) {
                return new LocalDateTime(this.getRawTimestampBinEdge(i, n), DateTimeZone.UTC);
            }
            return this.getNumericBinEdge(i, n);
        }

        public int getBinOf(String value, int n) {
            if (this.singleBin) {
                return 0;
            }
            if (this.type == Type.DATE) {
                long ts = dateMeaning.msSinceEpoch(value);
                int i = (int)((ts - this.minTemporal) * (long)n / (this.maxTemporal - this.minTemporal));
                return Math.min(n - 1, Math.max(0, i));
            }
            if (this.type == Type.DATEONLY) {
                long ts = dateOnlyMeaning.msSinceEpoch(value);
                int i = (int)((ts - this.minTemporal) * (long)n / (this.maxTemporal - this.minTemporal));
                return Math.min(n - 1, Math.max(0, i));
            }
            if (this.type == Type.DATETIMENOTZ) {
                long ts = datetimeNoTzMeaning.msSinceEpoch(value);
                int i = (int)((ts - this.minTemporal) * (long)n / (this.maxTemporal - this.minTemporal));
                return Math.min(n - 1, Math.max(0, i));
            }
            double v = Double.parseDouble(value);
            int i = (int)Math.floor((v - this.minNumeric) * (double)n / (this.maxNumeric - this.minNumeric));
            return Math.min(n - 1, Math.max(0, i));
        }

        public String buildHistogramJson(List<String> binCounts) {
            String lower;
            ArrayList bins = Lists.newArrayList();
            int n = binCounts.size();
            for (int i = 0; i < n; ++i) {
                lower = this.type.isTemporal() ? String.valueOf(this.getRawTimestampBinEdge(i, n)) : String.valueOf(this.getNumericBinEdge(i, n));
                HashMap pair = Maps.newHashMap();
                pair.put(String.valueOf(lower), Long.parseLong(binCounts.get(i)));
                bins.add(pair);
            }
            HashMap pair = Maps.newHashMap();
            lower = this.type.isTemporal() ? String.valueOf(this.maxTemporal) : String.valueOf(this.maxNumeric);
            pair.put(lower, 0L);
            bins.add(pair);
            return JSON.json((Object)bins);
        }
    }

    public static class BasicStatsDatasetMetricSerializer
    implements Metric.MetricIdSerializer {
        @Override
        public String serializeMetric(Metric metric) {
            if (!(metric instanceof BasicStatsDatasetMetric)) {
                throw new CodedRuntimeException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_METRIC_IDENTIFIER, "Probe type " + this.getClass().getSimpleName() + " does not handle " + metric.getClass().getSimpleName());
            }
            BasicStatsDatasetMetric basicStatsDatasetMetric = (BasicStatsDatasetMetric)metric;
            return Metric.buildMetricIdFromParts(BasicStatsDatasetProbeType.TYPE, basicStatsDatasetMetric.getMetricType().name(), basicStatsDatasetMetric.getColumn());
        }

        @Override
        public Metric deserializeMetric(String metricId) {
            List<String> parts = Metric.buildPartsFromMetricId(metricId);
            if (parts.size() != 3 || !parts.get(0).equals(BasicStatsDatasetProbeType.TYPE)) {
                throw new CodedRuntimeException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_METRIC_IDENTIFIER, "Probe type " + this.getClass().getSimpleName() + " does not handle " + metricId);
            }
            return new BasicStatsDatasetMetric(BasicStatsDatasetMetrics.valueOf(parts.get(1)), parts.get(2), Type.STRING);
        }
    }
}

