/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.dss;

import com.dataiku.dip.io.ColumnBlock;
import com.dataiku.dip.io.LinoMetaFile;
import com.dataiku.dip.io.LinoReader;
import com.dataiku.dip.pivot.backend.dss.facets.AnumAxisFaceter;
import com.dataiku.dip.pivot.backend.dss.facets.AnumAxisFilter;
import com.dataiku.dip.pivot.backend.dss.facets.AxisFaceter;
import com.dataiku.dip.pivot.backend.dss.facets.AxisFilter;
import com.dataiku.dip.pivot.backend.dss.facets.DateAxisFaceter;
import com.dataiku.dip.pivot.backend.dss.facets.DateAxisFilter;
import com.dataiku.dip.pivot.backend.dss.facets.ExplicitConditionsFilter;
import com.dataiku.dip.pivot.backend.dss.facets.NumAsAnumAxisFaceter;
import com.dataiku.dip.pivot.backend.dss.facets.NumAsAnumAxisFilter;
import com.dataiku.dip.pivot.backend.dss.facets.NumericalAxisFaceter;
import com.dataiku.dip.pivot.backend.dss.facets.NumericalAxisFilter;
import com.dataiku.dip.pivot.backend.dss.facets.StringAxisFilter;
import com.dataiku.dip.pivot.backend.dss.facets.StringDictAxisFaceter;
import com.dataiku.dip.pivot.backend.dss.facets.StringDictAxisFilter;
import com.dataiku.dip.pivot.backend.model.FilterFacet;
import com.dataiku.dip.pivot.backend.model.PivotTableRequest;
import com.dataiku.dip.pivot.backend.model.PivotTableResponse;
import com.dataiku.dip.pivot.backend.model.RowFilter;
import com.dataiku.dip.pivot.frontend.model.ChartFilter;
import com.dataiku.dip.shaker.filter.FilteringExecutor;
import com.dataiku.dip.utils.DKULogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class PivotTableBuilder {
    protected boolean filtered;
    protected List<AxisFilter> filterExecutors = new ArrayList<AxisFilter>();
    protected int[] filteredRecords;
    protected List<AxisFaceter> filterFaceters = new ArrayList<AxisFaceter>();
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.charts.lino.builder");

    private static AxisFaceter buildLinoAxisFaceter(LinoReader linoReader, RowFilter filter) {
        switch (filter.filterType) {
            case ALPHANUM_FACET: 
            case INTERACTIVE_DATE_FACET: 
            case DATE_FACET: 
            case NUMERICAL_FACET: {
                if (filter.useMinimalUi) {
                    return null;
                }
                switch (filter.columnType) {
                    case DATE: {
                        return new DateAxisFaceter(filter);
                    }
                    case NUMERICAL: {
                        if (filter.filterType == ChartFilter.FilterType.ALPHANUM_FACET) {
                            return new NumAsAnumAxisFaceter(filter);
                        }
                        return new NumericalAxisFaceter();
                    }
                    case ALPHANUM: {
                        LinoMetaFile.ColumnHeader fcol = linoReader.getColHeader(filter.column);
                        if (fcol.memType == ColumnBlock.MemoryType.STRING_DICT) {
                            return new StringDictAxisFaceter(fcol, filter);
                        }
                        return new AnumAxisFaceter(filter);
                    }
                    case GEOMETRY: 
                    case GEOPOINT: {
                        throw new IllegalArgumentException("Geometry column are not supported for faceting");
                    }
                }
                throw new Error("unreachable");
            }
            case EXPLICIT: 
            case ALPHANUM: {
                return null;
            }
        }
        throw new Error("unreachable");
    }

    public static AxisFilter buildLinoAxisFilter(LinoReader linoReader, RowFilter filter) {
        switch (filter.filterType) {
            case ALPHANUM_FACET: 
            case INTERACTIVE_DATE_FACET: 
            case DATE_FACET: 
            case NUMERICAL_FACET: {
                LinoMetaFile.ColumnHeader fcol = linoReader.getColHeader(filter.column);
                switch (filter.columnType) {
                    case DATE: {
                        return new DateAxisFilter(filter);
                    }
                    case NUMERICAL: {
                        if (filter.filterType == ChartFilter.FilterType.ALPHANUM_FACET) {
                            return new NumAsAnumAxisFilter(filter);
                        }
                        return new NumericalAxisFilter(filter);
                    }
                    case ALPHANUM: {
                        if (fcol.memType == ColumnBlock.MemoryType.STRING_DICT) {
                            return new StringDictAxisFilter(filter, fcol);
                        }
                        return new AnumAxisFilter(filter);
                    }
                    case GEOMETRY: 
                    case GEOPOINT: {
                        throw new IllegalArgumentException("Geometry column not supported here");
                    }
                }
                throw new Error("unreachable");
            }
            case ALPHANUM: {
                return new StringAxisFilter(filter);
            }
            case EXPLICIT: {
                return new ExplicitConditionsFilter(filter);
            }
        }
        throw new Error("unreachable");
    }

    protected void buildLinoFilters(PivotTableRequest request, LinoReader linoReader) {
        for (int i = 0; i < request.filters.size(); ++i) {
            this.filterExecutors.add(PivotTableBuilder.buildLinoAxisFilter(linoReader, request.filters.get(i)));
            this.filterFaceters.add(PivotTableBuilder.buildLinoAxisFaceter(linoReader, request.filters.get(i)));
        }
    }

    protected void filterLinoBlock(PivotTableRequest request, LinoReader linoReader, int blockIdx, boolean[] ret) throws IOException {
        Arrays.fill(ret, true);
        this.filteredRecords = new int[this.filterExecutors.size()];
        int beforeFilterCounts = ret.length;
        for (int i = 0; i < this.filterExecutors.size(); ++i) {
            if (!request.filters.get((int)i).active) continue;
            this.filterExecutors.get(i).filter(linoReader, blockIdx, ret);
            int afterFilterCounts = FilteringExecutor.countTrue(ret);
            this.filteredRecords[i] = beforeFilterCounts - afterFilterCounts;
            beforeFilterCounts = afterFilterCounts;
        }
    }

    protected void updateLinoFilterFacets(PivotTableRequest request, LinoReader linoReader, int blockIdx) throws IOException {
        for (int i = 0; i < this.filterFaceters.size(); ++i) {
            if (this.filterFaceters.get(i) == null) continue;
            ColumnBlock block = linoReader.readColumnBlock(request.filters.get((int)i).column, blockIdx);
            boolean[] filters = new boolean[block.nbRecords()];
            Arrays.fill(filters, true);
            for (int k = 0; k < this.filterExecutors.size(); ++k) {
                if (k == i || !request.filters.get((int)k).active) continue;
                this.filterExecutors.get(k).filter(linoReader, blockIdx, filters);
            }
            this.filterFaceters.get(i).observe(block, filters);
        }
    }

    protected void computeFilterFacets(PivotTableRequest request, PivotTableResponse response) {
        for (int i = 0; i < request.filters.size(); ++i) {
            RowFilter rowFilter = request.filters.get(i);
            if (rowFilter.useMinimalUi) continue;
            FilterFacet ff = this.filterFaceters.get(i) == null ? new FilterFacet() : this.filterFaceters.get(i).compute(!rowFilter.allValuesInSample);
            ff.filterIdx = i;
            if (this.filteredRecords != null && i < this.filteredRecords.length) {
                ff.filteredRecords = this.filteredRecords[i];
            }
            ff.isAGlobalFilter = rowFilter.isAGlobalFilter;
            response.filterFacets.add(ff);
        }
    }
}

