/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.dss;

import com.dataiku.dip.pivot.backend.dss.DataTensor;
import com.dataiku.dip.pivot.backend.dss.TensorType;
import com.dataiku.dip.utils.NotImplementedException;
import com.dataiku.j2ts.annotations.UIModel;
import gnu.trove.list.array.TDoubleArrayList;
import gnu.trove.list.array.TIntArrayList;

@UIModel
public class UnaggregatedDataTensor
extends DataTensor<double[]> {
    public final double[][] tensor;
    public final int[][] uaTensorCounts;
    public double[] uaDataNegativeExtent;
    public double[] uaDataPositiveExtent;
    public transient TDoubleArrayList[] uaData;
    public transient TIntArrayList[] uaDataCounts;

    private UnaggregatedDataTensor(int[] axisLengths, boolean dimension1MemorySaving, boolean initNonNullCounts) {
        super(axisLengths, TensorType.OBJECT, dimension1MemorySaving, initNonNullCounts, double[].class);
        this.uaData = new TDoubleArrayList[this.tensorSize];
        this.tensor = new double[this.tensorSize][];
        this.uaDataCounts = new TIntArrayList[this.tensorSize];
        this.uaTensorCounts = new int[this.tensorSize][];
        this.uaDataNegativeExtent = new double[this.tensorSize];
        this.uaDataPositiveExtent = new double[this.tensorSize];
        this.type = TensorType.OBJECT;
    }

    public void setUAData(TDoubleArrayList[] data, TIntArrayList[] dataCounts, double[] negativeExtents, double[] positiveExtents) {
        this.uaData = data;
        this.uaDataCounts = dataCounts;
        this.uaDataNegativeExtent = negativeExtents;
        this.uaDataPositiveExtent = positiveExtents;
    }

    public UnaggregatedDataTensor createMergeDT(int[] axisLengths) {
        return this.createMergeDT(axisLengths, this.hasNullValues);
    }

    public UnaggregatedDataTensor createMergeDT(int axisLength) {
        return this.createMergeDT(axisLength, this.hasNullValues);
    }

    public UnaggregatedDataTensor createMergeDT(int[] axisLengths, boolean hasNullValues) {
        UnaggregatedDataTensor mergeDT = (UnaggregatedDataTensor)new Builder().axisLengths(axisLengths).initNonNullCounts(hasNullValues).build();
        mergeDT.type = this.type;
        mergeDT.hasNullValues = hasNullValues;
        return mergeDT;
    }

    public UnaggregatedDataTensor createMergeDT(int axisLength, boolean hasNullValues) {
        UnaggregatedDataTensor mergeDT = (UnaggregatedDataTensor)new Builder().axisLengths(axisLength).initNonNullCounts(hasNullValues).build();
        mergeDT.type = this.type;
        mergeDT.hasNullValues = hasNullValues;
        return mergeDT;
    }

    @Override
    public void replaceInvalidValues() {
        for (int i = 0; i < this.tensor.length; ++i) {
            for (int k = 0; k < this.tensor[i].length; ++k) {
                double d = this.tensor[i][k];
                if (!Double.isInfinite(d) && !Double.isNaN(d)) continue;
                this.tensor[i][k] = 0.0;
            }
        }
    }

    public void fillDataTensor() {
        int i;
        for (i = 0; i < this.uaData.length; ++i) {
            this.tensor[i] = this.uaData[i] == null ? new double[0] : this.uaData[i].toArray();
            for (int k = 0; k < this.tensor[i].length; ++k) {
                double d = this.tensor[i][k];
                if (!Double.isInfinite(d) && !Double.isNaN(d)) continue;
                this.tensor[i][k] = 0.0;
            }
        }
        for (i = 0; i < this.uaDataCounts.length; ++i) {
            this.uaTensorCounts[i] = this.uaDataCounts[i] == null ? new int[0] : this.uaDataCounts[i].toArray();
        }
    }

    @Override
    public double[] getOrDefault(int[] coordinates, double[] defaultValue) {
        int index = this.loc(coordinates);
        if (this.tensor[index] == null) {
            this.tensor[index] = (double[])defaultValue.clone();
        }
        return this.tensor[index];
    }

    @Override
    public int getAxisLength(int index) {
        throw new NotImplementedException();
    }

    @Override
    public void set(int location, double[] newValue) {
        if (location <= this.tensor.length - 1) {
            this.tensor[location] = newValue;
        }
    }

    @Override
    public void set(int location, double[] data, boolean inferType) {
        this.set(location, data);
    }

    @Override
    public void resize(int newCapacity) {
        throw new NotImplementedException();
    }

    @Override
    public double[] get(int location, boolean realType) {
        return this.tensor[location];
    }

    @Override
    public double[] getAxis(int i, int j) {
        throw new NotImplementedException();
    }

    @Override
    public void setAxis(int i, int j, double[] value) {
        throw new NotImplementedException();
    }

    @Override
    public double getAsDouble(int location) {
        throw new NotImplementedException();
    }

    @Override
    public void setAsDouble(int location, double value) {
        throw new NotImplementedException();
    }

    @Override
    public void setAsDouble(int[] coords, double value) {
        throw new NotImplementedException();
    }

    @Override
    public double getAxisAsDouble(int i, int j) {
        throw new NotImplementedException();
    }

    @Override
    public double[] getAxisAsDouble(int i) {
        throw new NotImplementedException();
    }

    @Override
    public void setAxisAsDouble(int i, int j, double value) {
        throw new NotImplementedException();
    }

    @Override
    public double[] getDoubleTensor() {
        throw new NotImplementedException();
    }

    @Override
    public double[][] getDoubleAxes() {
        throw new NotImplementedException();
    }

    @Override
    public int getAxesLength() {
        throw new NotImplementedException();
    }

    public double[][] getTensor() {
        return this.tensor;
    }

    @Override
    public void initDoubleTensor(double value) {
        throw new NotImplementedException();
    }

    public static class Builder
    extends DataTensor.Builder<double[]> {
        public UnaggregatedDataTensor build() {
            return new UnaggregatedDataTensor(this.axisLengths, this.dimension1MemorySaving, this.initNonNullCounts);
        }
    }
}

