/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.sql.executors;

import com.dataiku.dip.futures.FutureAborter;
import com.dataiku.dip.pivot.backend.sql.executors.ExecutionContext;
import com.dataiku.dip.pivot.backend.sql.executors.SqlExecutionHelper;
import com.dataiku.dip.pivot.backend.sql.queries.ColumnMapper;
import com.dataiku.dip.pivot.backend.sql.queries.SQLTypeSniffer;
import com.dataiku.dip.pivot.backend.sql.utils.ConnectionPool;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.utils.DKULogger;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.concurrent.Callable;

public class ColumnMappingSQLExecutor
implements Callable<ColumnMapper> {
    private ExecutionContext ctx;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.charts.sql.column_mapping");

    public ColumnMappingSQLExecutor(ExecutionContext ctx) {
        this.ctx = ctx;
    }

    @Override
    public ColumnMapper call() throws Exception {
        ColumnMapper colMapping;
        try (ConnectionPool.PooledConnection connection = this.ctx.sqlPool.get();){
            SQLTypeSniffer sniffer = new SQLTypeSniffer(this.ctx.input);
            String sql = sniffer.buildQuery();
            SQLDialect dialect = this.ctx.input.dialect;
            if (dialect.supportsResultSetMetadataOnPreparedStatement(sql)) {
                logger.info((Object)("Running SQL query for determining column types (prepared statement):\n" + sql));
                try (ConnectionPool.ManagedPreparedStatement pstmt = connection.getPreparedStatement(dialect.alterQueryForResultSetMetadataOnPreparedStatement(sql));){
                    colMapping = sniffer.buildMapper(dialect.getResultSetMetadataOnPreparedStatement(pstmt.get()));
                }
            }
            logger.info((Object)("Running SQL query for determining column types (normal statement):\n" + sql));
            try (ConnectionPool.ManagedStatement stmt = connection.getStatement();
                 FutureAborter.AutoCloseableAbortHook ignored = FutureAborter.pushAutoCloseableHook(stmt::cancel);){
                SqlExecutionHelper.execute(connection, stmt, sql, false);
                try (ResultSet rs2 = stmt.get().getResultSet();){
                    ResultSetMetaData meta = rs2.getMetaData();
                    colMapping = sniffer.buildMapper(meta);
                }
            }
            logger.info((Object)("Column types:\n" + colMapping.dumpAsString()));
        }
        return colMapping;
    }
}

