/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.sql.queries;

import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.pivot.backend.model.AxisDef;
import com.dataiku.dip.pivot.backend.model.NumericalAxisParams;
import com.dataiku.dip.pivot.backend.model.PivotTableTensorRequest;
import com.dataiku.dip.pivot.backend.model.RowFilter;
import com.dataiku.dip.pivot.backend.sql.builders.BasicStatsBuilder;
import com.dataiku.dip.pivot.backend.sql.builders.InMemoryResultSet;
import com.dataiku.dip.pivot.backend.sql.queries.AggregateToSQL;
import com.dataiku.dip.pivot.backend.sql.queries.AxisMaterializerToSQL;
import com.dataiku.dip.pivot.backend.sql.queries.BinningToSQL;
import com.dataiku.dip.pivot.backend.sql.queries.ColumnMapper;
import com.dataiku.dip.pivot.backend.sql.queries.FilterToSQL;
import com.dataiku.dip.pivot.backend.sql.queries.InputTable;
import com.dataiku.dip.pivot.backend.sql.queries.SelectQueryBuilder;
import com.dataiku.dip.pivot.backend.sql.queries.SimpleAxisToSQL;
import com.dataiku.dip.pivot.backend.sql.utils.PartitionUtils;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.queries.CombinedSelectQueryBuilder;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.ExpressionUtils;
import com.dataiku.dip.sql.queries.QueryAst;
import com.dataiku.dip.sql.queries.SelectQueryBuilder;
import com.dataiku.dip.utils.NotImplementedException;
import java.util.List;

public class TensorToSQL {
    private static final String MAIN_TABLE_ALIAS = "main";
    private InputTable input;
    private PivotTableTensorRequest req;
    private BasicStatsBuilder.BasicStats stats;
    private ColumnMapper colMapping;
    private SQLDialect dialect;

    public TensorToSQL(InputTable input, PivotTableTensorRequest req, BasicStatsBuilder.BasicStats stats, ColumnMapper colMapping) {
        this.input = input;
        this.req = req;
        this.stats = stats;
        this.dialect = input.dialect;
        this.colMapping = colMapping;
    }

    public static boolean requireJoin(AxisDef axisDef, InMemoryResultSet rs2) {
        if (!AxisMaterializerToSQL.mayRequireJoin(false, axisDef, false)) {
            return false;
        }
        if (axisDef.type == AxisDef.Type.ALPHANUM) {
            if (rs2.count < axisDef.sortPrune.maxValues || !axisDef.sortPrune.isMaxValuesDefined()) {
                return false;
            }
        } else if (axisDef.type == AxisDef.Type.NUMERICAL) {
            if (!(axisDef.numParams.mode != NumericalAxisParams.BinningMode.NONE || rs2.count >= axisDef.sortPrune.maxValues && axisDef.sortPrune.isMaxValuesDefined())) {
                return false;
            }
            if (axisDef.numParams.mode == NumericalAxisParams.BinningMode.FIXED_SIZE || axisDef.numParams.mode == NumericalAxisParams.BinningMode.FIXED_NB) {
                return false;
            }
        } else if (axisDef.type == AxisDef.Type.DATE) {
            return axisDef.dateParams.mode.getDateBinner().requireJoinForSqlEngine();
        }
        return true;
    }

    public MatrixQueryContext build(AxisMaterializerToSQL.MaterializedAxesContext axes, List<InMemoryResultSet> imrss) {
        MatrixQueryContext ctx = new MatrixQueryContext();
        ctx.query = new SelectQueryBuilder();
        ctx.query.from(this.input.table, MAIN_TABLE_ALIAS);
        ctx.mapping = new SimpleAxisToSQL.SelectMapping();
        FilterToSQL filter = new FilterToSQL(this.dialect, this.colMapping);
        filter.filterQuery(ctx.query, (List<RowFilter>)this.req.filters);
        AggregateToSQL aggregator = new AggregateToSQL(this.colMapping, this.dialect, this.input.projectKey);
        ctx.mapping.aggrRefs = aggregator.deduplicateAndAddToQuery(this.req.aggregations, (aggregation, alias) -> {
            SelectQueryBuilder.SelectRef selectRef = new SelectQueryBuilder.SelectRef();
            selectRef.index = ctx.query.select(ExpressionUtils.ef.expr(aggregator.aggregateExpr(aggregation)), alias).getIndex();
            return selectRef;
        });
        for (int i = 0; i < axes.axes.size(); ++i) {
            ExpressionBuilder ref;
            AxisMaterializerToSQL.MaterializedAxis axis = axes.axes.get(i);
            InMemoryResultSet imrs = imrss.get(i);
            boolean join = TensorToSQL.requireJoin(axis.axis.def, imrs);
            BinningToSQL binToSQL = new BinningToSQL(this.dialect, this.colMapping);
            String axisAs = String.format("axis_%s", i);
            if (join) {
                ref = this.createAllBinIfRequired(ctx, this.dialect.getQuotedTableFullName(axis.tempTableTable) + "." + this.dialect.quoteIdentifier(axis.axis.mapping.axisRefs.get((int)0).name), ColumnMapper.ExprType.UNKNOWN, axis, axisAs);
            } else {
                ColumnMapper.TypedExpr sqlExpr = this.colMapping.get(axis.axis.def.column);
                sqlExpr = binToSQL.binningExpression(sqlExpr, axis.axis.def, this.stats);
                ref = this.createAllBinIfRequired(ctx, sqlExpr.expr, sqlExpr.type, axis, axisAs);
            }
            SelectQueryBuilder.SelectRef selectRef = new SelectQueryBuilder.SelectRef();
            selectRef.index = ctx.query.select(ref, axisAs).getIndex();
            ctx.mapping.axisRefs.add(selectRef);
            ctx.query.group(ref);
            if (join) {
                String binnedColumnFullName = this.dialect.quoteIdentifier(MAIN_TABLE_ALIAS) + "." + this.dialect.quoteIdentifier(axis.axis.def.column);
                ColumnMapper.TypedExpr qualifiedColExpr = this.colMapping.get(axis.axis.def.column, binnedColumnFullName);
                String joinCond = binToSQL.binningExpression((ColumnMapper.TypedExpr)qualifiedColExpr, (AxisDef)axis.axis.def, (BasicStatsBuilder.BasicStats)this.stats).expr + "=" + this.dialect.getQuotedTableFullName(axis.tempTableTable) + "." + this.dialect.quoteIdentifier(axis.axis.mapping.axisRefs.get((int)0).name);
                ctx.query.join(axis.tempTableTable, axis.axis.def.sortPrune.generateOthersCategory ? QueryAst.JoinType.LEFT : QueryAst.JoinType.INNER).on(ExpressionUtils.ef.expr(joinCond));
                continue;
            }
            if (!SimpleAxisToSQL.shouldFilterAxisNullValues(axes.axes.get((int)i).axis.def)) continue;
            ctx.query.where(ExpressionUtils.ef.col(axes.axes.get((int)i).axis.def.column).isnotnull());
        }
        PartitionUtils.appendPartitionFilteringClause(this.input, ctx.query);
        return ctx;
    }

    private ExpressionBuilder createAllBinIfRequired(MatrixQueryContext ctx, String expr, ColumnMapper.ExprType exprType, AxisMaterializerToSQL.MaterializedAxis axis, String axisInternalName) {
        if (this.req.computeSubTotals) {
            String type_axis = "type_" + axisInternalName;
            SelectQueryBuilder subQuery = new SelectQueryBuilder();
            CombinedSelectQueryBuilder combinedSelectQueryBuilder = CombinedSelectQueryBuilder.newUnion(false);
            SelectQueryBuilder selectQueryBuilderValue = new SelectQueryBuilder();
            SelectQueryBuilder selectQueryBuilderAll = new SelectQueryBuilder();
            selectQueryBuilderValue.select(ExpressionUtils.ef.cst("__value__"), "type");
            selectQueryBuilderAll.select(ExpressionUtils.ef.cst("___dku_total_value___"));
            combinedSelectQueryBuilder.add(selectQueryBuilderValue);
            combinedSelectQueryBuilder.add(selectQueryBuilderAll);
            subQuery.from(combinedSelectQueryBuilder, type_axis);
            ctx.query.join(ctx.query.with(subQuery, type_axis), QueryAst.JoinType.CROSS);
            if (axis.axis.def.type == AxisDef.Type.ALPHANUM) {
                return ExpressionUtils.ef.caseWhen(ExpressionUtils.ef.col(type_axis, "type").eq(ExpressionUtils.ef.cst("__value__")), ExpressionUtils.ef.expr(expr), ExpressionUtils.ef.cst("___dku_total_value___").castToString(512));
            }
            if (axis.axis.def.type == AxisDef.Type.DATE || axis.axis.def.type == AxisDef.Type.NUMERICAL) {
                if (exprType == null || exprType == ColumnMapper.ExprType.UNKNOWN) {
                    exprType = axis.axis.def.type == AxisDef.Type.NUMERICAL ? ColumnMapper.ExprType.NUMBER : ColumnMapper.ExprType.DATE;
                }
                return ExpressionUtils.ef.caseWhen(ExpressionUtils.ef.col(type_axis, "type").eq(ExpressionUtils.ef.cst("__value__")), ExpressionUtils.ef.expr(expr), ExpressionUtils.ef.nullValue(exprType == ColumnMapper.ExprType.DATE || exprType == ColumnMapper.ExprType.NON_NULL_DATE ? Type.DATE : Type.DOUBLE, -1));
            }
            throw new NotImplementedException("The Axis type is not handled by the SQL Engine");
        }
        return ExpressionUtils.ef.expr(expr);
    }

    public static class MatrixQueryContext {
        public SimpleAxisToSQL.SelectMapping mapping;
        public SelectQueryBuilder query;
    }
}

