/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.plugins.dev;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dao.UsersDAO;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.plugins.dev.DevPluginsService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.TransactionProvider;
import com.dataiku.dip.transactions.git.CommitDef;
import com.dataiku.dip.transactions.git.DSSCommitDef;
import com.dataiku.dip.transactions.git.DSSGitModel;
import com.dataiku.dip.transactions.git.GitModel;
import com.dataiku.dip.transactions.git.cli.GitRemoteCommands;
import com.dataiku.dip.transactions.git.jgit.DevZoneJGitManager;
import com.dataiku.dip.transactions.git.jgit.GitLocalCommands;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PluginsGitService {
    @Autowired
    DevPluginsService devPluginsService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UsersDAO usersDAO;
    private static Logger logger = Logger.getLogger((String)"dku.plugindev.git");

    public GitModel.DKULog getLog_NT(String pluginId, String since, int count) throws IOException, GitAPIException {
        this.devPluginsService.checkPluginIsDev(pluginId);
        try (Transaction t = this.devPluginsService.getTransactionProvider(pluginId).beginRead();){
            GitModel.DKULog dKULog = this.getLocalGit(pluginId).getLog(new ArrayList(), since, count);
            return dKULog;
        }
    }

    public void commit_NT(AuthCtx authCtx, String pluginId, String commitMessage) throws IOException {
        this.devPluginsService.checkPluginIsDev(pluginId);
        PluginsGitService.checkPerPluginGit();
        logger.info((Object)("Committing local changes of " + pluginId));
        TransactionProvider pluginTransactionProvider = this.devPluginsService.getTransactionProvider(pluginId);
        pluginTransactionProvider.performDirectCommit((CommitDef)new DSSCommitDef(DSSCommitDef.CommitDefType.PLUGIN, pluginId, new GitModel.GitAuthor(authCtx), commitMessage, (List)Lists.newArrayList((Object[])new String[]{"."})));
    }

    public GitModel.MultiCommitDiff getCommitDiff(String pluginId) throws IOException {
        PluginsGitService.checkPerPluginGit();
        this.devPluginsService.checkPluginIsDev(pluginId);
        logger.info((Object)("Getting working-copy diff for " + pluginId));
        return this.getLocalGit(pluginId).workingCopyDiff(null);
    }

    public GitModel.SingleCommitObjectDiff getSingleCommitDiff(String pluginId, String commitId) throws IOException, GitAPIException {
        PluginsGitService.checkPerPluginGit();
        return this.getLocalGit(pluginId).singleCommitDiff(commitId);
    }

    public GitModel.MultiCommitDiff getObjectDiff(String pluginId, String from, String to) throws IOException, GitAPIException {
        PluginsGitService.checkPerPluginGit();
        return this.getLocalGit(pluginId).diff(from, to, null, false);
    }

    public void revertPluginToRevision_NT(AuthCtx authCtx, String pluginId, String hash) throws IOException, InterruptedException {
        PluginsGitService.checkPerPluginGit();
        logger.info((Object)("Reverting plugin " + pluginId + " to " + hash));
        this.checkHash(hash);
        this.getLocalGit(pluginId).revertToRevision(new GitModel.GitAuthor(authCtx), hash);
        logger.info((Object)"Revert: revert done, committing it: ");
        this.commit_NT(authCtx, pluginId, "Reverted plugin " + pluginId + " to " + hash);
    }

    public InfoMessage.InfoMessages revertSingleCommit_NT(AuthCtx authCtx, String pluginId, String hash) throws IOException, InterruptedException {
        PluginsGitService.checkPerPluginGit();
        logger.info((Object)("Reverting single revision: " + pluginId + ": " + hash));
        InfoMessage.InfoMessages ret = this.getLocalGit(pluginId).revertSingleCommit(new GitModel.GitAuthor(authCtx), hash);
        if (!ret.anyFatal()) {
            logger.info((Object)"Revert: revert done, committing it: ");
            this.commit_NT(authCtx, pluginId, "Reverted commit " + hash + " from plugin " + pluginId);
        }
        return ret;
    }

    public GitRemoteCommands.GitCommandResult pullRebase_NT(String pluginId, String remoteName, String branchName, AuthCtx authCtx, DKUtils.SmartLogTailBuilder logTailBuilder) throws IOException {
        this.devPluginsService.checkPluginIsDev(pluginId);
        PluginsGitService.checkPerPluginGit();
        try (RWTransaction t = this.devPluginsService.getTransactionProvider(pluginId).beginWrite(authCtx);){
            logger.info((Object)("Git pull for plugin: " + pluginId));
            GitRemoteCommands.GitCommandResult gitCommandResult = this.getRemoteGit(pluginId).pullRebase(authCtx, remoteName, branchName, logTailBuilder);
            return gitCommandResult;
        }
    }

    public GitRemoteCommands.GitCommandResult fetch_NT(String pluginId, String remoteName, AuthCtx authCtx, DKUtils.SmartLogTailBuilder logTailBuilder) throws IOException {
        this.devPluginsService.checkPluginIsDev(pluginId);
        PluginsGitService.checkPerPluginGit();
        try (RWTransaction t = this.devPluginsService.getTransactionProvider(pluginId).beginWrite(authCtx);){
            logger.info((Object)("Git fetch for plugin: " + pluginId));
            GitRemoteCommands.GitCommandResult gitCommandResult = this.getRemoteGit(pluginId).fetch(authCtx, remoteName, logTailBuilder);
            return gitCommandResult;
        }
    }

    public GitRemoteCommands.GitCommandResult push_NT(AuthCtx authCtx, String pluginId, String remoteName, String branchName, DKUtils.SmartLogTailBuilder logTailBuilder) throws IOException {
        this.devPluginsService.checkPluginIsDev(pluginId);
        PluginsGitService.checkPerPluginGit();
        try (Transaction t = this.devPluginsService.getTransactionProvider(pluginId).beginRead();){
            logger.info((Object)("Git push for plugin: " + pluginId));
            GitLocalCommands localGit = this.getLocalGit(pluginId);
            boolean setUpstream = StringUtils.isEmpty((CharSequence)localGit.getRemoteTrackingBranch());
            branchName = (String)StringUtils.defaultIfBlank((CharSequence)branchName, (CharSequence)localGit.getCurrentBranch());
            remoteName = (String)StringUtils.defaultIfBlank((CharSequence)remoteName, (CharSequence)"origin");
            GitRemoteCommands.GitCommandResult gitCommandResult = this.getRemoteGit(pluginId).pushWithLogTail(authCtx, remoteName, branchName, setUpstream, logTailBuilder);
            return gitCommandResult;
        }
    }

    public void resetToUpstream_NT(AuthCtx authCtx, String pluginId, String remoteName, String branchName) throws IOException, CodedException {
        this.devPluginsService.checkPluginIsDev(pluginId);
        PluginsGitService.checkPerPluginGit();
        try (Transaction t = this.devPluginsService.getTransactionProvider(pluginId).beginRead();){
            logger.info((Object)("Git reset to upstream: " + pluginId));
            branchName = GitLocalCommands.shortenRefName((String)branchName);
            this.getRemoteGit(pluginId).fetch(authCtx, remoteName, branchName);
            if (StringUtils.isNotBlank((CharSequence)remoteName) && StringUtils.isNotBlank((CharSequence)branchName)) {
                this.getLocalGit(pluginId).hardResetTo(remoteName + "/" + branchName);
            } else {
                this.getLocalGit(pluginId).hardResetTo("@{upstream}");
            }
        }
    }

    public void resetToHead_NT(String pluginId) throws IOException, CodedException {
        this.devPluginsService.checkPluginIsDev(pluginId);
        PluginsGitService.checkPerPluginGit();
        try (Transaction t = this.devPluginsService.getTransactionProvider(pluginId).beginRead();){
            logger.info((Object)("Git reset to HEAD: " + pluginId));
            this.getLocalGit(pluginId).hardResetTo("HEAD");
        }
    }

    public GitModel.GitFullStatus getFullStatus_NT(String pluginId) throws IOException, GitAPIException {
        PluginsGitService.checkPerPluginGit();
        GitModel.GitFullStatus st2 = new GitModel.GitFullStatus();
        try (Transaction t = this.devPluginsService.getTransactionProvider(pluginId).beginRead();){
            GitLocalCommands localGit = this.getLocalGit(pluginId);
            st2.currentBranch = localGit.getCurrentBranch();
            st2.remotes = localGit.listRemotes();
            st2.trackingCount = localGit.getGitTrackingCount();
        }
        return st2;
    }

    public List<GitModel.GitRemote> listRemotes_NT(String pluginId) throws IOException, GitAPIException {
        this.devPluginsService.checkPluginIsDev(pluginId);
        try (Transaction t = this.devPluginsService.getTransactionProvider(pluginId).beginRead();){
            List list = this.getLocalGit(pluginId).listRemotes();
            return list;
        }
    }

    public String getCurrentBranch_NT(String pluginId) throws IOException {
        PluginsGitService.checkPerPluginGit();
        try (Transaction t = this.devPluginsService.getTransactionProvider(pluginId).beginRead();){
            String string = this.getLocalGit(pluginId).getCurrentBranch();
            return string;
        }
    }

    public GitModel.GitBranches listBranches_NT(String pluginId) throws GitAPIException, IOException {
        this.devPluginsService.checkPluginIsDev(pluginId);
        PluginsGitService.checkPerPluginGit();
        try (Transaction t = this.devPluginsService.getTransactionProvider(pluginId).beginRead();){
            GitModel.GitBranches branches = new GitModel.GitBranches();
            logger.info((Object)("List branches for plugin: " + pluginId));
            GitLocalCommands localGit = this.getLocalGit(pluginId);
            branches.local = localGit.listLocalBranches();
            branches.remote = localGit.listRemoteBranches(false);
            GitModel.GitBranches gitBranches = branches;
            return gitBranches;
        }
    }

    public Set<String> listAvailableBranches_NT(String pluginId) throws GitAPIException, IOException {
        this.devPluginsService.checkPluginIsDev(pluginId);
        PluginsGitService.checkPerPluginGit();
        try (Transaction t = this.devPluginsService.getTransactionProvider(pluginId).beginRead();){
            logger.info((Object)("List available branches for plugin: " + pluginId));
            GitLocalCommands localGit = this.getLocalGit(pluginId);
            HashSet<String> branches = new HashSet<String>(localGit.listLocalBranches());
            branches.addAll(localGit.listRemoteBranches(true));
            branches.remove("HEAD");
            HashSet<String> hashSet = branches;
            return hashSet;
        }
    }

    public void deleteLocalBranch_NT(String pluginId, String branchName, boolean forceDelete) throws IOException, GitAPIException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)pluginId));
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)branchName));
        logger.info((Object)String.format("Delete local branch %s for project %s", branchName, pluginId));
        GitLocalCommands localGit = this.getLocalGit(pluginId);
        localGit.deleteLocalBranch(branchName, forceDelete);
    }

    public String deleteRemoteBranch_NT(AuthCtx authCtx, String pluginId, String branchName, boolean forceDelete, boolean deleteRemotely, String remoteName) throws IOException, CodedException, GitAPIException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)pluginId));
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)branchName));
        logger.info((Object)String.format("Delete remote branch %s for project %s", branchName, pluginId));
        this.getLocalGit(pluginId).deleteRemoteBranch(remoteName, branchName, forceDelete);
        if (deleteRemotely) {
            return this.getRemoteGit(pluginId).deleteRemoteBranch(authCtx, remoteName, branchName);
        }
        return null;
    }

    public String createBranch_NT(AuthCtx authCtx, String pluginId, String branchName, @Nullable String commitId) throws IOException, CodedException {
        this.devPluginsService.checkPluginIsDev(pluginId);
        PluginsGitService.checkPerPluginGit();
        logger.info((Object)("Git create branch for plugin: " + pluginId));
        try (RWTransaction t = this.devPluginsService.getTransactionProvider(pluginId).beginWrite(authCtx);){
            String string = this.getRemoteGit(pluginId).createAndCheckoutBranch(branchName, commitId);
            return string;
        }
    }

    public String checkoutBranch_NT(AuthCtx authCtx, String pluginId, String branchName) throws IOException, InterruptedException, CodedException {
        this.devPluginsService.checkPluginIsDev(pluginId);
        PluginsGitService.checkPerPluginGit();
        logger.info((Object)("Git switch branch for plugin: " + pluginId));
        try (RWTransaction t = this.devPluginsService.getTransactionProvider(pluginId).beginWrite(authCtx);){
            String string = this.getRemoteGit(pluginId).checkoutBranch(branchName);
            return string;
        }
    }

    public String getRepository_NT(String pluginId, String remoteName) throws IOException, GitAPIException {
        this.devPluginsService.checkPluginIsDev(pluginId);
        PluginsGitService.checkPerPluginGit();
        try (Transaction t = this.devPluginsService.getTransactionProvider(pluginId).beginRead();){
            for (GitModel.GitRemote remote : this.getLocalGit(pluginId).listRemotes()) {
                if (!remote.name.equals(remoteName)) continue;
                String string = remote.url;
                return string;
            }
            Iterator iterator = null;
            return iterator;
        }
    }

    public String addOrSetRepository_NT(String pluginId, String remoteName, String remoteUrl, AuthCtx authCtx) throws IOException, CodedException, GitAPIException, UnauthorizedException {
        this.devPluginsService.checkPluginIsDev(pluginId);
        PluginsGitService.checkPerPluginGit();
        try (RWTransaction t = this.devPluginsService.getTransactionProvider(pluginId).beginWrite(authCtx);){
            for (GitModel.GitRemote remote : this.getLocalGit(pluginId).listRemotes()) {
                if (!remote.name.equals(remoteName)) continue;
                logger.info((Object)("Git set remote url for plugin: " + pluginId));
                String string = this.getRemoteGit(pluginId).changeRemoteURL(authCtx, remoteName, remoteUrl);
                return string;
            }
            logger.info((Object)("Git add remote for plugin: " + pluginId));
            String string = this.getRemoteGit(pluginId).addRemoteRepository(authCtx, remoteName, remoteUrl, true);
            return string;
        }
    }

    public void setUpstreamForLocalBranches_NT(AuthCtx authCtx, String remoteName, String pluginId) throws IOException, GitAPIException {
        this.devPluginsService.checkPluginIsDev(pluginId);
        PluginsGitService.checkPerPluginGit();
        try (Transaction t = this.devPluginsService.getTransactionProvider(pluginId).beginRead();){
            GitLocalCommands localGit = this.getLocalGit(pluginId);
            List branches = localGit.listLocalBranches();
            branches.retainAll(localGit.listRemoteBranches(true));
            for (String branch : branches) {
                try {
                    this.getRemoteGit(pluginId).setUpstream(authCtx, remoteName, branch);
                }
                catch (CodedException ignored) {
                    logger.warn((Object)("Could not set upstream for branch " + branch));
                }
            }
            logger.info((Object)("Git set branches upstream for plugin: " + pluginId));
        }
    }

    public String removeRemoteRepository_NT(String pluginId, String remoteName, AuthCtx authCtx) throws IOException, CodedException {
        this.devPluginsService.checkPluginIsDev(pluginId);
        PluginsGitService.checkPerPluginGit();
        try (RWTransaction t = this.devPluginsService.getTransactionProvider(pluginId).beginWrite(authCtx);){
            logger.info((Object)("Git rm remote for plugin: " + pluginId));
            String string = this.getRemoteGit(pluginId).removeRemoteRepository(remoteName);
            return string;
        }
    }

    private GitLocalCommands getLocalGit(String pluginId) throws IOException {
        File file;
        if (ApplicationConfigurator.getPluginGitMode() == DSSGitModel.PluginGitMode.GLOBAL) {
            PluginsGitService pluginsGitService = this;
            file = pluginsGitService.devPluginsService.getPluginsRoot();
        } else {
            file = this.devPluginsService.getPluginRoot(pluginId);
        }
        File pluginRoot = file;
        try (DevZoneJGitManager gitManager = new DevZoneJGitManager(pluginRoot);){
            Git git = gitManager.getGlobalGit();
            GitLocalCommands gitLocalCommands = new GitLocalCommands(git);
            return gitLocalCommands;
        }
    }

    private GitRemoteCommands getRemoteGit(String pluginId) {
        return new GitRemoteCommands(this.devPluginsService.getPluginRoot(pluginId));
    }

    private void checkHash(String hash) {
        if (!hash.matches("^[0-9a-f]*$")) {
            throw new SecurityException("Illegal hash: " + hash);
        }
    }

    static void checkPerPluginGit() {
        if (ApplicationConfigurator.getPluginGitMode() == DSSGitModel.PluginGitMode.GLOBAL) {
            throw new IllegalArgumentException("Cannot perform this action: DSS Git for plugins is in global mode");
        }
    }

    public void addTag_NT(AuthCtx author, String pluginId, String name, String message, String reference) throws IOException, GitAPIException {
        GitLocalCommands localGit = this.getLocalGit(pluginId);
        localGit.addTag(new GitModel.GitAuthor(author), name, message, reference);
    }

    public void removeTag_NT(String pluginId, String name) throws IOException, GitAPIException {
        GitLocalCommands localGit = this.getLocalGit(pluginId);
        localGit.removeTag(name);
    }

    public Map<String, Set<GitModel.GitTag>> listTagsByCommitId(String pluginId) throws Exception {
        GitLocalCommands localGit = this.getLocalGit(pluginId);
        return localGit.getTagsByCommitId();
    }
}

