/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.populardatasets;

import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.populardatasets.MostUsedDatasetInfos;
import com.dataiku.dip.populardatasets.PopularDatasetsProcessing;
import com.dataiku.dss.shadelib.com.google.common.annotations.VisibleForTesting;

class PopularDatasetInfos
extends MostUsedDatasetInfos {
    public int numDownstreamRecipes;
    public boolean isTrending;
    public long lastBuild;
    public float averageDownstreamRecipesPerProject;
    public float numSharesPerMonth;
    public float percentNewRecipesCreatedDuringLastWindow;

    private PopularDatasetInfos() {
    }

    public PopularDatasetInfos(PopularDatasetsProcessing.DatasetInfo dataset, int numShares, long lastBuild, PopularDatasetsProcessing.DownstreamRecipesDesc recipesDesc, float numSharesPerMonth) {
        super(dataset, numShares);
        this.numDownstreamRecipes = recipesDesc.numDownstreamRecipes;
        this.lastBuild = lastBuild;
        this.isTrending = recipesDesc.isTrending;
        this.averageDownstreamRecipesPerProject = (float)this.numDownstreamRecipes / (float)numShares;
        this.numSharesPerMonth = numSharesPerMonth;
        this.percentNewRecipesCreatedDuringLastWindow = recipesDesc.percentNewRecipesCreatedDuringLastWindow;
    }

    @VisibleForTesting
    public PopularDatasetInfos(boolean isTrending, int numShares, float numSharesPerMonth, float percentNewRecipesCreatedDuringLastWindow) {
        super(new PopularDatasetsProcessing.DatasetInfo(new SerializedDataset("type"), 0, 0), numShares);
        this.numDownstreamRecipes = 0;
        this.averageDownstreamRecipesPerProject = 0.0f;
        this.lastBuild = 0L;
        this.isTrending = isTrending;
        this.numSharesPerMonth = numSharesPerMonth;
        this.percentNewRecipesCreatedDuringLastWindow = percentNewRecipesCreatedDuringLastWindow;
    }
}

