/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes;

import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.ComputableFromRefService;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowManagedFolder;
import com.dataiku.dip.dataflow.graph.FlowModelEvaluationStore;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.dataflow.graph.FlowSavedModel;
import com.dataiku.dip.dataflow.graph.FlowStreamingEndpoint;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.server.SpringUtils;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class FakeJobActivityFromRecipeBuilder {
    @Autowired
    private ComputableFromRefService computableFromRefService;
    @Autowired
    private DatasetsDAO datasetsDAO;

    public FakeJobActivityFromRecipeBuilder() {
        SpringUtils.getInstance().autowire((Object)this);
    }

    public JobActivity buildFakeJobActivity(SerializedRecipe recipe) throws IOException {
        return new JobActivity(this.buildFakeSubgraph(new FlowRecipe(recipe)));
    }

    public JobActivity buildFakeJobActivity(FlowRecipe recipe) throws IOException {
        return new JobActivity(this.buildFakeSubgraph(recipe));
    }

    public RecipeRunnableSubgraph buildFakeSubgraph(FlowRecipe recipe) throws IOException {
        FlowModelEvaluationStore fmes;
        FlowManagedFolder fmf;
        FlowComputable fsm;
        FlowComputable computable;
        RecipeRunnableSubgraph subgraph = new RecipeRunnableSubgraph(recipe);
        SerializedRecipe sr = recipe.getModel();
        for (Map.Entry<String, SerializedRecipe.InputRole> entry : sr.getInputsUnsafe().entrySet()) {
            for (SerializedRecipe.RecipeInput recipeInput : entry.getValue().items) {
                computable = this.computableFromRefService.get(sr.projectKey, recipeInput.ref);
                switch (computable.getType()) {
                    case DATASET: {
                        FlowDataset fds = (FlowDataset)computable;
                        subgraph.addSource(fds, entry.getKey());
                        PartitioningScheme partitioning = fds.getMandatory(this.datasetsDAO).getPartitioningSchema();
                        Partition sample = Partition.randomSamplePartition((PartitioningScheme)partitioning);
                        subgraph.getSourcePartitions().put(fds.getFullId(), Lists.newArrayList((Object[])new Partition[]{sample}));
                        break;
                    }
                    case SAVED_MODEL: {
                        fsm = (FlowSavedModel)computable;
                        subgraph.addSource(fsm, entry.getKey());
                        subgraph.getSourcePartitions().put(((FlowSavedModel)fsm).getFullId(), Lists.newArrayList((Object[])new Partition[]{new Partition(null)}));
                        break;
                    }
                    case MANAGED_FOLDER: {
                        fmf = (FlowManagedFolder)computable;
                        subgraph.addSource(fmf, entry.getKey());
                        PartitioningScheme partitioning = fmf.getManagedFolder().getPartitioningSchema();
                        Partition sample = Partition.randomSamplePartition((PartitioningScheme)partitioning);
                        subgraph.getSourcePartitions().put(fmf.getFullId(), Lists.newArrayList((Object[])new Partition[]{sample}));
                        break;
                    }
                    case STREAMING_ENDPOINT: {
                        fsm = (FlowStreamingEndpoint)computable;
                        subgraph.addSource(fsm, entry.getKey());
                        subgraph.getSourcePartitions().put(((FlowStreamingEndpoint)fsm).getFullId(), Lists.newArrayList((Object[])new Partition[]{new Partition(null)}));
                        break;
                    }
                    case MODEL_EVALUATION_STORE: {
                        fmes = (FlowModelEvaluationStore)computable;
                        subgraph.addSource(fmes, entry.getKey());
                        PartitioningScheme partitioning = fmes.getModelEvaluationStore().getPartitioningSchema();
                        Partition sample = Partition.randomSamplePartition((PartitioningScheme)partitioning);
                        subgraph.getSourcePartitions().put(fmes.getFullId(), Lists.newArrayList((Object[])new Partition[]{sample}));
                        break;
                    }
                }
            }
        }
        for (Map.Entry<String, Object> entry : sr.getOutputsUnsafe().entrySet()) {
            for (SerializedRecipe.RecipeOutput recipeOutput : ((SerializedRecipe.OutputRole)entry.getValue()).items) {
                computable = this.computableFromRefService.get(sr.projectKey, recipeOutput.ref);
                switch (computable.getType()) {
                    case DATASET: {
                        FlowDataset outFds = (FlowDataset)computable;
                        subgraph.addTarget(outFds, entry.getKey());
                        subgraph.getTargetPartitions().put(outFds.getFullId(), Partition.randomSamplePartition((PartitioningScheme)outFds.getMandatory(this.datasetsDAO).getPartitioningSchema()));
                        break;
                    }
                    case SAVED_MODEL: {
                        fsm = (FlowSavedModel)computable;
                        subgraph.addTarget(fsm, entry.getKey());
                        subgraph.getTargetPartitions().put(((FlowSavedModel)fsm).getFullId(), new Partition(null));
                        break;
                    }
                    case MANAGED_FOLDER: {
                        fmf = (FlowManagedFolder)computable;
                        subgraph.addTarget(fmf, entry.getKey());
                        subgraph.getTargetPartitions().put(fmf.getFullId(), Partition.randomSamplePartition((PartitioningScheme)fmf.getManagedFolder().getPartitioningSchema()));
                        break;
                    }
                    case STREAMING_ENDPOINT: {
                        fsm = (FlowStreamingEndpoint)computable;
                        subgraph.addTarget(fsm, entry.getKey());
                        subgraph.getTargetPartitions().put(((FlowStreamingEndpoint)fsm).getFullId(), new Partition(null));
                        break;
                    }
                    case MODEL_EVALUATION_STORE: {
                        fmes = (FlowModelEvaluationStore)computable;
                        subgraph.addTarget(fmes, entry.getKey());
                        subgraph.getTargetPartitions().put(fmes.getFullId(), Partition.randomSamplePartition((PartitioningScheme)fmes.getModelEvaluationStore().getPartitioningSchema()));
                        break;
                    }
                }
            }
        }
        return subgraph;
    }
}

