/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.code.hive;

import com.dataiku.dip.activity.ConnectionTasksService;
import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.cluster.ClusterSettings;
import com.dataiku.dip.cluster.HadoopSettings;
import com.dataiku.dip.cluster.HiveSettings;
import com.dataiku.dip.connections.HiveConnection;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.exec.AbortableRecipeRunner;
import com.dataiku.dip.dataflow.exec.ActivityAbortedException;
import com.dataiku.dip.dataflow.jobrunner.JobContext;
import com.dataiku.dip.dataflow.utils.FlowJobUtils;
import com.dataiku.dip.hive.HiveConfigurator;
import com.dataiku.dip.hive.HiveExecutor;
import com.dataiku.dip.hive.HiveProgressListener;
import com.dataiku.dip.hive.HiveScriptPreprocessor;
import com.dataiku.dip.hive.HiveServer2ConnectionPoolService;
import com.dataiku.dip.hive.Hiveserver2LogSniffer;
import com.dataiku.dip.recipes.code.hive.HiveRecipeMeta;
import com.dataiku.dip.resourceusage.ComputeResourceUsage;
import com.dataiku.dip.resourceusage.SQLComputeResourceUsage;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.impersonation.HadoopDelegationTokensGenerator;
import com.dataiku.dip.security.impersonation.ImpersonationResolverService;
import com.dataiku.dip.security.impersonation.MapRTicketGenerator;
import com.dataiku.dip.security.impersonation.UserImpersonationTarget;
import com.dataiku.dip.sql.HiveSQLDialect;
import com.dataiku.dip.sql.queries.Splitter;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.log4j.Level;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractHiveRecipeRunner
implements AbortableRecipeRunner {
    @Autowired
    protected HiveServer2ConnectionPoolService hiveServer2ConnectionPoolService;
    @Autowired
    protected ImpersonationResolverService impersonationService;
    protected boolean abortNotified;
    protected DKUtils.ExecKiller hiveProcess;
    protected Statement currentStatement;
    protected Hiveserver2LogSniffer currentLogSniffer;
    protected boolean runTerminated = false;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.recipes.internal.hive");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyBeforeAborting() {
        Hiveserver2LogSniffer snifferToCancel;
        Statement statementToCancel;
        DKUtils.ExecKiller hiveProcessCopy;
        AbstractHiveRecipeRunner abstractHiveRecipeRunner = this;
        synchronized (abstractHiveRecipeRunner) {
            if (this.abortNotified) {
                return;
            }
            this.abortNotified = true;
            hiveProcessCopy = this.hiveProcess;
            statementToCancel = this.currentStatement;
            snifferToCancel = this.currentLogSniffer;
        }
        if (hiveProcessCopy != null) {
            hiveProcessCopy.kill();
        }
        if (snifferToCancel != null) {
            try {
                snifferToCancel.stop();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.error((Object)"Unable to stop log sniffing", (Throwable)e);
            }
        }
        if (statementToCancel != null) {
            try {
                logger.info((Object)"Cancelling SQL statement...");
                statementToCancel.cancel();
                logger.info((Object)"SQL statement cancelled!");
            }
            catch (SQLException e) {
                logger.error((Object)"Unable to cancel SQL statement", (Throwable)e);
            }
        }
        abstractHiveRecipeRunner = this;
        synchronized (abstractHiveRecipeRunner) {
            long start = System.currentTimeMillis();
            while (!this.runTerminated) {
                long end = System.currentTimeMillis();
                if (end - start > 15000L) {
                    logger.error((Object)"The recipe cannot be properly stopped. It'll be killed abruptly with the JEK.");
                    return;
                }
                logger.info((Object)"Waiting for the recipe to terminate...");
                try {
                    this.wait(5000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            logger.info((Object)"Recipe terminated!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeCancellableStatement(SQLConnectionProvider.SQLConnectionWrapper conn, Statement statement, String sql) throws Exception {
        AbstractHiveRecipeRunner abstractHiveRecipeRunner;
        logger.info((Object)"Executing statement: ");
        logger.info((Object)sql);
        Hiveserver2LogSniffer logSniffer = new Hiveserver2LogSniffer(statement);
        AbstractHiveRecipeRunner abstractHiveRecipeRunner2 = this;
        synchronized (abstractHiveRecipeRunner2) {
            if (this.abortNotified) {
                throw new ActivityAbortedException();
            }
            if (this.currentStatement != null) {
                throw new RuntimeException("This is a bug: concurrent statement are not possible !");
            }
            this.currentStatement = statement;
            this.currentLogSniffer = logSniffer;
        }
        ComputeResourceUsage cru = SQLComputeResourceUsage.forSQLQuery(conn, sql).reportStartNoFail();
        try {
            logSniffer.startRedirecting((DKUtils.LineSubscription)new DKUtils.LoggingLineSubscription(Level.INFO));
            statement.execute(sql);
            logger.info((Object)"Statement done");
        }
        finally {
            logSniffer.stop();
            cru.reportCompleteNoFail();
            abstractHiveRecipeRunner = this;
            synchronized (abstractHiveRecipeRunner) {
                this.currentLogSniffer = null;
                this.currentStatement = null;
            }
        }
        abstractHiveRecipeRunner = this;
        synchronized (abstractHiveRecipeRunner) {
            if (this.abortNotified) {
                throw new RuntimeException("Activity aborted !");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startAndWaitHive(JobActivity activity, JobContext jta, HiveScriptPreprocessor preprocessor, HiveProgressListener hpl, String tempId, List<SimpleKeyValue> extraConf, HiveRecipeMeta.HiveExecutionEngine metastoreHandling, AuthCtx authCtx, String projectKey) throws Exception {
        block37: {
            logger.infoV("Running Hive in mode=%s with extraConf=%s", new Object[]{metastoreHandling, JSON.json(extraConf)});
            ConnectionTasksService.HiveRun rrh = activity.runningThings.addHive();
            rrh.startedOn = System.currentTimeMillis();
            try {
                AbstractHiveRecipeRunner abstractHiveRecipeRunner = this;
                synchronized (abstractHiveRecipeRunner) {
                    if (this.abortNotified) {
                        throw new ActivityAbortedException();
                    }
                }
                if (metastoreHandling == HiveRecipeMeta.HiveExecutionEngine.HIVESERVER2) {
                    HiveConnection connection = HiveConfigurator.configureConnectionForDatabase(authCtx, "default", extraConf, this.hiveServer2ConnectionPoolService);
                    SQLConnectionProvider.SQLConnectionData connData = connection.getConnectionData_NT(authCtx, projectKey);
                    try (SQLConnectionProvider.SQLConnectionWrapper conn = connData.buildConnection(preprocessor.getAuthCtx(), projectKey, null, true);){
                        String[] queries;
                        Statement stmt;
                        HiveSQLDialect dialect = new HiveSQLDialect();
                        Splitter splitter = new Splitter(dialect.getSemicolonExclusionPortionFinders());
                        Pattern addJarPattern = Pattern.compile("^\\s*add\\s+jar\\s+.*$", 2);
                        if (preprocessor.getInitQuery() != null) {
                            String[] initQueries;
                            for (String query : initQueries = splitter.split(preprocessor.getInitQuery())) {
                                stmt = conn.createStatement();
                                try {
                                    if (addJarPattern.matcher(query).matches()) {
                                        logger.info((Object)("Detected an ADD JAR ... query. Ignoring : " + query));
                                        continue;
                                    }
                                    this.executeCancellableStatement(conn, stmt, query);
                                }
                                finally {
                                    if (stmt != null) {
                                        stmt.close();
                                    }
                                }
                            }
                        }
                        for (String query : queries = splitter.split(preprocessor.getQuery())) {
                            stmt = conn.createStatement();
                            try {
                                this.executeCancellableStatement(conn, stmt, query);
                            }
                            finally {
                                if (stmt != null) {
                                    stmt.close();
                                }
                            }
                        }
                        break block37;
                    }
                }
                AutoDelete tmpFolder = FlowJobUtils.getTmpFolder("hive-recipe-base", "hive");
                HashMap extraEnv = Maps.newHashMap();
                if (this.impersonationService.isEnabled()) {
                    if (HadoopDelegationTokensGenerator.isDisabled()) {
                        throw new UnsupportedOperationException("Hive CLI not available when Hadoop delegation tokens are disabled");
                    }
                    UserImpersonationTarget impersonated = this.impersonationService.getTargetUser(projectKey, authCtx);
                    File hadoopDelegationTokensFile = new File((File)tmpFolder, tempId + ".creds");
                    ClusterSettings clusterSettings = new ClusterSelector().selectForProject(authCtx, ((RecipeRunnableSubgraph)activity.getSubgraph()).getRecipe().getProjectKey());
                    if (MapRTicketGenerator.isMapR()) {
                        MapRTicketGenerator.generateTicketForUser(impersonated.hadoopUser, hadoopDelegationTokensFile.getAbsolutePath());
                        extraEnv.put("MAPR_TICKETFILE_LOCATION", hadoopDelegationTokensFile.getAbsolutePath());
                    } else {
                        HadoopSettings hadoopSettings = clusterSettings.getHadoopSettings();
                        HiveSettings hiveSettings = clusterSettings.getHiveSettings();
                        ArrayList extraConfForTokens = Lists.newArrayList();
                        extraConfForTokens.addAll(hadoopSettings.extraConf.getAsSimpleKeyValueList());
                        extraConfForTokens.addAll(hiveSettings.executionConfigsGenericOverrides.getAsSimpleKeyValueList());
                        HadoopDelegationTokensGenerator.generateSparkTokenFile(impersonated.hadoopUser, "file://" + hadoopDelegationTokensFile.getAbsolutePath(), extraConfForTokens);
                        extraEnv.put("HADOOP_TOKEN_FILE_LOCATION", hadoopDelegationTokensFile.getAbsolutePath());
                    }
                    extraConf.add(new SimpleKeyValue("tez.credentials.path", hadoopDelegationTokensFile.getAbsolutePath()));
                }
                AbstractHiveRecipeRunner abstractHiveRecipeRunner2 = this;
                synchronized (abstractHiveRecipeRunner2) {
                    this.hiveProcess = HiveExecutor.runInTempEnv(preprocessor.getInitQuery(), preprocessor.getQuery(), (File)tmpFolder, tempId, hpl, extraConf, metastoreHandling == HiveRecipeMeta.HiveExecutionEngine.HIVECLI_GLOBAL, extraEnv);
                }
            }
            finally {
                rrh.doneOn = System.currentTimeMillis();
            }
        }
    }

    protected HiveProgressListener makeListener(final JobActivity activity) {
        return new HiveProgressListener(){

            @Override
            public void progressChanged(double global) {
                if (activity != null) {
                    activity.setStatusMessage("Hive (" + (int)(global * 100.0) + "%)");
                }
            }

            @Override
            public void jobChanged(int job, int nbJobs) {
            }
        };
    }
}

