/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.code.pig;

import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.cluster.ClusterSettings;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.hive.HProxyKernelHandle;
import com.dataiku.dip.hive.HProxyKernelsManager;
import com.dataiku.dip.pig.BadReplacementException;
import com.dataiku.dip.pig.PigSchemaTools;
import com.dataiku.dip.pig.PigScriptPreprocessor;
import com.dataiku.dip.recipes.code.CodeBasedRecipeStatus;
import com.dataiku.dip.recipes.consistency.BasicRecipeConsistencyChecker;
import com.dataiku.dip.recipes.consistency.MiscStuffChecker;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.recipes.PreprocessedQueryForSubstitution;
import com.dataiku.dip.server.recipes.RecipeSchemaService;
import com.dataiku.dip.server.recipes.RecipeVariablesHelper;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesService;
import com.dataiku.hproxy.model.pig.FieldDescription;
import com.dataiku.hproxy.model.pig.ValidationResult;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class PigRecipeTester {
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private VariablesService variablesService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private RecipeSchemaService recipeSchemaService;
    @Autowired
    private HProxyKernelsManager hproxyKernelsManager;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.flow.recipes.pig");

    public PigRecipeTester() {
        SpringUtils.getInstance().autowire((Object)this);
    }

    public PigCheckContext startCheckPig(AuthCtx authCtx, SerializedRecipe sa, String scriptData, RecipeRunnableSubgraph subgraph) throws Exception {
        sa = (SerializedRecipe)JSON.parse((String)JSON.json((Object)sa), SerializedRecipe.class);
        PigCheckContext checking = new PigCheckContext();
        checking.proceed = false;
        checking.status = new PigRecipeStatus();
        new BasicRecipeConsistencyChecker(sa).check(checking.status.topLevelMessages);
        if (checking.status.topLevelMessages.anyFatal()) {
            return checking;
        }
        new MiscStuffChecker(sa).check(checking.status.topLevelMessages, authCtx, sa.projectKey);
        checking.subgraph = subgraph;
        checking.clusterSettings = new ClusterSelector().selectForProject(authCtx, sa.getProjectKey());
        checking.preprocessor = new PigScriptPreprocessor(authCtx, this.datasetsDAO, this.variablesService.getForProject(sa.projectKey), sa.projectKey, checking.subgraph, scriptData, true);
        try {
            checking.preprocessor.preprocess();
            String preprocessedScript = checking.preprocessor.getPreprocessed();
            PreprocessedQueryForSubstitution preprocessedQuery = PreprocessedQueryForSubstitution.preprocess(preprocessedScript);
            RecipeVariablesHelper.RecipeSubstitutionVariablesResult vres = new RecipeVariablesHelper().getRecipeVariablesAndSubstitute(authCtx, sa.projectKey, checking.subgraph, preprocessedQuery, null);
            checking.status.substitutionVariables = vres.substitutionVariables;
            checking.status.topLevelMessages.mergeFrom(vres.messages);
            vres.throwIfSubstitutionError();
            checking.proceed = true;
        }
        catch (BadReplacementException e) {
            logger.error((Object)"Pig preprocessor error", (Throwable)e);
            InfoMessage err = InfoMessage.fatalV((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, (String)"%s", (Object[])new Object[]{e.getMessage()}).withPos(e.getErrorLine(), -1);
            checking.status.topLevelMessages.addMessage(err);
        }
        catch (Exception e) {
            logger.error((Object)"Pig preprocessor error", (Throwable)e);
            checking.status.topLevelMessages.withFatalV((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, "%s", new Object[]{e.getMessage()});
        }
        return checking;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCheckPig_NT(PigCheckContext checking) throws Exception {
        checking.proceed = false;
        HProxyKernelHandle hproxyKernel = (HProxyKernelHandle)this.hproxyKernelsManager.acquireKernel(checking.clusterSettings);
        try {
            String preprocessedScript = checking.preprocessor.getPreprocessed();
            checking.rawPigResponse = (ValidationResult)hproxyKernel.getAPIClient().postFormToJSON("pig/check", ValidationResult.class, new Object[]{"query", preprocessedScript});
            checking.status.relationSchemas = checking.rawPigResponse.relationSchemas;
            if (checking.rawPigResponse.ok) {
                checking.proceed = true;
            } else {
                InfoMessage err = InfoMessage.fatalV((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, (String)"%s", (Object[])new Object[]{checking.rawPigResponse.errorMessage}).withPos(checking.rawPigResponse.errorLine, checking.rawPigResponse.errorOffset);
                checking.status.topLevelMessages.addMessage(err);
            }
        }
        finally {
            this.hproxyKernelsManager.releaseKernel(hproxyKernel);
        }
    }

    public void finishCheckPig_NG(PigCheckContext ctx) throws Exception {
        TransactionContext.assertNoAttachedTransaction();
        logger.infoV("Finish check pig:\nrawPigResponse: %s\nstatus:%s", new Object[]{JSON.json((Object)ctx.rawPigResponse), JSON.json((Object)ctx.status)});
        List<PigSchemaTools.Suggestion> suggestions = null;
        try (Transaction t = this.transactionService.beginRead();){
            suggestions = PigSchemaTools.generateSuggestions(this.datasetsDAO, ctx.subgraph.getTargetsMap(), ctx.rawPigResponse.relationSchemas, ctx.preprocessor.getDkuStoreMapping());
        }
        catch (PigSchemaTools.PigSchemaCoercionException e) {
            ctx.status.topLevelMessages.withFatalV((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, "%s", new Object[]{e.getMessage()});
            return;
        }
        logger.info((Object)("Status after:" + JSON.json((Object)ctx.status)));
        logger.info((Object)("Suggestions: " + JSON.json(suggestions)));
        for (PigSchemaTools.Suggestion sugg : suggestions) {
            assert (sugg.reasons.size() > 0);
            RecipeSchemaService.ComputableSchemaAutoupdateResult dsRet = RecipeSchemaService.ComputableSchemaAutoupdateResult.forDataset(sugg.dataset.name, sugg.reasons, sugg.dataset.getSchema());
            this.recipeSchemaService.fillAutoupdateFlags(dsRet, Dataset.fromSerialized(sugg.dataset));
            ++ctx.status.schemaResult.totalIncompatibilities;
            ctx.status.schemaResult.computables.add(dsRet);
        }
        if (ctx.status.schemaResult.totalIncompatibilities > 0) {
            ctx.status.topLevelMessages.withFatalV((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, "Schema is incompatible", new Object[0]);
        }
    }

    public static class PigCheckContext {
        public boolean proceed;
        public PigRecipeStatus status;
        PigScriptPreprocessor preprocessor;
        ValidationResult rawPigResponse;
        RecipeRunnableSubgraph subgraph;
        ClusterSettings clusterSettings;
    }

    public static class PigRecipeStatus
    extends CodeBasedRecipeStatus {
        public RecipeSchemaService.RecipeSchemaAutoupdateResult schemaResult = new RecipeSchemaService.RecipeSchemaAutoupdateResult();
        public List<FieldDescription> relationSchemas = new ArrayList<FieldDescription>();
    }
}

