/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.common;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.queries.ExecutionPlanService;
import com.dataiku.dip.recipes.common.RecipeEngineStatus;
import com.dataiku.dip.recipes.common.RecipeStatusComputer;
import com.dataiku.dip.recipes.visualsql.VisualSQLRecipeEngineParams;
import com.dataiku.dip.recipes.visualsql.VisualSQLRecipeStatus;
import com.dataiku.dip.recipes.visualsql.VisualSQLRecipesBaseService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.sql.H2SQLDialect;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class VisualSQLRecipeStatusComputer
extends RecipeStatusComputer {
    @Autowired
    protected VisualSQLRecipesBaseService visualRecipesService;
    @Autowired
    protected VariablesService variablesService;

    public VisualSQLRecipeStatusComputer(SerializedRecipe recipe, String payload) {
        super(recipe, payload);
    }

    public abstract VisualSQLRecipeStatus getStatusForConversion_NT(AuthCtx var1) throws Exception;

    protected boolean needToComputeExecutionPlan(VisualSQLRecipesBaseService.SQLBasedEngineStatus selectedEngine, VisualSQLRecipeStatus status, VisualSQLRecipeStatus.VisualSQLRecipeStatusRequest request) {
        if (StringUtils.isBlank((String)status.sql)) {
            return false;
        }
        return this.needToComputeExecutionPlan(selectedEngine, request);
    }

    protected boolean needToComputeExecutionPlan(VisualSQLRecipesBaseService.SQLBasedEngineStatus selectedEngine, VisualSQLRecipeStatus.VisualSQLRecipeStatusRequest request) {
        if (!selectedEngine.queryBased) {
            return false;
        }
        if (selectedEngine.type.equals("SPARK")) {
            return false;
        }
        return VisualSQLRecipeStatusComputer.needToComputeExecutionPlanBasedOnEngine(selectedEngine, request != null && request.reallyNeedsExecutionPlan);
    }

    public static boolean needToComputeExecutionPlanBasedOnEngine(RecipeEngineStatus selectedEngine, boolean reallyNeedsExecutionPlan) {
        if (selectedEngine.type.equals("SQL")) {
            boolean alwaysComputeExecutionPlanForSQL = ApplicationConfigurator.getParams().getBoolParam("dku.recipes.visual.alwaysComputeSQLExecutionPlan", false);
            return alwaysComputeExecutionPlanForSQL || reallyNeedsExecutionPlan;
        }
        if (selectedEngine.type.equals("HIVE")) {
            boolean alwaysComputeExecutionPlanForHive = ApplicationConfigurator.getParams().getBoolParam("dku.recipes.visual.alwaysComputeHiveExecutionPlan", false);
            return alwaysComputeExecutionPlanForHive || reallyNeedsExecutionPlan;
        }
        if (selectedEngine.type.equals("IMPALA")) {
            boolean alwaysComputeExecutionPlanForImpala = ApplicationConfigurator.getParams().getBoolParam("dku.recipes.visual.alwaysComputeImpalaExecutionPlan", false);
            return alwaysComputeExecutionPlanForImpala || reallyNeedsExecutionPlan;
        }
        return true;
    }

    protected ExecutionPlanService.ExecutionPlan getExecutionPlan(AuthCtx authCtx, List<Dataset> inputDatasets, VisualSQLRecipesBaseService.SQLBasedEngineStatus engine, String sql, VisualSQLRecipeEngineParams engineParams) throws Exception {
        VariablesContext vc = this.variablesService.getForProject(this.recipe.getProjectKey());
        return this.visualRecipesService.getExecutionPlan(authCtx, engine, this.recipe, inputDatasets, vc.expand(sql), engineParams);
    }

    protected ExecutionPlanService.ExecutionPlan getExecutionPlan(AuthCtx authCtx, Dataset inputDataset, VisualSQLRecipesBaseService.SQLBasedEngineStatus engine, String sql, VisualSQLRecipeEngineParams engineParams) throws Exception {
        return this.getExecutionPlan(authCtx, Lists.newArrayList((Object[])new Dataset[]{inputDataset}), engine, sql, engineParams);
    }

    protected String formatDatabaseErrorMsg(String msg, SQLDialect dialect) {
        int index;
        String ret = msg;
        if (dialect instanceof H2SQLDialect && (index = msg.indexOf(59)) > 0) {
            ret = msg.substring(0, index);
        }
        return ret;
    }
}

