/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.eda.stats;

import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.eda.compute.computations.Computation;
import com.dataiku.dip.eda.compute.computations.ComputationResult;
import com.dataiku.dip.eda.compute.stats.LeveneCenter;
import com.dataiku.dip.recipes.eda.StatsTestRecipePayloadParams;
import com.dataiku.dip.utils.ImmutableValueObject;
import com.dataiku.dip.utils.JSON;
import com.dataiku.j2ts.annotations.UIModel;
import com.google.gson.annotations.SerializedName;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;

@UIModel
public abstract class AbstractTestStat
extends ImmutableValueObject {
    public abstract Computation getComputationPlan(StatsTestRecipePayloadParams<?> var1);

    public abstract List<Row> extractRows(ComputationResult var1, StatsTestRecipePayloadParams<?> var2, ColumnFactory var3, RowFactory var4);

    protected abstract void fillTestParams(Row var1, ColumnFactory var2);

    protected Row rowBase(double significanceLevel, Collection<String> warnings, Collection<String> errors, ColumnFactory cf, RowFactory rf) {
        Row row = rf.row();
        this.fillTestParams(row, cf);
        row.put(cf.column("significance_level"), significanceLevel);
        if (!warnings.isEmpty()) {
            row.put(cf.column("warnings"), JSON.json(warnings));
        }
        if (!errors.isEmpty()) {
            row.put(cf.column("errors"), JSON.json(errors));
        }
        return row;
    }

    protected static String conclusion(double pValue, double significanceLevel) {
        return pValue < significanceLevel ? "REJECTED" : "INCONCLUSIVE";
    }

    protected static class LeveneCenterSettings {
        @SerializedName(value="center")
        public LeveneCenter center;
        @SerializedName(value="proportion_to_trim")
        @Nullable
        public Double proportionToTrim;

        public LeveneCenterSettings(LeveneCenter center, @Nullable Double proportionToTrim) {
            this.center = center;
            this.proportionToTrim = proportionToTrim;
        }
    }

    protected static class DifferenceOfMeansCI {
        @SerializedName(value="difference_of_sample_means")
        public double differenceOfSampleMeans;
        @SerializedName(value="confidence_level")
        public double confidenceLevel;
        @SerializedName(value="ci_lower_bound")
        @Nullable
        public Double ciLower;
        @SerializedName(value="ci_upper_bound")
        @Nullable
        public Double ciUpper;

        public DifferenceOfMeansCI(double differenceOfSampleMeans, double confidenceLevel, @Nullable Double ciLower, @Nullable Double ciUpper) {
            this.differenceOfSampleMeans = differenceOfSampleMeans;
            this.confidenceLevel = confidenceLevel;
            this.ciLower = ciLower;
            this.ciUpper = ciUpper;
        }
    }

    protected static class SampleMeanCI {
        @SerializedName(value="sample_mean")
        public double sampleMean;
        @SerializedName(value="confidence_level")
        public double confidenceLevel;
        @SerializedName(value="ci_lower_bound")
        @Nullable
        public Double ciLower;
        @SerializedName(value="ci_upper_bound")
        @Nullable
        public Double ciUpper;

        public SampleMeanCI(double sampleMean, double confidenceLevel, @Nullable Double ciLower, @Nullable Double ciUpper) {
            this.sampleMean = sampleMean;
            this.confidenceLevel = confidenceLevel;
            this.ciLower = ciLower;
            this.ciUpper = ciUpper;
        }
    }
}

