/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sanitycheck.detectors;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.sanitycheck.SanityCheckDetectorBase;
import com.dataiku.dip.sanitycheck.SanityCheckInfoMessages;
import com.dataiku.dip.sanitycheck.detectors.ContainerExecInformation;
import com.dataiku.dip.sanitycheck.detectors.DockerImageInformation;
import com.dataiku.dip.sanitycheck.detectors.ExecutionException;
import com.dataiku.dip.sanitycheck.detectors.InstallationInformation;
import com.dataiku.dip.utils.DKULogger;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ParametersAreNonnullByDefault
public class CustomBaseImageDetector
implements SanityCheckDetectorBase {
    private final DockerImageInformation dockerImageInformation;
    private final InstallationInformation installationInformation;
    private final ContainerExecInformation containerExecInformation;
    private static final DKULogger logger = DKULogger.getLogger((String)"dip.sanitycheck.custombaseimagedetector");

    @Autowired
    CustomBaseImageDetector(DockerImageInformation dockerImageInformation, InstallationInformation installationInformation, ContainerExecInformation containerExecInformation) {
        this.dockerImageInformation = dockerImageInformation;
        this.installationInformation = installationInformation;
        this.containerExecInformation = containerExecInformation;
    }

    public List<InfoMessage.MessageCode> getCodes() {
        return Arrays.asList(Codes.values());
    }

    public SanityCheckInfoMessages runAnalysis(Set<String> exclusionList) {
        SanityCheckInfoMessages messages = new SanityCheckInfoMessages();
        if (exclusionList.containsAll(Arrays.stream(Codes.values()).map(InfoMessage.MessageCode::getCode).collect(Collectors.toList()))) {
            return messages;
        }
        try {
            this.generateWarningMessages().filter(message -> !exclusionList.contains(message.code)).forEach(arg_0 -> ((SanityCheckInfoMessages)messages).addMessage(arg_0));
        }
        catch (InternalException e) {
            logger.warn((Object)"Sanity check failed", (Throwable)e);
            messages.addMessage(this.createFatalMessage(e));
        }
        return messages;
    }

    private Stream<InfoMessage> generateWarningMessages() {
        String currentDssVersion = this.installationInformation.getDssVersion();
        return this.getAllCustomBaseImages().stream().flatMap(imageId -> {
            try {
                return this.generateWarningMessage((String)imageId, currentDssVersion).stream();
            }
            catch (ExecutionException e) {
                logger.warn((Object)"Sanity check failed", (Throwable)e);
                return Stream.of(this.createFatalMessage(e));
            }
        });
    }

    private Optional<InfoMessage> generateWarningMessage(String imageId, String currentDssVersion) throws ExecutionException {
        Optional<String> imageVersionOptional = this.dockerImageInformation.getDssVersion(imageId);
        if (imageVersionOptional.isPresent()) {
            return imageVersionOptional.filter(imageVersion -> !imageVersion.equals(currentDssVersion)).map(imageVersion -> InfoMessage.warning((InfoMessage.MessageCode)Codes.WARN_MISC_BASE_IMAGE_FROM_OLDER_DSS_IMAGE, (String)String.format("The image '%s' was built with a base image from DSS version %s. Please rebuild with a base image from current version.", imageId, imageVersion)));
        }
        return Optional.of(InfoMessage.warning((InfoMessage.MessageCode)Codes.WARN_MISC_BASE_IMAGE_NOT_FOUND, (String)String.format("The image %s does not exist.", imageId)));
    }

    private Set<String> getAllCustomBaseImages() {
        try {
            return this.containerExecInformation.getGlobalContainerSettings().executionConfigs.stream().flatMap(containerConfig -> Optional.ofNullable(containerConfig.baseImage).stream()).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
    }

    public static enum Codes implements InfoMessage.MessageCode
    {
        WARN_MISC_BASE_IMAGE_FROM_OLDER_DSS_IMAGE("Base Image - Custom Base Image was built with an older DSS Version.", InfoMessage.FixabilityCategory.ADMIN_TROUBLESHOOTING),
        WARN_MISC_BASE_IMAGE_NOT_FOUND("Base Image - Custom Base Image not found.", InfoMessage.FixabilityCategory.ADMIN_TROUBLESHOOTING);

        private final String title;
        private final InfoMessage.FixabilityCategory fixability;

        private Codes(String title, InfoMessage.FixabilityCategory fixability) {
            this.title = title;
            this.fixability = fixability;
        }

        public String getCode() {
            return this.name();
        }

        public String getCodeTitle() {
            return this.title;
        }

        public InfoMessage.FixabilityCategory getFixability() {
            return this.fixability;
        }
    }

    private static class InternalException
    extends RuntimeException {
        InternalException(Throwable throwable) {
            super(throwable);
        }
    }
}

