/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.reports;

import com.dataiku.dip.scheduler.reports.DistillationUnit;
import com.dataiku.dip.scheduler.reports.ReportItem;
import com.dataiku.dip.scheduler.reports.ReportTargetItem;
import com.dataiku.dip.server.notifications.VariableLookup;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class ItemsSummaryDistillation
implements DistillationUnit {
    private final String eol = System.getProperty("line.separator");
    private final ReportItem.Outcome outcome;
    private final String variable;
    List<String> steps = Lists.newArrayList();

    public ItemsSummaryDistillation(ReportItem.Outcome outcome, String variable) {
        this.outcome = outcome;
        this.variable = variable;
    }

    @Override
    public void getResult(VariableLookup lookup) {
        if (this.steps.size() > 0) {
            lookup.addVariable(this.variable, Joiner.on((String)this.eol).join(this.steps));
        }
    }

    private String getTargetDescription(ReportItem item) {
        HashMap info;
        ReportTargetItem target = item.getTargetItem();
        HashMap hashMap = info = item.info != null ? item.info : new HashMap();
        if (target instanceof ReportTargetItem.DatasetItem) {
            ReportTargetItem.DatasetItem ct = (ReportTargetItem.DatasetItem)target;
            return ct.datasetName + " in " + ct.projectKey;
        }
        if (target instanceof ReportTargetItem.DatasetPartitionItem) {
            ReportTargetItem.DatasetPartitionItem ct = (ReportTargetItem.DatasetPartitionItem)target;
            return ct.datasetName + " in " + ct.projectKey + " (" + ct.partition + ")";
        }
        if (target instanceof ReportTargetItem.ScenarioItem) {
            ReportTargetItem.ScenarioItem ct = (ReportTargetItem.ScenarioItem)target;
            if (info.get("deleted") != null) {
                return "deleted scenario " + ct.scenarioId + " in " + ct.projectKey;
            }
            return String.valueOf(info.get("name")) + " in " + ct.projectKey;
        }
        if (target instanceof ReportTargetItem.SavedModelItem) {
            ReportTargetItem.SavedModelItem ct = (ReportTargetItem.SavedModelItem)target;
            if (info.get("deleted") != null) {
                return "deleted model " + ct.modelId + " in " + ct.projectKey;
            }
            return String.valueOf(info.get("name")) + " in " + ct.projectKey;
        }
        if (target instanceof ReportTargetItem.StreamingEndpointItem) {
            ReportTargetItem.StreamingEndpointItem ct = (ReportTargetItem.StreamingEndpointItem)target;
            return ct.streamingEndpointId + " in " + ct.projectKey;
        }
        if (target instanceof ReportTargetItem.SavedModelPartitionItem) {
            ReportTargetItem.SavedModelPartitionItem ct = (ReportTargetItem.SavedModelPartitionItem)target;
            if (info.get("deleted") != null) {
                return "deleted model " + ct.modelId + " in " + ct.projectKey;
            }
            return String.valueOf(info.get("name")) + " in " + ct.projectKey;
        }
        if (target instanceof ReportTargetItem.ManagedFolderItem) {
            ReportTargetItem.ManagedFolderItem ct = (ReportTargetItem.ManagedFolderItem)target;
            if (info.get("deleted") != null) {
                return "deleted folder " + ct.folderId + " in " + ct.projectKey;
            }
            return String.valueOf(info.get("name")) + " in " + ct.projectKey;
        }
        if (target instanceof ReportTargetItem.ManagedFolderPartitionItem) {
            ReportTargetItem.ManagedFolderPartitionItem ct = (ReportTargetItem.ManagedFolderPartitionItem)target;
            if (info.get("deleted") != null) {
                return "deleted folder " + ct.folderId + " in " + ct.projectKey;
            }
            return String.valueOf(info.get("name")) + " in " + ct.projectKey + " (" + ct.partition + ")";
        }
        if (target instanceof ReportTargetItem.ScenarioStepItem) {
            ReportTargetItem.ScenarioStepItem ct = (ReportTargetItem.ScenarioStepItem)target;
            if (info.get("scenarioDeleted") != null) {
                return "step from deleted scenario " + ct.scenarioId + " in " + ct.projectKey;
            }
            Object name = info.get("name");
            return (name != null ? name.toString() : "*unnamed*") + " in scenario " + String.valueOf(info.get("scenarioName")) + " in " + ct.projectKey;
        }
        if (target instanceof ReportTargetItem.ScenarioTriggerItem) {
            ReportTargetItem.ScenarioTriggerItem ct = (ReportTargetItem.ScenarioTriggerItem)target;
            if (info.get("scenarioDeleted") != null) {
                return "trigger from deleted scenario " + ct.scenarioId + " in " + ct.projectKey;
            }
            Object name = info.get("name");
            return (name != null ? name.toString() : "*unnamed*") + " in scenario " + String.valueOf(info.get("scenarioName")) + " in " + ct.projectKey;
        }
        if (target instanceof ReportTargetItem.InsightItem) {
            ReportTargetItem.InsightItem ct = (ReportTargetItem.InsightItem)target;
            if (info.get("insightDeleted") != null) {
                return "delete insight " + ct.insightId + " in " + ct.projectKey;
            }
            Object name = info.get("name");
            return (name != null ? name.toString() : "*unnamed*") + " in " + ct.projectKey;
        }
        if (target instanceof ReportTargetItem.WebAppItem) {
            ReportTargetItem.WebAppItem ct = (ReportTargetItem.WebAppItem)target;
            if (info.get("webAppDeleted") != null) {
                return "deleted webapp" + ct.webAppId + " in " + ct.projectKey;
            }
            Object name = info.get("name");
            return (name != null ? name.toString() : "*unnamed*") + " in " + ct.projectKey;
        }
        if (target instanceof ReportTargetItem.CodeStudioItem) {
            ReportTargetItem.CodeStudioItem ct = (ReportTargetItem.CodeStudioItem)target;
            if (info.get("codeStudioDeleted") != null) {
                return "deleted Code Studio" + ct.codeStudioId + " in " + ct.projectKey;
            }
            Object name = info.get("name");
            return (name != null ? name.toString() : "*unnamed*") + " in " + ct.projectKey;
        }
        if (target instanceof ReportTargetItem.DashboardExportItem) {
            ReportTargetItem.DashboardExportItem ct = (ReportTargetItem.DashboardExportItem)target;
            return "dashboard " + ct.dashboardName + " in " + ct.projectKey + " into folder " + ct.folderName;
        }
        if (target instanceof ReportTargetItem.WikiArticleExportItem) {
            ReportTargetItem.WikiArticleExportItem ct = (ReportTargetItem.WikiArticleExportItem)target;
            return "wiki article " + ct.articleName + " in " + ct.projectKey + " into folder " + ct.folderName;
        }
        if (target instanceof ReportTargetItem.WikiExportItem) {
            ReportTargetItem.WikiExportItem ct = (ReportTargetItem.WikiExportItem)target;
            return "wiki of project " + ct.projectKey + " into folder " + ct.folderName;
        }
        if (target instanceof ReportTargetItem.SQLConnectionItem) {
            ReportTargetItem.SQLConnectionItem ct = (ReportTargetItem.SQLConnectionItem)target;
            return "SQL connection " + ct.connection;
        }
        if (target instanceof ReportTargetItem.LambdaServiceItem) {
            ReportTargetItem.LambdaServiceItem lp = (ReportTargetItem.LambdaServiceItem)target;
            return "API service " + lp.serviceId + (String)(StringUtils.isNotBlank((String)lp.projectKey) ? " in " + lp.projectKey : "");
        }
        if (target instanceof ReportTargetItem.BundleItem) {
            ReportTargetItem.BundleItem bundleItem = (ReportTargetItem.BundleItem)target;
            return "bundle " + bundleItem.bundleId + " on " + bundleItem.projectKey;
        }
        if (target instanceof ReportTargetItem.PythonItem) {
            return "python";
        }
        if (target instanceof ReportTargetItem.InlineHtmlItem) {
            return "html";
        }
        if (target instanceof ReportTargetItem.InlineResultTableItem) {
            return "result table";
        }
        if (target instanceof ReportTargetItem.KeptFileItem) {
            return "file";
        }
        if (target instanceof ReportTargetItem.UrlItem) {
            return "url";
        }
        if (target instanceof ReportTargetItem.ProjectItem) {
            return ((ReportTargetItem.ProjectItem)target).projectKey;
        }
        if (target instanceof ReportTargetItem.ClusterItem) {
            return ((ReportTargetItem.ClusterItem)target).clusterId;
        }
        if (target instanceof ReportTargetItem.ContinuousActivityItem) {
            return ((ReportTargetItem.ContinuousActivityItem)target).continuousActivityId;
        }
        if (target instanceof ReportTargetItem.FlowDocumentationExportItem) {
            ReportTargetItem.FlowDocumentationExportItem t = (ReportTargetItem.FlowDocumentationExportItem)target;
            return "flow documentation of project " + t.projectKey + " into folder " + t.folderName;
        }
        return "";
    }

    @Override
    public void handle(ReportItem item) throws IOException, SQLException {
        if (this.outcome != null && item.getOutcome() != this.outcome) {
            return;
        }
        Object message = item.getOutcome() == null ? "\t\t" : item.getOutcome().name() + "\t";
        double duration = (item.end - item.start) / 1000L;
        message = (String)message + duration + "s\t";
        if (!(item instanceof ReportItem.ScenarioDone)) {
            message = (String)message + "\t";
            if (!(item instanceof ReportItem.StepDone)) {
                message = (String)message + "\t";
            }
        }
        switch (item.getType()) {
            case BUILT_DATASET: {
                message = (String)message + "Build dataset " + this.getTargetDescription(item);
                break;
            }
            case BUILT_MODEL: {
                message = (String)message + "Build saved model " + this.getTargetDescription(item);
                break;
            }
            case BUILT_FOLDER: {
                message = (String)message + "Build managed folder " + this.getTargetDescription(item);
                break;
            }
            case BUILT_STREAMING_ENDPOINT: {
                message = (String)message + "Build streaming endpoint " + this.getTargetDescription(item);
                break;
            }
            case BUILT_RETRIEVABLE_KNOWLEDGE: {
                message = (String)message + "Build knowledge bank " + this.getTargetDescription(item);
                break;
            }
            case CHECKED_DATASET: {
                message = (String)message + "Check dataset " + this.getTargetDescription(item);
                break;
            }
            case CHECKED_FLOW_ELEMENT_CONSISTENCY: {
                message = (String)message + "Check consistency of flow element " + this.getTargetDescription(item);
                break;
            }
            case SYNCED_DATASET: {
                message = (String)message + "Synchronize Hive table of dataset " + this.getTargetDescription(item);
                break;
            }
            case UPDATED_FROM_HIVE: {
                message = (String)message + "Resynchronize dataset " + this.getTargetDescription(item) + " from Hive table";
                break;
            }
            case COMPUTED_METRICS: {
                message = (String)message + "Compute statistics of dataset " + this.getTargetDescription(item);
                break;
            }
            case SCENARIO_DONE: {
                message = (String)message + "Scenario " + this.getTargetDescription(item) + " run as " + ((ReportItem.ScenarioDone)item).login;
                break;
            }
            case TRIGGER_FIRED: {
                message = (String)message + "Trigger " + this.getTargetDescription(item);
                break;
            }
            case STEP_DONE: {
                message = (String)message + "Step " + this.getTargetDescription(item);
                break;
            }
            case CODE_EXECUTED: {
                message = (String)message + "Execute script on " + this.getTargetDescription(item);
                break;
            }
            case JOB_EXECUTED: {
                message = (String)message + "Run job " + ((ReportItem.JobExecuted)item).jobId;
                break;
            }
            case CREATED_JUPYTER_EXPORT: {
                message = (String)message + "Refresh insight " + this.getTargetDescription(item);
                break;
            }
            case MADE_LAMBDA_PACKAGE: {
                message = (String)message + "Packaged " + this.getTargetDescription(item);
                break;
            }
            case MADE_BUNDLE: {
                message = (String)message + "Created " + this.getTargetDescription(item);
                break;
            }
            case PUBLISHED_LAMBDA_PACKAGE: 
            case PUBLISHED_BUNDLE: {
                message = (String)message + "Published " + this.getTargetDescription(item);
                break;
            }
            case PRODUCED_BY_RUNNABLE: {
                message = (String)message + "Produced a " + this.getTargetDescription(item);
                break;
            }
            case RESTART_WEBAPP: {
                message = (String)message + "Restarted web app backend " + this.getTargetDescription(item) + " as " + ((ReportItem.RestartedWebApp)item).runAs;
                break;
            }
            case RESTART_CODE_STUDIO: {
                message = (String)message + "Restarted Code Studio " + this.getTargetDescription(item);
                break;
            }
            case BUILT_REPORT: {
                message = (String)message + "Built RMarkdown report " + this.getTargetDescription(item) + " as " + ((ReportItem.BuiltReport)item).runAs;
                break;
            }
            case CREATED_RMARKDOWN_EXPORT: {
                message = (String)message + "Created new RMarkdown export for " + this.getTargetDescription(item);
                break;
            }
            case CREATED_DASHBOARD_EXPORT: {
                message = (String)message + "Created new Dashboard export for " + this.getTargetDescription(item);
                break;
            }
            case CREATED_WIKI_EXPORT: {
                message = (String)message + "Created new Wiki export for " + this.getTargetDescription(item);
                break;
            }
            case CREATED_WIKI_ARTICLE_EXPORT: {
                message = (String)message + "Created new Wiki article export for " + this.getTargetDescription(item);
                break;
            }
            case CREATED_FLOW_DOCUMENTATION_EXPORT: {
                message = (String)message + "Created new flow documentation export for " + this.getTargetDescription(item);
                break;
            }
            case SET_UP_CLUSTER: {
                message = (String)message + "Set up cluster" + this.getTargetDescription(item);
                break;
            }
            case TORE_DOWN_CLUSTER: {
                message = (String)message + "Tore down cluster" + this.getTargetDescription(item);
                break;
            }
            case STARTED_CLUSTER: {
                message = (String)message + "Started cluster" + this.getTargetDescription(item);
                break;
            }
            case STOPPED_CLUSTER: {
                message = (String)message + "Stopped cluster" + this.getTargetDescription(item);
                break;
            }
            case STARTED_CONTINUOUS_ACTIVITY: {
                message = (String)message + "Started continuous activity" + this.getTargetDescription(item);
                break;
            }
            case STOPPED_CONTINUOUS_ACTIVITY: {
                message = (String)message + "Stopped continuous activity" + this.getTargetDescription(item);
            }
        }
        if (item.getOutcome() != ReportItem.Outcome.SUCCESS) {
            if (item.thrown != null) {
                message = (String)message + this.eol + item.thrown.message;
            }
            if (item.logTail != null) {
                for (String line : item.logTail.lines) {
                    message = (String)message + this.eol + line;
                }
            }
        }
        this.steps.add((String)message);
    }
}

