/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security.secretsstorage;

import com.dataiku.dip.security.secretsstorage.SecretsFetcher;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelibazure.com.azure.core.credential.TokenCredential;
import com.dataiku.dss.shadelibazure.com.azure.identity.ClientCertificateCredentialBuilder;
import com.dataiku.dss.shadelibazure.com.azure.identity.ClientSecretCredentialBuilder;
import com.dataiku.dss.shadelibazure.com.azure.identity.ManagedIdentityCredentialBuilder;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.secrets.SecretClient;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.secrets.SecretClientBuilder;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.secrets.models.KeyVaultSecret;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.net.util.Base64;

public class AzureKeyvaultSecretFetcher
implements SecretsFetcher {
    private Settings settings;
    private SecretClient secretClient;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.security.encryption.azurekeyvault");

    @Override
    public void init(String fetcherParams) throws Exception {
        this.settings = (Settings)JSON.parse((String)fetcherParams, Settings.class);
        String keyvaultUri = "https://" + this.settings.kevaultName + ".vault.azure.net";
        TokenCredential credential = this.getCredential(this.settings);
        this.secretClient = new SecretClientBuilder().vaultUrl(keyvaultUri).credential(credential).buildClient();
    }

    private TokenCredential getCredential(Settings settings) throws IOException {
        if (StringUtils.isNotEmpty((String)settings.managedIdentityId)) {
            logger.info((Object)"Using Managed Identity authentication.");
            return new ManagedIdentityCredentialBuilder().resourceId(settings.managedIdentityId).build();
        }
        if (StringUtils.isNotEmpty((String)settings.clientSecret)) {
            logger.info((Object)"Using Client Secret authentication.");
            return ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().clientId(settings.clientId)).tenantId(settings.domain)).clientSecret(settings.clientSecret).build();
        }
        if (StringUtils.isNotEmpty((String)settings.certificatePath)) {
            logger.info((Object)"Using Client Certificate authentication.");
            return ((ClientCertificateCredentialBuilder)((ClientCertificateCredentialBuilder)new ClientCertificateCredentialBuilder().clientId(settings.clientId)).tenantId(settings.domain)).pfxCertificate(settings.certificatePath).clientCertificatePassword(settings.password).build();
        }
        logger.error((Object)"No valid authentication method provided.");
        throw new IllegalStateException("No valid authentication method provided. Please provide either Managed Identity ID, Client Secret, or Client Certificate.");
    }

    @Override
    public byte[] fetchSecretBytes(String secretName) {
        long startTime = System.currentTimeMillis();
        KeyVaultSecret secret = this.secretClient.getSecret(secretName);
        long endTime = System.currentTimeMillis();
        logger.infoV("Acquired secret in %d ms", new Object[]{endTime - startTime});
        return Base64.decodeBase64((String)secret.getValue());
    }

    static class Settings {
        String clientId;
        String domain;
        String clientSecret;
        String certificatePath;
        String password;
        String managedIdentityId;
        String kevaultName;
        String secretName;

        Settings() {
        }
    }
}

